/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.portal;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.application.registry.Application;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.config.model.CloneApplicationState;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.webui.application.PortletState;
import org.exoplatform.portal.webui.application.UIApplicationList;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.container.UIContainerList;
import org.exoplatform.portal.webui.login.UILogin;
import org.exoplatform.portal.webui.login.UIResetPassword;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageBody;
import org.exoplatform.portal.webui.portal.UILanguageSelector;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.portal.UIPortalComponent;
import org.exoplatform.portal.webui.portal.UIPortalComposer;
import org.exoplatform.portal.webui.portal.UIPortalForm;
import org.exoplatform.portal.webui.portal.UISkinSelector;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIEditInlineWorkspace;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIPortalToolPanel;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.web.security.GateInToken;
import org.exoplatform.web.security.security.RemindPasswordTokenService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UITabPane;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

public class UIPortalComponentActionListener {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditPortalPropertiesActionListener
    extends EventListener<UIPortal> {
        public void execute(Event<UIPortal> event) throws Exception {
            String portalName = event.getRequestContext().getRequestParameter("portalName");
            UIPortal uiPortal = Util.getUIPortal();
            UIPortalApplication uiApp = (UIPortalApplication)uiPortal.getAncestorOfType(UIPortalApplication.class);
            UserPortalConfigService service = (UserPortalConfigService)uiApp.getApplicationComponent(UserPortalConfigService.class);
            if (portalName != null && service.getUserPortalConfig(portalName, event.getRequestContext().getRemoteUser()) == null) {
                uiApp.addMessage(new ApplicationMessage("UISiteManagement.msg.portal-not-exist", (Object[])new String[]{portalName}));
                return;
            }
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiApp.getChildById("UIMaskWorkspace");
            UIPortalForm portalForm = uiMaskWS.createUIComponent(UIPortalForm.class, null, "UIPortalForm");
            portalForm.setPortalOwner(portalName);
            portalForm.setBindingBean();
            uiMaskWS.setWindowSize(700, -1);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeApplicationListActionListener
    extends EventListener<UIPortal> {
        public void execute(Event<UIPortal> event) throws Exception {
            UIPortal uiPortal = (UIPortal)((Object)event.getSource());
            UIPortalApplication application = (UIPortalApplication)uiPortal.getAncestorOfType(UIPortalApplication.class);
            UIPortalComposer composer = (UIPortalComposer)application.findFirstComponentOfType(UIPortalComposer.class);
            UITabPane uiTabPane = (UITabPane)composer.getChild(UITabPane.class);
            String appListId = ((UIApplicationList)uiTabPane.getChild(UIApplicationList.class)).getId();
            uiTabPane.replaceChild(appListId, composer.createUIComponent(UIApplicationList.class, null, null));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeSkinActionListener
    extends EventListener<UIPortal> {
        public void execute(Event<UIPortal> event) throws Exception {
            UIPortal uiPortal = (UIPortal)((Object)event.getSource());
            UIPortalApplication uiApp = (UIPortalApplication)uiPortal.getAncestorOfType(UIPortalApplication.class);
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiApp.getChildById("UIMaskWorkspace");
            UISkinSelector uiChangeSkin = uiMaskWS.createUIComponent(UISkinSelector.class, null, null);
            uiMaskWS.setUIComponent((UIComponent)uiChangeSkin);
            uiMaskWS.setWindowSize(640, 400);
            uiMaskWS.setShow(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RecoveryPasswordAndUsernameActionListener
    extends EventListener<UIPortal> {
        public void execute(Event<UIPortal> event) throws Exception {
            String tokenId;
            UIPortal uiPortal = (UIPortal)((Object)event.getSource());
            RemindPasswordTokenService tokenService = (RemindPasswordTokenService)uiPortal.getApplicationComponent(RemindPasswordTokenService.class);
            GateInToken token = tokenService.getToken(tokenId = event.getRequestContext().getRequestParameter("tokenId"));
            if (token == null) {
                WebuiRequestContext requestContext = event.getRequestContext();
                requestContext.getUIApplication().addMessage(new ApplicationMessage("UIForgetPassword.msg.expration", null));
                requestContext.addUIComponentToUpdateByAjax(uiPortal.getParent());
                return;
            }
            UIPortalApplication uiApp = (UIPortalApplication)uiPortal.getAncestorOfType(UIPortalApplication.class);
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiApp.getChildById("UIMaskWorkspace");
            OrganizationService orgSrc = (OrganizationService)uiPortal.getApplicationComponent(OrganizationService.class);
            User user = orgSrc.getUserHandler().findUserByName(token.getPayload().getUsername());
            UIResetPassword uiReset = uiMaskWS.createUIComponent(UIResetPassword.class, null, null);
            uiReset.setUser(user);
            uiReset.setTokenId(tokenId);
            uiMaskWS.setUIComponent((UIComponent)uiReset);
            uiMaskWS.setWindowSize(630, -1);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeLanguageActionListener
    extends EventListener<UIPortal> {
        public void execute(Event<UIPortal> event) throws Exception {
            UIPortal uiPortal = (UIPortal)((Object)event.getSource());
            UIPortalApplication uiPortalApp = (UIPortalApplication)uiPortal.getAncestorOfType(UIPortalApplication.class);
            UIMaskWorkspace uiMaskWorkspace = (UIMaskWorkspace)uiPortalApp.getChildById("UIMaskWorkspace");
            uiMaskWorkspace.createUIComponent(UILanguageSelector.class, null, null);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMaskWorkspace);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MoveChildActionListener
    extends EventListener<org.exoplatform.webui.core.UIContainer> {
        public void execute(Event<org.exoplatform.webui.core.UIContainer> event) throws Exception {
            UIWorkingWorkspace uiWorkingWS;
            UIComponent uiWorking;
            PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
            String insertPosition = pcontext.getRequestParameter("insertPosition");
            int position = -1;
            try {
                position = Integer.parseInt(insertPosition);
            }
            catch (Exception exp) {
                position = -1;
            }
            boolean newComponent = false;
            String paramNewComponent = pcontext.getRequestParameter("newComponent");
            if (paramNewComponent != null) {
                newComponent = Boolean.valueOf(paramNewComponent);
            }
            UIPortalApplication uiApp = (UIPortalApplication)((org.exoplatform.webui.core.UIContainer)event.getSource()).getAncestorOfType(UIPortalApplication.class);
            UIPortalComposer portalComposer = (UIPortalComposer)uiApp.findFirstComponentOfType(UIPortalComposer.class);
            if (newComponent) {
                portalComposer.updateWorkspaceComponent();
                pcontext.setFullRender(true);
            }
            if (!(uiWorking = (uiWorkingWS = (UIWorkingWorkspace)uiApp.getChild(UIWorkingWorkspace.class)).findFirstComponentOfType(UIPortalToolPanel.class)).isRendered()) {
                UIEditInlineWorkspace uiEditWS = (UIEditInlineWorkspace)uiWorkingWS.getChild(UIEditInlineWorkspace.class);
                uiWorking = uiEditWS.getUIComponent();
            }
            String sourceId = pcontext.getRequestParameter("srcID");
            Object uiSource = uiWorking.findComponentById(sourceId);
            org.exoplatform.webui.core.UIContainer uiTarget = (org.exoplatform.webui.core.UIContainer)uiWorking.findComponentById(pcontext.getRequestParameter("targetID"));
            if (position < 0 && uiTarget.getChildren().size() > 0) {
                position = uiTarget.getChildren().size();
            } else if (position < 0) {
                position = 0;
            }
            if (uiSource == null) {
                UITabPane subTabPane = (UITabPane)portalComposer.getChild(UITabPane.class);
                UIContainerList uiContainerConfig = (UIContainerList)subTabPane.getChild(UIContainerList.class);
                if (uiContainerConfig != null && subTabPane.getSelectedTabId().equals(uiContainerConfig.getId())) {
                    String[] accessPers;
                    UIContainer uiContainer = (UIContainer)uiTarget.createUIComponent(UIContainer.class, null, null);
                    Container container = uiContainerConfig.getContainer(sourceId);
                    container.setId(String.valueOf(container.hashCode()));
                    uiContainer.setStorageId(container.getStorageId());
                    PortalDataMapper.toUIContainer(uiContainer, container);
                    for (String accessPer : accessPers = uiContainer.getAccessPermissions()) {
                        if (!accessPer.equals("")) continue;
                        accessPer = null;
                    }
                    if (accessPers == null || accessPers.length == 0) {
                        accessPers = new String[]{"Everyone"};
                    }
                    uiContainer.setAccessPermissions(accessPers);
                    uiSource = uiContainer;
                } else {
                    String[] accessPers;
                    Application app = null;
                    UIApplicationList appList = (UIApplicationList)uiApp.findFirstComponentOfType(UIApplicationList.class);
                    app = appList.getApplication(sourceId);
                    ApplicationType applicationType = app.getType();
                    UIPortlet uiPortlet = (UIPortlet)uiTarget.createUIComponent(UIPortlet.class, null, null);
                    if (app.getDisplayName() != null) {
                        uiPortlet.setTitle(app.getDisplayName());
                    } else if (app.getApplicationName() != null) {
                        uiPortlet.setTitle(app.getApplicationName());
                    }
                    uiPortlet.setDescription(app.getDescription());
                    ArrayList accessPersList = app.getAccessPermissions();
                    for (String accessPer : accessPers = accessPersList.toArray(new String[accessPersList.size()])) {
                        if (!accessPer.equals("")) continue;
                        accessPers = null;
                    }
                    if (accessPers == null || accessPers.length == 0) {
                        accessPers = new String[]{"Everyone"};
                    }
                    uiPortlet.setAccessPermissions(accessPers);
                    UIPage uiPage = (UIPage)uiTarget.getAncestorOfType(UIPage.class);
                    if ("dashboard/DashboardPortlet".equals(app.getContentId())) {
                        TransientApplicationState state = new TransientApplicationState(app.getContentId());
                        uiPortlet.setState(new PortletState(state, applicationType));
                    } else {
                        CloneApplicationState state = new CloneApplicationState(app.getStorageId());
                        uiPortlet.setState(new PortletState(state, applicationType));
                    }
                    uiPortlet.setPortletInPortal(uiTarget instanceof UIPortal);
                    uiPortlet.setShowEditControl(true);
                    uiSource = uiPortlet;
                }
                List children = uiTarget.getChildren();
                uiSource.setParent((UIComponent)uiTarget);
                children.add(position, uiSource);
                return;
            }
            org.exoplatform.webui.core.UIContainer uiParent = (org.exoplatform.webui.core.UIContainer)uiSource.getParent();
            if (uiParent == uiTarget) {
                int currentIdx = uiTarget.getChildren().indexOf(uiSource);
                if (position <= currentIdx) {
                    uiTarget.getChildren().add(position, uiSource);
                    uiTarget.getChildren().remove(++currentIdx);
                    return;
                }
                uiTarget.getChildren().remove(currentIdx);
                if (position >= uiTarget.getChildren().size()) {
                    position = uiTarget.getChildren().size();
                }
                uiTarget.getChildren().add(position, uiSource);
                return;
            }
            uiParent.getChildren().remove(uiSource);
            uiTarget.getChildren().add(position, uiSource);
            uiSource.setParent((UIComponent)uiTarget);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteComponentActionListener
    extends EventListener<UIComponent> {
        private static final String UI_CONTAINER_PREFIX = "UIContainer-";
        private static final String UI_PORTLET_PREFIX = "UIPortlet-";

        public void execute(Event<UIComponent> event) throws Exception {
            String id = event.getRequestContext().getRequestParameter("objectId");
            UIComponent uiComponent = (UIComponent)event.getSource();
            UIPortalComponent uiParent = (UIPortalComponent)uiComponent.getParent();
            UIComponent uiRemoveComponent = uiParent.findComponentById(id);
            UIPortalApplication uiApp = Util.getUIPortalApplication();
            if (uiRemoveComponent.findFirstComponentOfType(UIPageBody.class) != null) {
                uiApp.addMessage(new ApplicationMessage("UIPortalApplication.msg.deletePageBody", new Object[0], 1));
                return;
            }
            uiParent.removeChildById(id);
            UIPortalComposer portalComposer = (UIPortalComposer)uiApp.findFirstComponentOfType(UIPortalComposer.class);
            portalComposer.setEditted(true);
            UIPage uiPage = (UIPage)uiParent.getAncestorOfType(UIPage.class);
            if (uiPage != null && uiPage.getMaximizedUIPortlet() != null) {
                if (id.equals(uiPage.getMaximizedUIPortlet().getId())) {
                    uiPage.setMaximizedUIPortlet(null);
                }
            } else {
                UIPortal uiPortal = Util.getUIPortal();
                if (uiPortal != null && uiPortal.getMaximizedUIComponent() != null) {
                    if (id.equals(uiPortal.getMaximizedUIComponent().getId())) {
                        uiPortal.setMaximizedUIComponent(null);
                    }
                } else {
                    UIPageBody uiPageBody = (UIPageBody)uiPortal.findFirstComponentOfType(UIPageBody.class);
                    if (uiPageBody != null && uiPageBody.getMaximizedUIComponent() != null && id.equals(uiPageBody.getMaximizedUIComponent().getId())) {
                        uiPageBody.setMaximizedUIComponent(null);
                    }
                }
            }
            Util.showComponentLayoutMode(uiRemoveComponent.getClass());
            PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
            if (uiComponent instanceof UIPortlet) {
                this.removeComponent(id, UI_PORTLET_PREFIX, pcontext);
                return;
            }
            if (uiComponent instanceof UIContainer) {
                UIContainer topAncestor = DeleteComponentActionListener.getTopBlockContainer((UIContainer)uiParent);
                if (topAncestor == null) {
                    this.removeComponent(id, UI_CONTAINER_PREFIX, pcontext);
                    return;
                }
                String topAncestorId = topAncestor.getId();
                if (topAncestor.getChildren().size() == 0) {
                    org.exoplatform.webui.core.UIContainer parentOfTopAncestor = (org.exoplatform.webui.core.UIContainer)topAncestor.getParent();
                    parentOfTopAncestor.removeChildById(topAncestorId);
                    if (topAncestorId.startsWith(UI_CONTAINER_PREFIX)) {
                        topAncestorId = topAncestorId.substring(UI_CONTAINER_PREFIX.length());
                        topAncestor.setId(topAncestorId);
                    }
                    this.removeComponent(topAncestorId, UI_CONTAINER_PREFIX, pcontext);
                    return;
                }
                if (uiParent.getChildren().size() == 0) {
                    org.exoplatform.webui.core.UIContainer itsParent = (org.exoplatform.webui.core.UIContainer)uiParent.getParent();
                    itsParent.removeChildById(uiParent.getId());
                }
                if (!topAncestorId.startsWith(UI_CONTAINER_PREFIX)) {
                    topAncestor.setId(UI_CONTAINER_PREFIX + topAncestorId);
                }
                pcontext.addUIComponentToUpdateByAjax((UIComponent)topAncestor);
                return;
            }
        }

        private void removeComponent(String componentId, String componentType, PortalRequestContext pcontext) {
            String scriptRemovingComponent = this.scriptRemovingComponent(componentId, componentType);
            JavascriptManager jsManager = pcontext.getJavascriptManager();
            jsManager.addJavascript((CharSequence)scriptRemovingComponent);
            jsManager.addJavascript((CharSequence)"eXo.portal.UIPortal.changeComposerSaveButton();");
        }

        private String scriptRemovingComponent(String componentId, String prefix) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("eXo.portal.UIPortal.removeComponent('");
            buffer.append(prefix);
            buffer.append(componentId);
            buffer.append("');");
            return buffer.toString();
        }

        private static UIContainer getTopBlockContainer(UIContainer container) {
            if (container instanceof UIPortal || container instanceof UIPage) {
                return null;
            }
            UIContainer topAncestor = container;
            try {
                UIContainer intermediateCont = (UIContainer)topAncestor.getParent();
                while (intermediateCont != null && !(intermediateCont instanceof UIPortal) && !(intermediateCont instanceof UIPage)) {
                    topAncestor = intermediateCont;
                    intermediateCont = (UIContainer)topAncestor.getParent();
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            return topAncestor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShowLoginFormActionListener
    extends EventListener<UIPortalComponent> {
        public void execute(Event<UIPortalComponent> event) throws Exception {
            UIPortal uiPortal = Util.getUIPortal();
            UIPortalApplication uiApp = (UIPortalApplication)uiPortal.getAncestorOfType(UIPortalApplication.class);
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiApp.getChildById("UIMaskWorkspace");
            UILogin uiLogin = uiMaskWS.createUIComponent(UILogin.class, null, null);
            uiMaskWS.setUIComponent((UIComponent)uiLogin);
            uiMaskWS.setWindowSize(630, -1);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewChildActionListener
    extends EventListener<org.exoplatform.webui.core.UIContainer> {
        public void execute(Event<org.exoplatform.webui.core.UIContainer> event) throws Exception {
            org.exoplatform.webui.core.UIContainer uiContainer = (org.exoplatform.webui.core.UIContainer)event.getSource();
            String id = event.getRequestContext().getRequestParameter("objectId");
            uiContainer.setRenderedChild(id);
        }
    }
}

