/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.metamodel.mapping;

import org.chromattic.api.RelationshipType;
import org.chromattic.metamodel.bean.MultiValuedPropertyInfo;
import org.chromattic.metamodel.bean.PropertyInfo;
import org.chromattic.metamodel.bean.SimpleType;
import org.chromattic.metamodel.bean.SimpleValueInfo;
import org.chromattic.metamodel.bean.SingleValuedPropertyInfo;
import org.chromattic.metamodel.bean.ValueInfo;
import org.chromattic.metamodel.mapping.NodeTypeMapping;
import org.chromattic.metamodel.mapping.PropertyMapping;
import org.chromattic.metamodel.mapping.TypeMappingDomain;
import org.chromattic.metamodel.mapping.jcr.JCRNodeAttributeMapping;
import org.chromattic.metamodel.mapping.jcr.JCRPropertyMapping;
import org.chromattic.metamodel.mapping.value.AbstractManyToOneMapping;
import org.chromattic.metamodel.mapping.value.AbstractOneToManyMapping;
import org.chromattic.metamodel.mapping.value.AbstractOneToOneMapping;
import org.chromattic.metamodel.mapping.value.NamedManyToOneMapping;
import org.chromattic.metamodel.mapping.value.NamedOneToManyMapping;
import org.chromattic.metamodel.mapping.value.NamedOneToOneMapping;
import org.chromattic.metamodel.mapping.value.PropertyMapMapping;
import org.chromattic.metamodel.mapping.value.RelationshipMapping;
import org.chromattic.metamodel.mapping.value.SimpleMapping;
import org.chromattic.metamodel.mapping.value.ValueMapping;
import org.reflext.api.ClassTypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseTypeMappingVisitor {
    private final TypeMappingDomain builder = new TypeMappingDomain(false);

    public void addType(ClassTypeInfo cti) {
        this.builder.add(cti);
    }

    protected NodeTypeMapping getMapping(ClassTypeInfo type) {
        return this.builder.get(type);
    }

    protected void start() {
    }

    protected void startMapping(NodeTypeMapping mapping) {
    }

    protected <V> void propertyMapping(ClassTypeInfo definer, JCRPropertyMapping<V> propertyMapping, PropertyInfo<SimpleValueInfo<V>> propertyInfo) {
    }

    protected void propertyMapMapping(ClassTypeInfo definer) {
    }

    protected void oneToManyByReference(ClassTypeInfo definer, String relatedName, NodeTypeMapping relatedMapping) {
    }

    protected void oneToManyByPath(ClassTypeInfo definer, String relatedName, NodeTypeMapping relatedMapping) {
    }

    protected void oneToManyHierarchic(ClassTypeInfo definer, NodeTypeMapping relatedMapping) {
    }

    protected void manyToOneByReference(ClassTypeInfo definer, String name, NodeTypeMapping relatedMapping) {
    }

    protected void manyToOneByPath(ClassTypeInfo definer, String name, NodeTypeMapping relatedMapping) {
    }

    protected void manyToOneHierarchic(ClassTypeInfo definer, NodeTypeMapping relatedMapping) {
    }

    protected void oneToOneHierarchic(ClassTypeInfo definer, String name, NodeTypeMapping relatedMapping, boolean owner) {
    }

    protected void endMapping() {
    }

    protected void end() {
    }

    public void generate() {
        this.start();
        for (NodeTypeMapping mapping : this.builder.build()) {
            this.startMapping(mapping);
            block21: for (PropertyMapping<? extends ValueMapping> propertyMapping : mapping.getPropertyMappings()) {
                ValueMapping valueMapping = propertyMapping.getValueMapping();
                ClassTypeInfo definer = valueMapping.getDefiner();
                if (valueMapping instanceof SimpleMapping) {
                    Object valueInfo;
                    SimpleMapping simpleMapping = (SimpleMapping)valueMapping;
                    PropertyInfo<ValueInfo> propertyInfo = propertyMapping.getInfo();
                    Object memberMapping = simpleMapping.getJCRMember();
                    if (memberMapping instanceof JCRPropertyMapping) {
                        valueInfo = propertyInfo instanceof SingleValuedPropertyInfo ? ((SingleValuedPropertyInfo)propertyInfo).getValue() : ((MultiValuedPropertyInfo)propertyInfo).getValue();
                        if (valueInfo instanceof SimpleValueInfo) {
                            this.propertyMapping(definer, (JCRPropertyMapping)memberMapping, propertyInfo);
                            continue;
                        }
                        throw new AssertionError();
                    }
                    if (memberMapping instanceof JCRNodeAttributeMapping) {
                        if (propertyInfo instanceof SingleValuedPropertyInfo) {
                            valueInfo = ((SingleValuedPropertyInfo)propertyInfo).getValue();
                            if (valueInfo instanceof SimpleValueInfo) {
                                SimpleValueInfo simpleValueInfo = (SimpleValueInfo)valueInfo;
                                SimpleType simpleType = simpleValueInfo.getSimpleType();
                                if (simpleType != SimpleType.STRING && simpleType != SimpleType.PATH) {
                                    throw new AssertionError((Object)(mapping.getType().toString() + " wrong simple type " + simpleType));
                                }
                                continue;
                            }
                            throw new AssertionError();
                        }
                        throw new AssertionError();
                    }
                    throw new AssertionError(mapping.getType());
                }
                if (valueMapping instanceof RelationshipMapping) {
                    String name;
                    RelationshipMapping relationshipMapping = (RelationshipMapping)valueMapping;
                    NodeTypeMapping relatedMapping = relationshipMapping.getRelatedMapping();
                    RelationshipType type = relationshipMapping.getType();
                    if (valueMapping instanceof AbstractOneToManyMapping) {
                        if (valueMapping instanceof NamedOneToManyMapping) {
                            NamedOneToManyMapping namedOneToManyMapping = (NamedOneToManyMapping)valueMapping;
                            switch (type) {
                                case REFERENCE: {
                                    this.oneToManyByReference(definer, namedOneToManyMapping.getName(), relatedMapping);
                                    break;
                                }
                                case PATH: {
                                    this.oneToManyByPath(definer, namedOneToManyMapping.getName(), relatedMapping);
                                    break;
                                }
                                default: {
                                    throw new AssertionError();
                                }
                            }
                            continue;
                        }
                        switch (type) {
                            case HIERARCHIC: {
                                this.oneToManyHierarchic(definer, relationshipMapping.getRelatedMapping());
                                continue block21;
                            }
                            default: {
                                throw new AssertionError();
                            }
                        }
                    }
                    if (valueMapping instanceof AbstractManyToOneMapping) {
                        if (valueMapping instanceof NamedManyToOneMapping) {
                            NamedManyToOneMapping namedManyToOneMapping = (NamedManyToOneMapping)valueMapping;
                            name = namedManyToOneMapping.getRelatedName();
                            switch (type) {
                                case REFERENCE: {
                                    this.manyToOneByReference(definer, name, relatedMapping);
                                    break;
                                }
                                case PATH: {
                                    this.manyToOneByPath(definer, name, relatedMapping);
                                    break;
                                }
                                default: {
                                    throw new AssertionError();
                                }
                            }
                            continue;
                        }
                        switch (type) {
                            case HIERARCHIC: {
                                this.manyToOneHierarchic(definer, relatedMapping);
                                continue block21;
                            }
                            default: {
                                throw new AssertionError();
                            }
                        }
                    }
                    if (valueMapping instanceof AbstractOneToOneMapping) {
                        if (valueMapping instanceof NamedOneToOneMapping) {
                            NamedOneToOneMapping namedOneToOneMapping = (NamedOneToOneMapping)valueMapping;
                            name = namedOneToOneMapping.getName();
                            switch (type) {
                                case HIERARCHIC: {
                                    this.oneToOneHierarchic(definer, name, relationshipMapping.getRelatedMapping(), namedOneToOneMapping.isOwning());
                                    break;
                                }
                                default: {
                                    throw new AssertionError();
                                }
                            }
                            continue;
                        }
                        switch (type) {
                            case EMBEDDED: {
                                continue block21;
                            }
                            default: {
                                throw new AssertionError();
                            }
                        }
                    }
                    throw new AssertionError();
                }
                if (valueMapping instanceof PropertyMapMapping) {
                    this.propertyMapMapping(definer);
                    continue;
                }
                throw new AssertionError();
            }
            this.endMapping();
        }
        this.end();
    }
}

