/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.conf;

import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class RecountActiveUserJob
implements Job {
    private static Log log_ = ExoLogger.getLogger((String)"job.forum.RecountActiveUserJob");

    public void execute(JobExecutionContext context) throws JobExecutionException {
        block7: {
            try {
                int days;
                JobDataMap jdatamap;
                String lastPost;
                ExoContainer exoContainer = org.exoplatform.ks.common.Utils.getExoContainer((JobExecutionContext)context);
                ForumService forumService = (ForumService)exoContainer.getComponentInstanceOfType(ForumService.class);
                if (forumService != null && (lastPost = (jdatamap = context.getJobDetail().getJobDataMap()).getString("lastPost")) != null && lastPost.length() > 0 && (days = Integer.parseInt(lastPost)) > 0) {
                    long oneDay = 86400000L;
                    Calendar calendar = GregorianCalendar.getInstance();
                    long currentDay = calendar.getTimeInMillis();
                    calendar.setTimeInMillis(currentDay -= (long)days * oneDay);
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("//element(*,").append(Utils.USER_PROFILES_TYPE).append(")[").append("@exo:lastPostDate >= xs:dateTime('").append(ISO8601.format((Calendar)calendar)).append("')]");
                    forumService.evaluateActiveUsers(stringBuilder.toString());
                    if (log_.isDebugEnabled()) {
                        log_.debug((Object)"\n\n The RecoundActiveUserJob have been done");
                    }
                }
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
            }
            catch (RepositoryException e) {
                if (log_.isDebugEnabled()) {
                    log_.debug((Object)("\n\n Job run so quick " + e.getMessage()));
                }
            }
            catch (Exception e) {
                if (!log_.isDebugEnabled()) break block7;
                log_.debug((Object)("\n\n The have exception " + e.getMessage()));
            }
        }
    }
}

