/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.lock;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.config.LockPersisterEntry;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.dataflow.TransactionChangesLog;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.lock.LockData;
import org.exoplatform.services.jcr.impl.core.lock.LockPersister;
import org.exoplatform.services.jcr.impl.core.query.SearchManager;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.WorkspacePersistentDataManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class FileSystemLockPersister
implements LockPersister {
    private static final String PARAM_ROOT_DIR = "path";
    private final Log log = ExoLogger.getLogger((String)"jcr.lock.LockPersister");
    private File rootDir;
    private final WorkspacePersistentDataManager dataManager;
    private final LockPersisterEntry config;

    public FileSystemLockPersister(WorkspacePersistentDataManager dataManager, WorkspaceEntry config) throws RepositoryConfigurationException, RepositoryException {
        this.dataManager = dataManager;
        this.config = config.getLockManager().getPersister();
        this.init();
    }

    public FileSystemLockPersister(WorkspacePersistentDataManager dataManager, WorkspaceEntry config, SearchManager searchManager) throws RepositoryConfigurationException, RepositoryException {
        this.dataManager = dataManager;
        this.config = config.getLockManager().getPersister();
        this.init();
    }

    public void add(LockData lock) throws LockException {
        this.log.debug((Object)"add event fire");
        File lockFile = new File(this.rootDir, lock.getNodeIdentifier());
        if (lockFile.exists()) {
            throw new LockException("Persistent lock information already exists");
        }
        try {
            lockFile.createNewFile();
        }
        catch (IOException e) {
            throw new LockException((Throwable)e);
        }
    }

    public void remove(LockData lock) throws LockException {
        this.log.debug((Object)"remove event fire");
        File lockFile = new File(this.rootDir, lock.getNodeIdentifier());
        if (!lockFile.exists()) {
            this.log.warn((Object)("Persistent lock information  for node " + lock.getNodeIdentifier() + " doesn't exists"));
            return;
        }
        if (!lockFile.delete()) {
            throw new LockException("Fail to remove lock information");
        }
    }

    public void removeAll() throws LockException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Removing all locks");
        }
        TransactionChangesLog transactionChangesLog = new TransactionChangesLog();
        String[] list = this.rootDir.list();
        try {
            int i;
            for (i = 0; i < list.length; ++i) {
                PropertyData dataLockOwner;
                PlainChangesLogImpl plainChangesLog = new PlainChangesLogImpl(new ArrayList<ItemState>(), SystemIdentity.SYSTEM, 0x800000);
                NodeData lockedNodeData = (NodeData)this.dataManager.getItemData(list[i]);
                if (lockedNodeData == null) continue;
                PropertyData dataLockIsDeep = (PropertyData)this.dataManager.getItemData(lockedNodeData, new QPathEntry(Constants.JCR_LOCKISDEEP, 0));
                if (dataLockIsDeep != null) {
                    plainChangesLog.add(ItemState.createDeletedState(new TransientPropertyData(QPath.makeChildPath(lockedNodeData.getQPath(), Constants.JCR_LOCKISDEEP), dataLockIsDeep.getIdentifier(), 0, dataLockIsDeep.getType(), dataLockIsDeep.getParentIdentifier(), dataLockIsDeep.isMultiValued())));
                }
                if ((dataLockOwner = (PropertyData)this.dataManager.getItemData(lockedNodeData, new QPathEntry(Constants.JCR_LOCKOWNER, 0))) != null) {
                    plainChangesLog.add(ItemState.createDeletedState(new TransientPropertyData(QPath.makeChildPath(lockedNodeData.getQPath(), Constants.JCR_LOCKOWNER), dataLockOwner.getIdentifier(), 0, dataLockOwner.getType(), dataLockOwner.getParentIdentifier(), dataLockOwner.isMultiValued())));
                }
                if (plainChangesLog.getSize() <= 0) continue;
                transactionChangesLog.addLog(plainChangesLog);
            }
            if (transactionChangesLog.getSize() > 0) {
                this.dataManager.save(transactionChangesLog);
            }
            for (i = 0; i < list.length; ++i) {
                File lockFile = new File(this.rootDir, list[i]);
                if (!lockFile.exists()) {
                    this.log.warn((Object)("Persistent lock information for node id " + list[i] + " doesn't exists"));
                }
                if (lockFile.delete()) continue;
                throw new LockException("Fail to remove lock information");
            }
        }
        catch (RepositoryException e) {
            this.log.error((Object)("Unable to remove lock files due to error " + (Object)((Object)e)), (Throwable)e);
            throw new LockException((Throwable)e);
        }
    }

    public void start() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Starting FileSystemLockPersister");
        }
        try {
            this.removeAll();
        }
        catch (LockException e) {
            this.log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void stop() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Stoping FileSystemLockPersister");
        }
        try {
            this.removeAll();
        }
        catch (LockException e) {
            this.log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"FileSystemLockPersister stoped");
        }
    }

    private void init() throws RepositoryConfigurationException, RepositoryException {
        String root = this.config.getParameterValue(PARAM_ROOT_DIR);
        if (root == null) {
            throw new RepositoryConfigurationException("Repository service configuration. Source name (path) is expected");
        }
        this.rootDir = new File(root);
        if (this.rootDir.exists()) {
            if (!this.rootDir.isDirectory()) {
                throw new RepositoryConfigurationException("'" + root + "' is not a directory");
            }
        } else if (!this.rootDir.mkdirs()) {
            throw new RepositoryException("Can't create dir" + root);
        }
    }
}

