/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.jbosscache;

import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.jcr.config.QueryHandlerEntry;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.impl.core.query.IndexerChangesFilter;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoMode;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoModeHandler;
import org.exoplatform.services.jcr.impl.core.query.IndexingTree;
import org.exoplatform.services.jcr.impl.core.query.QueryHandler;
import org.exoplatform.services.jcr.impl.core.query.SearchManager;
import org.exoplatform.services.jcr.impl.core.query.jbosscache.ChangesFilterListsWrapper;
import org.exoplatform.services.jcr.impl.core.query.jbosscache.IndexerCacheLoader;
import org.exoplatform.services.jcr.impl.core.query.jbosscache.IndexerSingletonStoreCacheLoader;
import org.exoplatform.services.jcr.impl.core.query.jbosscache.JBossCacheIndexInfos;
import org.exoplatform.services.jcr.impl.core.query.jbosscache.JBossCacheIndexUpdateMonitor;
import org.exoplatform.services.jcr.jbosscache.ExoJBossCacheFactory;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.CacheLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossCacheIndexChangesFilter
extends IndexerChangesFilter {
    private final Log log = ExoLogger.getLogger(JBossCacheIndexChangesFilter.class);
    private final Cache<Serializable, Object> cache;
    public static final String LISTWRAPPER = "$lists".intern();

    public JBossCacheIndexChangesFilter(SearchManager searchManager, SearchManager parentSearchManager, QueryHandlerEntry config, IndexingTree indexingTree, IndexingTree parentIndexingTree, QueryHandler handler, QueryHandler parentHandler, ConfigurationManager cfm) throws IOException, RepositoryException, RepositoryConfigurationException {
        super(searchManager, parentSearchManager, config, indexingTree, parentIndexingTree, handler, parentHandler, cfm);
        ExoJBossCacheFactory factory = new ExoJBossCacheFactory(cfm);
        this.cache = factory.createCache(config);
        IndexerCacheLoader indexerCacheLoader = new IndexerCacheLoader();
        indexerCacheLoader.init(searchManager, parentSearchManager, handler, parentHandler);
        CacheLoaderConfig.IndividualCacheLoaderConfig.SingletonStoreConfig singletonStoreConfig = new CacheLoaderConfig.IndividualCacheLoaderConfig.SingletonStoreConfig();
        singletonStoreConfig.setSingletonStoreClass(IndexerSingletonStoreCacheLoader.class.getName());
        Properties singletonStoreProperties = new Properties();
        Boolean pushState = config.getParameterBoolean("jbosscache-sscl-push.state.enabled", false);
        Integer pushStateTimeOut = config.getParameterInteger("jbosscache-sscl-push.state.timeout", 10000);
        singletonStoreProperties.setProperty("pushStateWhenCoordinator", pushState.toString());
        singletonStoreProperties.setProperty("pushStateWhenCoordinatorTimeout", pushStateTimeOut.toString());
        singletonStoreConfig.setProperties(singletonStoreProperties);
        singletonStoreConfig.setSingletonStoreEnabled(true);
        CacheLoaderConfig.IndividualCacheLoaderConfig individualCacheLoaderConfig = new CacheLoaderConfig.IndividualCacheLoaderConfig();
        individualCacheLoaderConfig.setSingletonStoreConfig(singletonStoreConfig);
        individualCacheLoaderConfig.setCacheLoader((CacheLoader)indexerCacheLoader);
        individualCacheLoaderConfig.setFetchPersistentState(false);
        individualCacheLoaderConfig.setAsync(false);
        individualCacheLoaderConfig.setIgnoreModifications(false);
        individualCacheLoaderConfig.setPurgeOnStartup(false);
        CacheLoaderConfig cacheLoaderConfig = new CacheLoaderConfig();
        cacheLoaderConfig.setShared(false);
        cacheLoaderConfig.setPassivation(false);
        cacheLoaderConfig.addIndividualCacheLoaderConfig(individualCacheLoaderConfig);
        this.cache.getConfiguration().setCacheLoaderConfig(cacheLoaderConfig);
        this.cache.create();
        this.cache.start();
        IndexerIoMode ioMode = ((CacheSPI)this.cache).getRPCManager().isCoordinator() ? IndexerIoMode.READ_WRITE : IndexerIoMode.READ_ONLY;
        IndexerIoModeHandler modeHandler = indexerCacheLoader.getModeHandler();
        handler.setIndexerIoModeHandler(modeHandler);
        parentHandler.setIndexerIoModeHandler(modeHandler);
        if (!parentHandler.isInitialized()) {
            parentHandler.setIndexInfos(new JBossCacheIndexInfos(this.cache, true, modeHandler));
            parentHandler.setIndexUpdateMonitor(new JBossCacheIndexUpdateMonitor(this.cache, true, modeHandler));
            parentHandler.init();
        }
        if (!handler.isInitialized()) {
            handler.setIndexInfos(new JBossCacheIndexInfos(this.cache, false, modeHandler));
            handler.setIndexUpdateMonitor(new JBossCacheIndexUpdateMonitor(this.cache, false, modeHandler));
            handler.init();
        }
    }

    @Override
    protected void doUpdateIndex(Set<String> removedNodes, Set<String> addedNodes, Set<String> parentRemovedNodes, Set<String> parentAddedNodes) {
        String id = IdGenerator.generate();
        try {
            this.cache.put(id, (Object)LISTWRAPPER, (Object)new ChangesFilterListsWrapper(addedNodes, removedNodes, parentAddedNodes, parentRemovedNodes));
        }
        catch (CacheException e) {
            this.log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            this.logErrorChanges(this.handler, removedNodes, addedNodes);
            this.logErrorChanges(this.parentHandler, parentRemovedNodes, parentAddedNodes);
        }
    }

    private void logErrorChanges(QueryHandler logHandler, Set<String> removedNodes, Set<String> addedNodes) {
        try {
            logHandler.logErrorChanges(addedNodes, removedNodes);
        }
        catch (IOException ioe) {
            this.log.warn((Object)("Exception occure when errorLog writed. Error log is not complete. " + ioe), (Throwable)ioe);
        }
    }
}

