/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.xml.importing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.jcr.NamespaceRegistry;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.ws.commons.util.Base64;
import org.exoplatform.services.jcr.access.AccessManager;
import org.exoplatform.services.jcr.core.ExtendedPropertyType;
import org.exoplatform.services.jcr.core.nodetype.NodeDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeData;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionDatas;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.core.value.BaseValue;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.ValueDataConvertor;
import org.exoplatform.services.jcr.impl.util.ISO9075;
import org.exoplatform.services.jcr.impl.util.StringConverter;
import org.exoplatform.services.jcr.impl.xml.importing.BaseXmlImporter;
import org.exoplatform.services.jcr.impl.xml.importing.dataflow.ImportNodeData;
import org.exoplatform.services.jcr.impl.xml.importing.dataflow.ImportPropertyData;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentViewImporter
extends BaseXmlImporter {
    private static Log log = ExoLogger.getLogger((String)"jcr.DocNodeImporter");
    private ImportPropertyData xmlCharactersProperty = null;
    private String xmlCharactersPropertyValue = null;

    public DocumentViewImporter(NodeData parent, QPath ancestorToSave, int uuidBehavior, ItemDataConsumer dataConsumer, NodeTypeDataManager ntManager, LocationFactory locationFactory, ValueFactoryImpl valueFactory, NamespaceRegistry namespaceRegistry, AccessManager accessManager, ConversationState userState, Map<String, Object> context, RepositoryImpl repository, String currentWorkspaceName) {
        super(parent, ancestorToSave, uuidBehavior, dataConsumer, ntManager, locationFactory, valueFactory, namespaceRegistry, accessManager, userState, context, repository, currentWorkspaceName);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws RepositoryException {
        StringBuilder text = new StringBuilder();
        text.append(ch, start, length);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Property:xmltext=" + text + " Parent=" + this.getParent().getQPath().getAsString()));
        }
        if (this.xmlCharactersProperty != null) {
            this.xmlCharactersPropertyValue = this.xmlCharactersPropertyValue + text.toString();
            this.xmlCharactersProperty.setValue(new TransientValueData(this.xmlCharactersPropertyValue));
        } else {
            TransientNodeData nodeData = TransientNodeData.createNodeData(this.getParent(), Constants.JCR_XMLTEXT, Constants.NT_UNSTRUCTURED, this.getNodeIndex(this.getParent(), Constants.JCR_XMLTEXT, null), this.getNextChildOrderNum(this.getParent()));
            this.changesLog.add(new ItemState(nodeData, 1, true, this.getAncestorToSave()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("New node " + nodeData.getQPath().getAsString()));
            }
            ImportPropertyData newProperty = new ImportPropertyData(QPath.makeChildPath(nodeData.getQPath(), Constants.JCR_PRIMARYTYPE), IdGenerator.generate(), 0, 7, nodeData.getIdentifier(), false);
            newProperty.setValue(new TransientValueData(Constants.NT_UNSTRUCTURED));
            this.changesLog.add(new ItemState(newProperty, 1, true, this.getAncestorToSave()));
            newProperty = new ImportPropertyData(QPath.makeChildPath(nodeData.getQPath(), Constants.JCR_XMLCHARACTERS), IdGenerator.generate(), 0, 1, nodeData.getIdentifier(), false);
            newProperty.setValue(new TransientValueData(text.toString()));
            this.changesLog.add(new ItemState(newProperty, 1, true, this.getAncestorToSave()));
            this.xmlCharactersProperty = newProperty;
            this.xmlCharactersPropertyValue = text.toString();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws RepositoryException {
        this.tree.pop();
        this.xmlCharactersProperty = null;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Map<String, String> atts) throws RepositoryException {
        String nodeName = ISO9075.decode(qName);
        if ("jcr:root".equals(nodeName)) {
            nodeName = "";
        }
        this.xmlCharactersProperty = null;
        ArrayList<NodeTypeData> nodeTypes = new ArrayList<NodeTypeData>();
        HashMap<InternalQName, String> propertiesMap = new HashMap<InternalQName, String>();
        ArrayList<InternalQName> mixinNodeTypes = new ArrayList<InternalQName>();
        InternalQName jcrName = this.locationFactory.parseJCRName(nodeName).getInternalName();
        this.parseAttr(atts, nodeTypes, mixinNodeTypes, propertiesMap, jcrName);
        ImportNodeData nodeData = this.createNode(nodeTypes, propertiesMap, mixinNodeTypes, jcrName);
        NodeData parentNodeData = this.getParent();
        this.changesLog.add(new ItemState(nodeData, 1, true, this.getAncestorToSave()));
        this.tree.push(nodeData);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Node : " + nodeData.getQPath().getAsString()));
        }
        Iterator<InternalQName> keys = propertiesMap.keySet().iterator();
        while (keys.hasNext()) {
            PropertyData newProperty = null;
            InternalQName propName = keys.next();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Property NAME: " + (Object)((Object)propName) + "=" + propertiesMap.get((Object)propName)));
            }
            if (propName.equals((Object)Constants.JCR_PRIMARYTYPE)) {
                InternalQName childName = this.locationFactory.parseJCRName(propertiesMap.get((Object)Constants.JCR_PRIMARYTYPE)).getInternalName();
                if (!this.nodeTypeDataManager.isChildNodePrimaryTypeAllowed(childName, parentNodeData.getPrimaryTypeName(), parentNodeData.getMixinTypeNames())) {
                    throw new ConstraintViolationException("Can't add node " + nodeData.getQName().getAsString() + " to " + parentNodeData.getQPath().getAsString() + " node type " + propertiesMap.get((Object)Constants.JCR_PRIMARYTYPE) + " is not allowed as child's node type for parent node type " + parentNodeData.getPrimaryTypeName().getAsString());
                }
                newProperty = this.endPrimaryType(nodeData.getPrimaryTypeName());
            } else if (propName.equals((Object)Constants.JCR_MIXINTYPES)) {
                newProperty = this.endMixinTypes(mixinNodeTypes, propName);
            } else if (nodeData.isMixReferenceable() && propName.equals((Object)Constants.JCR_UUID)) {
                newProperty = this.endUuid(nodeData, propName);
            } else {
                InternalQName[] nTypes = mixinNodeTypes.toArray(new InternalQName[mixinNodeTypes.size() + 1]);
                nTypes[nTypes.length - 1] = nodeData.getPrimaryTypeName();
                PropertyDefinitionDatas defs = this.nodeTypeDataManager.getPropertyDefinitions(propName, nTypes);
                if (defs == null || defs.getAnyDefinition() == null) {
                    if (!((Boolean)this.context.get("respectPropertyDefinitionsConstraints")).booleanValue()) {
                        log.warn((Object)("Property definition not found for " + propName.getAsString()));
                        continue;
                    }
                    throw new RepositoryException("Property definition not found for " + propName.getAsString());
                }
                PropertyDefinitionData pDef = defs.getAnyDefinition();
                if (pDef == null || defs == null) {
                    throw new RepositoryException("no propertyDefinition found");
                }
                if (pDef.getRequiredType() == 2) {
                    newProperty = this.endBinary(propertiesMap, newProperty, propName);
                } else {
                    int pType;
                    StringTokenizer spaceTokenizer = new StringTokenizer(propertiesMap.get((Object)propName));
                    ArrayList<ValueData> values = new ArrayList<ValueData>();
                    int n = pType = pDef.getRequiredType() > 0 ? pDef.getRequiredType() : 1;
                    if ("".equals(propertiesMap.get((Object)propName))) {
                        if (pType != 1) continue;
                        String denormalizeString = StringConverter.denormalizeString(propertiesMap.get((Object)propName));
                        Value value = this.valueFactory.createValue(denormalizeString, pType);
                        values.add(((BaseValue)value).getInternalData());
                        if (Constants.EXO_OWNER.equals((Object)propName)) {
                            nodeData.setExoOwner(denormalizeString);
                        }
                    } else {
                        ArrayList<String> denormalizeStrings = new ArrayList<String>();
                        while (spaceTokenizer.hasMoreTokens()) {
                            String elem = spaceTokenizer.nextToken();
                            String denormalizeString = StringConverter.denormalizeString(elem);
                            denormalizeStrings.add(denormalizeString);
                            Value value = this.valueFactory.createValue(denormalizeString, pType);
                            if (log.isDebugEnabled()) {
                                String valueAsString = null;
                                try {
                                    valueAsString = value.getString();
                                }
                                catch (Exception e) {
                                    log.error((Object)("Can't present value as string. " + e.getMessage()));
                                    valueAsString = "[Can't present value as string]";
                                }
                                log.debug((Object)("Property " + ExtendedPropertyType.nameFromValue(pType) + ": " + (Object)((Object)propName) + "=" + valueAsString));
                            }
                            values.add(((BaseValue)value).getInternalData());
                        }
                        if (pType == 100) {
                            nodeData.setExoPrivileges(denormalizeStrings);
                        } else if (Constants.EXO_OWNER.equals((Object)propName)) {
                            nodeData.setExoOwner((String)denormalizeStrings.get(0));
                        }
                    }
                    boolean isMultivalue = true;
                    if (values.size() == 1) {
                        if (defs.getDefinition(false) != null) {
                            isMultivalue = false;
                        }
                    } else if (defs.getDefinition(true) == null && defs.getDefinition(false) != null) {
                        throw new ValueFormatException("Can not assign multiple-values Value to a single-valued property " + propName.getAsString() + " node " + jcrName.getName());
                    }
                    newProperty = TransientPropertyData.createPropertyData(this.getParent(), propName, pType, isMultivalue, values);
                    if (nodeData.isMixVersionable()) {
                        this.endVersionable(nodeData, values, propName);
                    }
                }
            }
            if (!newProperty.getQPath().isDescendantOf(Constants.JCR_VERSION_STORAGE_PATH) && (Constants.JCR_VERSIONHISTORY.equals((Object)propName) || Constants.JCR_BASEVERSION.equals((Object)propName) || Constants.JCR_PREDECESSORS.equals((Object)propName))) continue;
            this.changesLog.add(new ItemState(newProperty, 1, true, this.getAncestorToSave()));
        }
        nodeData.setACL(this.initAcl(parentNodeData.getACL(), nodeData.isExoOwneable(), nodeData.isExoPrivilegeable(), nodeData.getExoOwner(), nodeData.getExoPrivileges()));
        if (nodeData.isMixVersionable()) {
            this.createVersionHistory(nodeData);
        }
    }

    private ImportNodeData createNode(List<NodeTypeData> nodeTypes, HashMap<InternalQName, String> propertiesMap, List<InternalQName> mixinNodeTypes, InternalQName jcrName) throws PathNotFoundException, IllegalPathException, RepositoryException {
        int i;
        ImportNodeData nodeData = new ImportNodeData(this.getParent(), jcrName, this.getNodeIndex(this.getParent(), jcrName, null));
        InternalQName[] allNodeTypes = new InternalQName[nodeTypes.size() + mixinNodeTypes.size()];
        for (i = 0; i < nodeTypes.size(); ++i) {
            allNodeTypes[i] = nodeTypes.get(i).getName();
        }
        for (i = 0; i < mixinNodeTypes.size(); ++i) {
            allNodeTypes[nodeTypes.size() + i] = mixinNodeTypes.get(i);
        }
        nodeData.setPrimaryTypeName(this.locationFactory.parseJCRName(propertiesMap.get((Object)Constants.JCR_PRIMARYTYPE)).getInternalName());
        nodeData.setOrderNumber(this.getNextChildOrderNum(this.getParent()));
        nodeData.setMixinTypeNames(mixinNodeTypes.toArray(new InternalQName[mixinNodeTypes.size()]));
        nodeData.setMixReferenceable(this.nodeTypeDataManager.isNodeType(Constants.MIX_REFERENCEABLE, allNodeTypes));
        nodeData.setIdentifier(IdGenerator.generate());
        if (nodeData.isMixReferenceable()) {
            nodeData.setMixVersionable(this.nodeTypeDataManager.isNodeType(Constants.MIX_VERSIONABLE, allNodeTypes));
            this.checkReferenceable(nodeData, propertiesMap.get((Object)Constants.JCR_UUID));
        }
        return nodeData;
    }

    private PropertyData endBinary(HashMap<InternalQName, String> propertiesMap, PropertyData newProperty, InternalQName propName) throws RepositoryException {
        try {
            newProperty = TransientPropertyData.createPropertyData(this.getParent(), propName, 2, false, new TransientValueData(0, Base64.decode((String)propertiesMap.get((Object)propName))));
        }
        catch (Base64.DecodingException e) {
            throw new RepositoryException((Throwable)e);
        }
        return newProperty;
    }

    private PropertyData endMixinTypes(List<InternalQName> mixinNodeTypes, InternalQName key) {
        ArrayList<ValueData> valuesData = new ArrayList<ValueData>(mixinNodeTypes.size());
        for (InternalQName mixinQname : mixinNodeTypes) {
            valuesData.add(new TransientValueData(mixinQname));
        }
        TransientPropertyData newProperty = TransientPropertyData.createPropertyData(this.getParent(), key, 7, true, valuesData);
        return newProperty;
    }

    private PropertyData endPrimaryType(InternalQName primaryTypeName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Property NAME: " + (Object)((Object)primaryTypeName)));
        }
        TransientPropertyData newProperty = TransientPropertyData.createPropertyData(this.getParent(), Constants.JCR_PRIMARYTYPE, 7, false, new TransientValueData(primaryTypeName));
        return newProperty;
    }

    private PropertyData endUuid(ImportNodeData nodeData, InternalQName key) throws ValueFormatException, UnsupportedRepositoryOperationException, RepositoryException, IllegalStateException {
        Value value = this.valueFactory.createValue(nodeData.getIdentifier(), 1);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Property STRING: " + (Object)((Object)key) + "=" + value.getString()));
        }
        TransientPropertyData newProperty = TransientPropertyData.createPropertyData(this.getParent(), Constants.JCR_UUID, 1, false, new TransientValueData(nodeData.getIdentifier()));
        return newProperty;
    }

    private void endVersionable(ImportNodeData nodeData, List<ValueData> values, InternalQName propName) throws RepositoryException {
        if (propName.equals((Object)Constants.JCR_VERSIONHISTORY)) {
            try {
                nodeData.setVersionHistoryIdentifier(ValueDataConvertor.readString(values.get(0)));
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
            nodeData.setContainsVersionhistory(this.dataConsumer.getItemData(nodeData.getVersionHistoryIdentifier()) != null);
        } else if (propName.equals((Object)Constants.JCR_BASEVERSION)) {
            try {
                nodeData.setBaseVersionIdentifier(ValueDataConvertor.readString(values.get(0)));
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
    }

    private void parseAttr(Map<String, String> atts, List<NodeTypeData> nodeTypes, List<InternalQName> mixinNodeTypes, HashMap<InternalQName, String> props, InternalQName nodeName) throws PathNotFoundException, RepositoryException {
        if (!atts.containsKey("jcr:primaryType")) {
            NodeData parent = this.getParent();
            NodeDefinitionData nodeNt = this.nodeTypeDataManager.getChildNodeDefinition(nodeName, parent.getPrimaryTypeName(), parent.getMixinTypeNames());
            NodeTypeData nodeType = nodeNt.getName().equals((Object)Constants.JCR_ANY_NAME) && nodeNt.getDefaultPrimaryType() != null ? this.nodeTypeDataManager.getNodeType(nodeNt.getDefaultPrimaryType()) : this.nodeTypeDataManager.getNodeType(nodeNt.getName());
            if (nodeType == null) {
                throw new ConstraintViolationException("Can not define node-type for node " + nodeName.getAsString() + ", parent node type " + parent.getPrimaryTypeName().getAsString());
            }
            nodeTypes.add(nodeType);
            props.put(Constants.JCR_PRIMARYTYPE, this.locationFactory.createJCRName(nodeType.getName()).getAsString());
        }
        if (atts != null) {
            for (String key : atts.keySet()) {
                InternalQName propInternalQName;
                String attValue = atts.get(key);
                String propName = ISO9075.decode(key);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(propName + ":" + attValue));
                }
                if (Constants.JCR_PRIMARYTYPE.equals((Object)(propInternalQName = this.locationFactory.parseJCRName(propName).getInternalName()))) {
                    String primaryNodeType = StringConverter.denormalizeString(attValue);
                    InternalQName ntName = this.locationFactory.parseJCRName(primaryNodeType).getInternalName();
                    NodeTypeData nodeType = this.nodeTypeDataManager.getNodeType(ntName);
                    if (nodeType == null) {
                        throw new ConstraintViolationException("Can not find node type " + primaryNodeType);
                    }
                    nodeTypes.add(nodeType);
                    props.put(propInternalQName, primaryNodeType);
                    continue;
                }
                if (Constants.JCR_MIXINTYPES.equals((Object)propInternalQName)) {
                    String[] amTypes = attValue.split(" ");
                    for (int mi = 0; mi < amTypes.length; ++mi) {
                        amTypes[mi] = StringConverter.denormalizeString(amTypes[mi]);
                        InternalQName name = this.locationFactory.parseJCRName(amTypes[mi]).getInternalName();
                        mixinNodeTypes.add(name);
                        NodeTypeData nodeType = this.nodeTypeDataManager.getNodeType(name);
                        if (nodeType == null) {
                            throw new ConstraintViolationException("Can not find node type " + amTypes[mi]);
                        }
                        nodeTypes.add(nodeType);
                    }
                    props.put(propInternalQName, null);
                    continue;
                }
                props.put(propInternalQName, attValue);
            }
        }
    }
}

