/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.injection;

import org.jboss.injection.EncInjector;
import org.jboss.injection.InjectionContainer;
import org.jboss.logging.Logger;
import org.jboss.naming.Util;

public class EnvEntryEncInjector
implements EncInjector {
    private static final Logger log = Logger.getLogger(EnvEntryEncInjector.class);
    private String name;
    private String entryType;
    private String value;

    public EnvEntryEncInjector(String encName, String entryType, String value) {
        this.name = encName;
        this.entryType = entryType;
        this.value = value;
    }

    public void inject(InjectionContainer container) {
        try {
            Util.rebind(container.getEnc(), this.name, this.getEnvEntryValue());
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid <env-entry> name: " + this.name, e);
        }
    }

    protected Object getEnvEntryValue() throws ClassNotFoundException {
        Class<?> type = Thread.currentThread().getContextClassLoader().loadClass(this.entryType);
        if (type == String.class) {
            return this.value;
        }
        if (type == Integer.class) {
            return new Integer(this.value);
        }
        if (type == Long.class) {
            return new Long(this.value);
        }
        if (type == Double.class) {
            return new Double(this.value);
        }
        if (type == Float.class) {
            return new Float(this.value);
        }
        if (type == Byte.class) {
            return new Byte(this.value);
        }
        if (type == Character.class) {
            String input = this.value;
            if (input == null || input.length() == 0) {
                return new Character('\u0000');
            }
            if (input.length() > 1) {
                log.warn("Warning character env-entry is too long: binding=" + this.name + " value=" + input);
            }
            return new Character(input.charAt(0));
        }
        if (type == Short.class) {
            return new Short(this.value);
        }
        if (type == Boolean.class) {
            return new Boolean(this.value);
        }
        return this.value;
    }
}

