/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;

public class RpcDispatcherSimpleTest {
    Channel channel;
    RpcDispatcher disp;
    RspList rsp_list;

    public int print(int number) throws Exception {
        System.out.println("print(" + number + ')');
        return number * 2;
    }

    public void start(String props, int num, long interval) throws Exception {
        this.channel = new JChannel(props);
        this.channel.setOpt(5, Boolean.TRUE);
        this.disp = new RpcDispatcher(this.channel, null, null, this);
        this.channel.connect("RpcDispatcherTestGroup");
        for (int i = 0; i < num; ++i) {
            Util.sleep(interval);
            this.rsp_list = this.disp.callRemoteMethods(null, "print", new Object[]{new Integer(i)}, new Class[]{Integer.TYPE}, 2, 0L);
            System.out.println("Responses:\n" + this.rsp_list);
        }
        System.out.println("Closing channel");
        this.channel.close();
        System.out.println("Closing channel: -- done");
        System.out.println("Stopping dispatcher");
        this.disp.stop();
        System.out.println("Stopping dispatcher: -- done");
    }

    public static void main(String[] args) {
        int num = 10;
        long interval = 1000L;
        String props = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-num")) {
                num = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-interval")) {
                interval = Long.parseLong(args[++i]);
                continue;
            }
            if (args[i].equals("-props")) {
                props = args[++i];
                continue;
            }
            RpcDispatcherSimpleTest.help();
            return;
        }
        try {
            new RpcDispatcherSimpleTest().start(props, num, interval);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    private static void help() {
        System.out.println("RpcDispatcherTest [-help] [-props <properties>] [-num <number of msgs>] [-interval <sleep in ms between calls>]");
    }
}

