/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.application;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.application.registry.Application;
import org.exoplatform.application.registry.ApplicationCategory;
import org.exoplatform.application.registry.ApplicationRegistryService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.config.model.CloneApplicationState;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.pom.spi.gadget.Gadget;
import org.exoplatform.portal.webui.application.PortletState;
import org.exoplatform.portal.webui.application.UIGadget;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIPortalToolPanel;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="system:/groovy/portal/webui/application/UIAddNewApplication.gtmpl", events={@EventConfig(listeners={UIMaskWorkspace.CloseActionListener.class}), @EventConfig(listeners={AddApplicationActionListener.class}), @EventConfig(listeners={AddToStartupActionListener.class})})
public class UIAddNewApplication
extends UIContainer {
    private List<ApplicationCategory> listAppCategories;
    private UIComponent uiComponentParent;
    private boolean isInPage;

    public List<ApplicationCategory> getApplicationCategories() throws Exception {
        return this.listAppCategories;
    }

    public List<ApplicationCategory> getApplicationCategories(String remoteUser, ApplicationType[] applicationType) throws Exception {
        ArrayList<ApplicationCategory> appCategories;
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        ApplicationRegistryService prService = (ApplicationRegistryService)container.getComponentInstanceOfType(ApplicationRegistryService.class);
        if (applicationType == null) {
            applicationType = new ApplicationType[]{};
        }
        if ((appCategories = prService.getApplicationCategories(remoteUser, applicationType)) == null) {
            appCategories = new ArrayList<ApplicationCategory>();
        } else {
            Iterator cateItr = appCategories.iterator();
            while (cateItr.hasNext()) {
                ApplicationCategory cate = (ApplicationCategory)cateItr.next();
                List applications = cate.getApplications();
                if (applications.size() >= 1) continue;
                cateItr.remove();
            }
        }
        this.listAppCategories = appCategories;
        return this.listAppCategories;
    }

    public UIComponent getUiComponentParent() {
        return this.uiComponentParent;
    }

    public void setUiComponentParent(UIComponent uiComponentParent) {
        this.uiComponentParent = uiComponentParent;
    }

    public boolean isInPage() {
        return this.isInPage;
    }

    public void setInPage(boolean isInPage) {
        this.isInPage = isInPage;
    }

    private Application getApplication(String id) throws Exception {
        List<ApplicationCategory> pCategories = this.getApplicationCategories();
        for (ApplicationCategory pCategory : pCategories) {
            List applications = pCategory.getApplications();
            for (Application application : applications) {
                if (!application.getId().equals(id)) continue;
                return application;
            }
        }
        return null;
    }

    private static void addApplicationToPage(Event<UIAddNewApplication> event, boolean atStartup) throws Exception {
        UIPage uiPage;
        UIPortal uiPortal = Util.getUIPortal();
        UIPortalApplication uiPortalApp = (UIPortalApplication)uiPortal.getAncestorOfType(UIPortalApplication.class);
        if (uiPortal.isRendered()) {
            uiPage = (UIPage)uiPortal.findFirstComponentOfType(UIPage.class);
        } else {
            UIPortalToolPanel uiPortalToolPanel = (UIPortalToolPanel)uiPortalApp.findFirstComponentOfType(UIPortalToolPanel.class);
            uiPage = (UIPage)uiPortalToolPanel.findFirstComponentOfType(UIPage.class);
        }
        String applicationId = event.getRequestContext().getRequestParameter("objectId");
        Application application = ((UIAddNewApplication)((Object)event.getSource())).getApplication(applicationId);
        ApplicationType appType = application.getType();
        String portletName = application.getApplicationName();
        Object component = null;
        if (ApplicationType.GADGET.equals(appType)) {
            UIGadget uiGadget = (UIGadget)uiPage.createUIComponent(event.getRequestContext(), UIGadget.class, null, null);
            uiGadget.setState((ApplicationState<Gadget>)new TransientApplicationState(portletName));
            int posX = (int)(Math.random() * 400.0);
            int posY = (int)(Math.random() * 200.0);
            uiGadget.getProperties().put((Object)"locationX", (Object)String.valueOf(posX));
            uiGadget.getProperties().put((Object)"locationY", (Object)String.valueOf(posY));
            component = uiGadget;
        } else {
            boolean remote = ApplicationType.WSRP_PORTLET.equals(appType);
            UIPortlet uiPortlet = (UIPortlet)uiPage.createUIComponent(UIPortlet.class, null, null);
            CloneApplicationState appState = !remote ? new CloneApplicationState(application.getId()) : new CloneApplicationState(application.getId());
            ApplicationType applicationType = remote ? ApplicationType.WSRP_PORTLET : ApplicationType.PORTLET;
            PortletState portletState = new PortletState(appState, applicationType);
            uiPortlet.setState(portletState);
            uiPortlet.setPortletInPortal(false);
            if (atStartup) {
                uiPortlet.getProperties().setProperty("appStatus", "HIDE");
            }
            if (application != null) {
                String displayName = application.getDisplayName();
                if (displayName != null) {
                    uiPortlet.setTitle(displayName);
                } else if (portletName != null) {
                    uiPortlet.setTitle(portletName);
                }
                uiPortlet.setDescription(application.getDescription());
                ArrayList accessPers = application.getAccessPermissions();
                String[] accessPermissions = accessPers.toArray(new String[accessPers.size()]);
                uiPortlet.setAccessPermissions(accessPermissions);
                component = uiPortlet;
            }
        }
        uiPage.addChild((UIComponent)component);
        if (uiPage.isModifiable()) {
            Page page = (Page)PortalDataMapper.buildModelObject((UIComponent)uiPage);
            if (page.getChildren() == null) {
                page.setChildren(new ArrayList());
            }
            DataStorage dataService = (DataStorage)uiPortalApp.getApplicationComponent(DataStorage.class);
            dataService.save(page);
        }
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
        pcontext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
        pcontext.setFullRender(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddToStartupActionListener
    extends EventListener<UIAddNewApplication> {
        public void execute(Event<UIAddNewApplication> event) throws Exception {
            if (((UIAddNewApplication)((Object)event.getSource())).isInPage()) {
                UIAddNewApplication.addApplicationToPage((Event<UIAddNewApplication>)event, true);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddApplicationActionListener
    extends EventListener<UIAddNewApplication> {
        public void execute(Event<UIAddNewApplication> event) throws Exception {
            if (((UIAddNewApplication)((Object)event.getSource())).isInPage()) {
                UIAddNewApplication.addApplicationToPage((Event<UIAddNewApplication>)event, false);
            }
        }
    }
}

