/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.ws;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.ws.BanIP;
import org.exoplatform.forum.service.ws.BeanToJsons;
import org.exoplatform.forum.service.ws.MessageBean;
import org.exoplatform.ks.rss.FeedContentProvider;
import org.exoplatform.ks.rss.FeedResolver;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="ks/forum")
public class ForumWebservice
implements ResourceContainer {
    protected static final String JSON_CONTENT_TYPE = "application/json";
    public static final String APP_TYPE = "forum".intern();
    private String strQuery;
    private List<BanIP> ipsToJson = new ArrayList<BanIP>();

    @GET
    @Path(value="getmessage/{maxcount}")
    @Produces(value={"application/json"})
    public Response getMessage(@PathParam(value="maxcount") String maxcount) throws Exception {
        int counter = 0;
        try {
            counter = Integer.parseInt(maxcount);
        }
        catch (Exception e) {
            // empty catch block
        }
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        ForumService forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
        List<Post> list = forumService.getNewPosts(counter);
        ArrayList<MessageBean> lastMessages = new ArrayList<MessageBean>();
        if (!list.isEmpty()) {
            for (Post post : list) {
                lastMessages.add(new MessageBean(post));
            }
        }
        return Response.ok(new BeanToJsons(lastMessages), (String)JSON_CONTENT_TYPE).cacheControl(cacheControl).build();
    }

    @GET
    @Path(value="filter/{strIP}")
    @Produces(value={"application/json"})
    public Response filterIps(@PathParam(value="strIP") String str) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        ForumService forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
        if (str.equals("all")) {
            this.ipsToJson.clear();
            List<String> banIps = forumService.getBanList();
            for (String ip : banIps) {
                this.ipsToJson.add(new BanIP(ip));
            }
        } else if (!str.equals(this.strQuery)) {
            this.ipsToJson.clear();
            List<String> banIps = forumService.getBanList();
            for (String ip : banIps) {
                if (!ip.startsWith(str)) continue;
                this.ipsToJson.add(new BanIP(ip));
            }
            this.strQuery = str;
        }
        return Response.ok(new BeanToJsons<BanIP>(this.ipsToJson), (String)JSON_CONTENT_TYPE).cacheControl(cacheControl).build();
    }

    @GET
    @Path(value="filterIpBanforum/{strForumId}/{strIP}")
    @Produces(value={"application/json"})
    public Response filterIpBanForum(@PathParam(value="strForumId") String forumId, @PathParam(value="strIP") String str) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        ForumService forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
        if (str.equals("all")) {
            this.ipsToJson.clear();
            List<String> banIps = forumService.getForumBanList(forumId);
            for (String ip : banIps) {
                this.ipsToJson.add(new BanIP(ip));
            }
        } else if (!str.equals(this.strQuery)) {
            this.ipsToJson.clear();
            List<String> banIps = forumService.getForumBanList(forumId);
            for (String ip : banIps) {
                if (!ip.startsWith(str)) continue;
                this.ipsToJson.add(new BanIP(ip));
            }
            this.strQuery = str;
        }
        return Response.ok(new BeanToJsons<BanIP>(this.ipsToJson), (String)JSON_CONTENT_TYPE).cacheControl(cacheControl).build();
    }

    @GET
    @Path(value="filterTagNameForum/{userAndTopicId}/{strTagName}")
    @Produces(value={"application/json"})
    public Response filterTagNameForum(@PathParam(value="strTagName") String str, @PathParam(value="userAndTopicId") String userAndTopicId) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        ForumService forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
        if (str.equals(" ")) {
            this.ipsToJson.clear();
        } else if (str.equals("onclickForm")) {
            this.ipsToJson.clear();
            List<String> banIps = forumService.getTagNameInTopic(userAndTopicId);
            for (String ip : banIps) {
                this.ipsToJson.add(new BanIP(ip));
            }
        } else {
            this.ipsToJson.clear();
            List<String> banIps = forumService.getAllTagName(str, userAndTopicId);
            for (String ip : banIps) {
                if (!ip.startsWith(str)) continue;
                this.ipsToJson.add(new BanIP(ip));
            }
        }
        return Response.ok(new BeanToJsons<BanIP>(this.ipsToJson), (String)JSON_CONTENT_TYPE).cacheControl(cacheControl).build();
    }

    @GET
    @Path(value="rss/{resourceid}")
    @Produces(value={"text/xml"})
    public Response viewrss(@PathParam(value="resourceid") String resourceid) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        try {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            FeedResolver feedResolver = (FeedResolver)container.getComponentInstanceOfType(FeedResolver.class);
            FeedContentProvider provider = feedResolver.resolve(APP_TYPE);
            InputStream is = provider.getFeedContent(resourceid);
            return Response.ok((Object)is, (String)"text/xml").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="rss/user/{resourceid}")
    @Produces(value={"text/xml"})
    public Response userrss(@PathParam(value="resourceid") String resourceid) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        try {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            FeedResolver feedResolver = (FeedResolver)container.getComponentInstanceOfType(FeedResolver.class);
            FeedContentProvider provider = feedResolver.resolve("");
            InputStream is = provider.getFeedContent(resourceid);
            return Response.ok((Object)is, (String)"text/xml").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

