/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.jrmp.server;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.InvokerInterceptor;
import org.jboss.invocation.MarshalledInvocation;
import org.jboss.invocation.jrmp.server.JRMPProxyFactoryMBean;
import org.jboss.metadata.MetaData;
import org.jboss.proxy.ClientMethodInterceptor;
import org.jboss.proxy.GenericProxyFactory;
import org.jboss.system.Registry;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.util.naming.Util;
import org.w3c.dom.Element;

public class JRMPProxyFactory
extends ServiceMBeanSupport
implements JRMPProxyFactoryMBean {
    private ObjectName invokerName;
    private ObjectName targetName;
    protected Object theProxy;
    private String jndiName;
    private Class[] exportedInterfaces;
    private Element interceptorConfig;
    private ArrayList interceptorClasses = new ArrayList();
    private boolean invokeTargetMethod;
    private final Map methodMap = new HashMap();
    private final Map signatureMap = new HashMap();

    public JRMPProxyFactory() {
        this.interceptorClasses.add(ClientMethodInterceptor.class);
        this.interceptorClasses.add(InvokerInterceptor.class);
    }

    public ObjectName getInvokerName() {
        return this.invokerName;
    }

    public void setInvokerName(ObjectName invokerName) {
        this.invokerName = invokerName;
    }

    public ObjectName getTargetName() {
        return this.targetName;
    }

    public void setTargetName(ObjectName targetName) {
        this.targetName = targetName;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public Class getExportedInterface() {
        return this.exportedInterfaces[0];
    }

    public void setExportedInterface(Class exportedInterface) {
        this.exportedInterfaces = new Class[]{exportedInterface};
    }

    public Class[] getExportedInterfaces() {
        return this.exportedInterfaces;
    }

    public void setExportedInterfaces(Class[] exportedInterfaces) {
        this.exportedInterfaces = exportedInterfaces;
    }

    public boolean getInvokeTargetMethod() {
        return this.invokeTargetMethod;
    }

    public void setInvokeTargetMethod(boolean invokeTargetMethod) {
        this.invokeTargetMethod = invokeTargetMethod;
    }

    public Element getClientInterceptors() {
        return this.interceptorConfig;
    }

    public void setClientInterceptors(Element config) throws Exception {
        this.interceptorConfig = config;
        Iterator interceptorElements = MetaData.getChildrenByTagName((Element)this.interceptorConfig, (String)"interceptor");
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        this.interceptorClasses.clear();
        while (interceptorElements != null && interceptorElements.hasNext()) {
            Element ielement = (Element)interceptorElements.next();
            String className = null;
            className = MetaData.getElementContent((Element)ielement);
            Class<?> clazz = loader.loadClass(className);
            this.interceptorClasses.add(clazz);
            this.log.debug((Object)("added interceptor type: " + clazz));
        }
    }

    public Object getProxy() {
        return this.theProxy;
    }

    public Object invoke(Invocation mi) throws Exception {
        Object result;
        boolean remoteInvocation = mi instanceof MarshalledInvocation;
        if (remoteInvocation) {
            ((MarshalledInvocation)mi).setMethodMap(this.methodMap);
        }
        if (this.invokeTargetMethod) {
            String[] signature = (String[])this.signatureMap.get(mi.getMethod());
            result = this.server.invoke(this.targetName, mi.getMethod().getName(), mi.getArguments(), signature);
        } else {
            result = this.server.invoke(this.targetName, "invoke", new Object[]{mi}, Invocation.INVOKE_SIGNATURE);
        }
        return result;
    }

    protected void startService() throws Exception {
        Integer nameHash = new Integer(this.getServiceName().hashCode());
        Registry.bind((Object)nameHash, (Object)this.getServiceName());
        Object cacheID = null;
        String proxyBindingName = null;
        Class[] ifaces = this.exportedInterfaces;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        this.createProxy(cacheID, proxyBindingName, loader, ifaces);
        this.log.debug((Object)("Created JRMPPRoxy for service=" + this.targetName + ", nameHash=" + nameHash + ", invoker=" + this.invokerName));
        if (this.jndiName != null) {
            InitialContext iniCtx = new InitialContext();
            Util.bind((Context)iniCtx, (String)this.jndiName, (Object)this.theProxy);
            this.log.debug((Object)("Bound proxy under jndiName=" + this.jndiName));
        }
        for (int i = 0; i < this.exportedInterfaces.length; ++i) {
            Method[] methods = this.exportedInterfaces[i].getMethods();
            for (int j = 0; j < methods.length; ++j) {
                String[] signature;
                this.methodMap.put(new Long(MarshalledInvocation.calculateHash(methods[j])), methods[j]);
                Class<?>[] types = methods[j].getParameterTypes();
                if (types == null || types.length == 0) {
                    signature = null;
                } else {
                    signature = new String[types.length];
                    for (int typeInd = 0; typeInd < types.length; ++typeInd) {
                        signature[typeInd] = types[typeInd].getName();
                    }
                }
                this.signatureMap.put(methods[j], signature);
            }
        }
    }

    protected void stopService() throws Exception {
        Integer nameHash = new Integer(this.getServiceName().hashCode());
        Registry.unbind((Object)nameHash);
        if (this.jndiName != null) {
            InitialContext iniCtx = new InitialContext();
            Util.unbind((Context)iniCtx, (String)this.jndiName);
        }
        this.theProxy = null;
    }

    protected void destroyService() throws Exception {
        this.interceptorClasses.clear();
    }

    protected void createProxy(Object cacheID, String proxyBindingName, ClassLoader loader, Class[] ifaces) {
        GenericProxyFactory proxyFactory = new GenericProxyFactory();
        this.theProxy = proxyFactory.createProxy(cacheID, this.getServiceName(), this.invokerName, this.jndiName, proxyBindingName, this.interceptorClasses, loader, ifaces);
    }

    protected void rebind() throws Exception {
        this.log.debug((Object)("(re-)Binding " + this.jndiName));
        Util.rebind((Context)new InitialContext(), (String)this.jndiName, (Object)this.theProxy);
    }

    protected ArrayList getInterceptorClasses() {
        return this.interceptorClasses;
    }
}

