/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.jboss.ws.WSException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static int count = 0;

    public static String assignWsuId(Element element) {
        String id = element.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        if (id == null || id.length() < 1) {
            id = Util.generateId();
            element.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", id);
            Util.addNamespace(element, "wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        }
        return id;
    }

    public static Element getFirstChildElement(Node node) {
        Node child;
        for (child = node.getFirstChild(); child != null && child.getNodeType() != 1; child = child.getNextSibling()) {
        }
        return (Element)child;
    }

    public static Element getNextSiblingElement(Element element) {
        Node sibling;
        for (sibling = element.getNextSibling(); sibling != null && sibling.getNodeType() != 1; sibling = sibling.getNextSibling()) {
        }
        return (Element)sibling;
    }

    public static Element getPreviousSiblingElement(Element element) {
        Node sibling;
        for (sibling = element.getPreviousSibling(); sibling != null && sibling.getNodeType() != 1; sibling = sibling.getPreviousSibling()) {
        }
        return (Element)sibling;
    }

    public static Element findElement(Element root, String localName, String namespace) {
        return Util.findElement(root, new QName(namespace, localName));
    }

    public static Element findElement(Element root, QName name) {
        if (Util.matchNode(root, name)) {
            return root;
        }
        for (Node child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
            Element possibleMatch;
            if (child.getNodeType() != 1 || (possibleMatch = Util.findElement((Element)child, name)) == null) continue;
            return possibleMatch;
        }
        return null;
    }

    public static List<Node> findAllElements(Element root, QName name, boolean local) {
        ArrayList<Node> list = new ArrayList<Node>();
        if (Util.matchNode(root, name, local)) {
            list.add(root);
        }
        for (Node child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            list.addAll(Util.findAllElements((Element)child, name, local));
        }
        return list;
    }

    public static Element findElementByWsuId(Element root, String id) {
        if (id.equals(Util.getWsuId(root))) {
            return root;
        }
        for (Node child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
            Element possibleMatch;
            if (child.getNodeType() != 1 || (possibleMatch = Util.findElementByWsuId((Element)child, id)) == null) continue;
            return possibleMatch;
        }
        return null;
    }

    public static Element findOrCreateSoapHeader(Element envelope) {
        String prefix = envelope.getPrefix();
        String uri = envelope.getNamespaceURI();
        QName name = new QName(uri, "Header");
        Element header = Util.findElement(envelope, name);
        if (header == null) {
            header = envelope.getOwnerDocument().createElementNS(uri, prefix + ":Header");
            envelope.insertBefore(header, envelope.getFirstChild());
        }
        return header;
    }

    public static String getWsuId(Element element) {
        String ns;
        if (element.hasAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id")) {
            return element.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        }
        if (element.hasAttribute("Id") && ("http://www.w3.org/2000/09/xmldsig#".equals(ns = element.getNamespaceURI()) || "http://www.w3.org/2001/04/xmlenc#".equals(ns))) {
            return element.getAttribute("Id");
        }
        return null;
    }

    public static boolean equalStrings(String string1, String string2) {
        if (string1 == null && string2 == null) {
            return true;
        }
        return string1 != null && string1.equals(string2);
    }

    public static boolean matchNode(Node node, QName name) {
        return Util.matchNode(node, name, false);
    }

    public static boolean matchNode(Node node, QName name, boolean local) {
        return Util.equalStrings(node.getLocalName(), name.getLocalPart()) && (local || Util.equalStrings(node.getNamespaceURI(), name.getNamespaceURI()));
    }

    public static String generateId() {
        return Util.generateId("element");
    }

    public static void addNamespace(Element element, String prefix, String uri) {
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateId(String prefix) {
        StringBuilder id = new StringBuilder();
        long time = System.currentTimeMillis();
        Class<Util> clazz = Util.class;
        synchronized (Util.class) {
            // ** MonitorExit[var4_3] (shouldn't be in output)
            id.append(prefix).append("-").append(++count).append("-").append(time).append("-").append(id.hashCode());
            return id.toString();
        }
    }

    public static <T> T loadFactory(Class<T> factoryType, String factoryClassName, Class<? extends T> defaultFactoryClassName) {
        String name;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        String string = name = factoryClassName != null ? factoryClassName : System.getProperty(factoryType.getName());
        if (name == null) {
            name = defaultFactoryClassName.getName();
        }
        try {
            Class<?> cl = loader.loadClass(name);
            return (T)cl.newInstance();
        }
        catch (Exception e) {
            throw new WSException(e);
        }
    }
}

