/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.metadata.plugins.AbstractTypeMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.joinpoint.spi.Joinpoint;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossStringBuilder;

public class AbstractMapMetaData
extends AbstractTypeMetaData
implements Map {
    private HashMap map = new HashMap();
    protected String keyType;
    protected String valueType;

    public String getKeyType() {
        return this.keyType;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public Object getValue(TypeInfo info, ClassLoader cl) throws Throwable {
        Map result = (Map)this.getMapInstance(info, cl, Map.class);
        if (result == null) {
            result = (Map)this.getDefaultMapInstance();
        }
        ClassInfo keyTypeInfo = this.getKeyClassInfo(cl);
        ClassInfo valueTypeInfo = this.getValueClassInfo(cl);
        if (this.map.size() > 0) {
            Iterator i = this.map.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                ValueMetaData key = (ValueMetaData)entry.getKey();
                ValueMetaData value = (ValueMetaData)entry.getValue();
                Object keyValue = key.getValue((TypeInfo)keyTypeInfo, cl);
                Object valueValue = value.getValue((TypeInfo)valueTypeInfo, cl);
                result.put(keyValue, valueValue);
            }
        }
        return result;
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public Set entrySet() {
        return this.map.entrySet();
    }

    public Object get(Object key) {
        return this.map.get(key);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public Object put(Object key, Object value) {
        return this.map.put(key, value);
    }

    public void putAll(Map t) {
        this.map.putAll(t);
    }

    public Object remove(Object key) {
        return this.map.remove(key);
    }

    public int size() {
        return this.map.size();
    }

    public Collection values() {
        return this.map.values();
    }

    public Iterator getChildren() {
        ArrayList children = new ArrayList(this.map.keySet());
        children.addAll(this.map.values());
        return children.iterator();
    }

    public void toString(JBossStringBuilder buffer) {
        super.toString(buffer);
    }

    protected Object getDefaultMapInstance() throws Throwable {
        return new HashMap();
    }

    protected Object getMapInstance(TypeInfo info, ClassLoader cl, Class expected) throws Throwable {
        BeanInfo beanInfo;
        Joinpoint constructor;
        Object result;
        ClassInfo typeInfo = this.getClassInfo(cl);
        if (typeInfo != null && !(typeInfo instanceof ClassInfo)) {
            throw new IllegalArgumentException(typeInfo.getName() + " is not a class");
        }
        if (typeInfo != null && typeInfo.isInterface()) {
            throw new IllegalArgumentException(typeInfo.getName() + " is an interface");
        }
        if (typeInfo == null) {
            if (info == null) {
                return null;
            }
            if (!(info instanceof ClassInfo)) {
                return null;
            }
            if (((ClassInfo)info).isInterface()) {
                return null;
            }
            if (Object.class.getName().equals(info.getName())) {
                return null;
            }
            typeInfo = info;
        }
        if (!expected.isAssignableFrom((result = (constructor = this.configurator.getConstructorJoinPoint(beanInfo = this.configurator.getBeanInfo(typeInfo.getType()))).dispatch()).getClass())) {
            throw new ClassCastException(result.getClass() + " is not a " + expected.getName());
        }
        return result;
    }

    protected ClassInfo getKeyClassInfo(ClassLoader cl) throws Throwable {
        if (this.keyType == null) {
            return null;
        }
        return this.configurator.getClassInfo(this.keyType, cl);
    }

    protected ClassInfo getValueClassInfo(ClassLoader cl) throws Throwable {
        if (this.valueType == null) {
            return null;
        }
        return this.configurator.getClassInfo(this.valueType, cl);
    }
}

