/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee.factory;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.ejb.EjbModule;
import org.jboss.logging.Logger;
import org.jboss.management.j2ee.EJB;
import org.jboss.management.j2ee.EJBModule;
import org.jboss.management.j2ee.factory.FactoryUtils;
import org.jboss.management.j2ee.factory.ManagedObjectFactory;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.SessionMetaData;

public class EJBModuleFactory
implements ManagedObjectFactory {
    private static Logger log = Logger.getLogger(EJBModuleFactory.class);
    private static Map moduleServiceToMgmtMap = new ConcurrentReaderHashMap();
    private Map deploymentToModuleNameMap = new ConcurrentReaderHashMap();
    private Map containerToModuleNameMap = new ConcurrentReaderHashMap();

    static ObjectName getEJBModuleName(ObjectName ejbModuleService) {
        ObjectName jsr77Name = (ObjectName)moduleServiceToMgmtMap.get(ejbModuleService);
        return jsr77Name;
    }

    public ObjectName create(MBeanServer server, Object data) {
        if (!(data instanceof DeploymentInfo)) {
            return null;
        }
        DeploymentInfo di = (DeploymentInfo)data;
        String ejbJarName = di.shortName;
        ObjectName ejbModuleService = di.deployedObject;
        ObjectName jsr77Name = EJBModule.create(server, FactoryUtils.findEarParent(di), ejbJarName, di.localUrl, ejbModuleService);
        moduleServiceToMgmtMap.put(ejbModuleService, jsr77Name);
        this.deploymentToModuleNameMap.put(di, jsr77Name);
        log.debug((Object)("Created module: " + jsr77Name));
        for (ObjectName containerName : di.mbeans) {
            this.createEJB(server, containerName);
        }
        return jsr77Name;
    }

    public void destroy(MBeanServer server, Object data) {
        ObjectName ejbModuleService;
        if (!(data instanceof DeploymentInfo)) {
            return;
        }
        DeploymentInfo di = (DeploymentInfo)data;
        ObjectName jsr77Name = (ObjectName)this.deploymentToModuleNameMap.remove(di);
        log.debug((Object)("Destroy module: " + jsr77Name));
        for (ObjectName containerName : di.mbeans) {
            this.destroyEJB(server, containerName);
        }
        if (jsr77Name != null) {
            EJBModule.destroy(server, jsr77Name);
        }
        if ((ejbModuleService = di.deployedObject) != null) {
            this.containerToModuleNameMap.remove(ejbModuleService);
        }
    }

    public ObjectName createEJB(MBeanServer server, ObjectName containerName) {
        ObjectName jsr77Name = null;
        try {
            BeanMetaData metaData = (BeanMetaData)server.getAttribute(containerName, "BeanMetaData");
            EjbModule ejbModule = (EjbModule)server.getAttribute(containerName, "EjbModule");
            ObjectName ejbModName = EJBModuleFactory.getEJBModuleName(ejbModule.getServiceName());
            String ejbName = metaData.getEjbName();
            String jndiName = metaData.getJndiName();
            String localJndiName = metaData.getLocalJndiName();
            int type = 2;
            if (metaData.isSession()) {
                SessionMetaData smetaData = (SessionMetaData)metaData;
                if (smetaData.isStateful()) {
                    type = 1;
                }
            } else {
                type = metaData.isMessageDriven() ? 3 : 0;
            }
            jsr77Name = EJB.create(server, ejbModName, containerName, type, ejbName, jndiName, localJndiName);
            this.containerToModuleNameMap.put(containerName, jsr77Name);
            log.debug((Object)("Create container: " + containerName + ", module: " + jsr77Name));
        }
        catch (Exception e) {
            log.debug((Object)"", (Throwable)e);
        }
        return jsr77Name;
    }

    public void destroyEJB(MBeanServer server, ObjectName containerName) {
        ObjectName jsr77Name = (ObjectName)this.containerToModuleNameMap.get(containerName);
        log.debug((Object)("Destroy container: " + containerName + ", module: " + jsr77Name));
        if (jsr77Name != null) {
            EJB.destroy(server, jsr77Name);
        }
    }
}

