/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.provider.EntityProvider;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Consumes(value={"application/xml", "text/xml", "application/xhtml+xml"})
@Produces(value={"application/xml", "text/xml", "application/xhtml+xml"})
public class DOMSourceEntityProvider
implements EntityProvider<DOMSource> {
    private static final Log LOG = ExoLogger.getLogger((String)DOMSourceEntityProvider.class.getName());

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type == DOMSource.class;
    }

    public DOMSource readFrom(Class<DOMSource> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            Document d = factory.newDocumentBuilder().parse(entityStream);
            return new DOMSource(d);
        }
        catch (SAXParseException saxpe) {
            if (LOG.isDebugEnabled()) {
                saxpe.printStackTrace();
            }
            return null;
        }
        catch (SAXException saxe) {
            throw new IOException("Can't read from input stream " + saxe);
        }
        catch (ParserConfigurationException pce) {
            throw new IOException("Can't read from input stream " + pce);
        }
    }

    public long getSize(DOMSource t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return DOMSource.class.isAssignableFrom(type);
    }

    public void writeTo(DOMSource t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        StreamResult out = new StreamResult(entityStream);
        try {
            TransformerFactory.newInstance().newTransformer().transform(t, out);
        }
        catch (TransformerConfigurationException e) {
            throw new IOException("Can't write to output stream " + e);
        }
        catch (TransformerException e) {
            throw new IOException("Can't write to output stream " + e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new IOException("Can't write to output stream " + e);
        }
    }
}

