/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexingTree {
    private final QPath indexingRootQpath;
    private final NodeData indexingRoot;
    private final List<QPath> excludedPaths;

    public IndexingTree(NodeData indexingRoot, List<QPath> excludedPaths) {
        this.indexingRoot = indexingRoot;
        this.indexingRootQpath = indexingRoot.getQPath();
        this.excludedPaths = excludedPaths;
    }

    public IndexingTree(NodeData indexingRoot) {
        this.indexingRoot = indexingRoot;
        this.indexingRootQpath = indexingRoot.getQPath();
        this.excludedPaths = new ArrayList<QPath>();
    }

    public List<QPath> getExcludedPaths() {
        return this.excludedPaths;
    }

    public NodeData getIndexingRoot() {
        return this.indexingRoot;
    }

    public boolean isExcluded(ItemState event) {
        for (QPath excludedPath : this.excludedPaths) {
            if (!event.getData().getQPath().isDescendantOf(excludedPath) && !event.getData().getQPath().equals(excludedPath)) continue;
            return true;
        }
        return !event.getData().getQPath().isDescendantOf(this.indexingRootQpath) && !event.getData().getQPath().equals(this.indexingRootQpath);
    }

    public boolean isExcluded(ItemData eventData) {
        for (QPath excludedPath : this.excludedPaths) {
            if (!eventData.getQPath().isDescendantOf(excludedPath) && !eventData.getQPath().equals(excludedPath)) continue;
            return true;
        }
        return !eventData.getQPath().isDescendantOf(this.indexingRootQpath) && !eventData.getQPath().equals(this.indexingRootQpath);
    }
}

