/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupEventListener;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.idm.ExtGroup;
import org.exoplatform.services.organization.idm.MembershipDAOImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMOrganizationServiceImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMService;
import org.picketlink.idm.api.Attribute;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.api.IdentityType;
import org.picketlink.idm.api.Role;
import org.picketlink.idm.impl.api.SimpleAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupDAOImpl
implements GroupHandler {
    private static Logger log = LoggerFactory.getLogger(GroupDAOImpl.class);
    public static final String GROUP_LABEL = "label";
    public static final String GROUP_DESCRIPTION = "description";
    private PicketLinkIDMService service_;
    private List<GroupEventListener> listeners_;
    private PicketLinkIDMOrganizationServiceImpl orgService;

    public GroupDAOImpl(PicketLinkIDMOrganizationServiceImpl orgService, PicketLinkIDMService service) {
        this.service_ = service;
        this.orgService = orgService;
        this.listeners_ = new ArrayList<GroupEventListener>();
    }

    public void addGroupEventListener(GroupEventListener listener) {
        this.listeners_.add(listener);
    }

    public final Group createGroupInstance() {
        return new ExtGroup();
    }

    public void createGroup(Group group, boolean broadcast) throws Exception {
        this.addChild(null, group, broadcast);
    }

    public void addChild(Group parent, Group child, boolean broadcast) throws Exception {
        org.picketlink.idm.api.Group parentGroup = null;
        if (parent != null) {
            try {
                parentGroup = this.getIdentitySession().getPersistenceManager().findGroup(parent.getGroupName(), this.orgService.getConfiguration().getGroupType(parent.getParentId()));
            }
            catch (Exception e) {
                log.info("Cannot obtain group: " + parent.getGroupName(), (Throwable)e);
            }
            ((ExtGroup)child).setId(parent.getId() + "/" + child.getGroupName());
        } else {
            ((ExtGroup)child).setId("/" + child.getGroupName());
        }
        if (broadcast) {
            this.preSave(child, true);
        }
        if (parentGroup != null) {
            ((ExtGroup)child).setParentId(parent.getId());
        }
        org.picketlink.idm.api.Group childGroup = this.persistGroup(child);
        try {
            if (parentGroup != null) {
                this.getIdentitySession().getRelationshipManager().associateGroups(parentGroup, childGroup);
            } else {
                this.getIdentitySession().getRelationshipManager().associateGroups(this.getRootGroup(), childGroup);
            }
        }
        catch (Exception e) {
            log.info("Cannot associate groups: ", (Throwable)e);
        }
        if (broadcast) {
            this.postSave(child, true);
        }
    }

    public void saveGroup(Group group, boolean broadcast) throws Exception {
        if (broadcast) {
            this.preSave(group, false);
        }
        this.persistGroup(group);
        if (broadcast) {
            this.postSave(group, false);
        }
    }

    public Group removeGroup(Group group, boolean broadcast) throws Exception {
        if (broadcast) {
            this.preDelete(group);
        }
        org.picketlink.idm.api.Group jbidGroup = null;
        try {
            jbidGroup = this.getIdentitySession().getPersistenceManager().findGroup(group.getGroupName(), this.orgService.getConfiguration().getGroupType(group.getParentId()));
        }
        catch (Exception e) {
            log.info("Cannot obtain group: " + group.getGroupName() + "; ", (Throwable)e);
        }
        if (jbidGroup == null) {
            return group;
        }
        try {
            Collection oneLevelChilds = this.getIdentitySession().getRelationshipManager().findAssociatedGroups(jbidGroup, null, true, false);
            Collection allChilds = this.getIdentitySession().getRelationshipManager().findAssociatedGroups(jbidGroup, null, true, true);
            this.getIdentitySession().getRelationshipManager().disassociateGroups(jbidGroup, oneLevelChilds);
            for (org.picketlink.idm.api.Group child : allChilds) {
                this.getIdentitySession().getPersistenceManager().removeGroup(child, true);
            }
        }
        catch (Exception e) {
            log.info("Cannot clear group relationships: " + group.getGroupName() + "; ", (Throwable)e);
        }
        try {
            this.getIdentitySession().getPersistenceManager().removeGroup(jbidGroup, true);
        }
        catch (Exception e) {
            log.info("Cannot remove group: " + group.getGroupName() + "; ", (Throwable)e);
        }
        if (broadcast) {
            this.postDelete(group);
        }
        return group;
    }

    public Collection findGroupByMembership(String userName, String membershipType) throws Exception {
        Collection allRoles = new HashSet();
        try {
            allRoles = this.getIdentitySession().getRoleManager().findRoles(userName, membershipType);
        }
        catch (Exception e) {
            log.info("Identity operation error: ", (Throwable)e);
        }
        HashSet<Group> exoGroups = new HashSet<Group>();
        MembershipDAOImpl mmm = (MembershipDAOImpl)this.orgService.getMembershipHandler();
        for (Role role : allRoles) {
            if (!mmm.isCreateMembership(role.getRoleType().getName())) continue;
            exoGroups.add(this.convertGroup(role.getGroup()));
        }
        if (mmm.isAssociationMapped() && mmm.getAssociationMapping().equals(membershipType)) {
            Collection groups = new HashSet();
            try {
                groups = this.getIdentitySession().getRelationshipManager().findAssociatedGroups(userName, null);
            }
            catch (Exception e) {
                log.info("Identity operation error: ", (Throwable)e);
            }
            for (org.picketlink.idm.api.Group group : groups) {
                exoGroups.add(this.convertGroup(group));
            }
        }
        return new LinkedList(exoGroups);
    }

    public Group findGroupById(String groupId) throws Exception {
        org.picketlink.idm.api.Group jbidGroup = this.orgService.getJBIDMGroup(groupId);
        if (jbidGroup == null) {
            return null;
        }
        return this.convertGroup(jbidGroup);
    }

    public Collection findGroups(Group parent) throws Exception {
        org.picketlink.idm.api.Group jbidGroup = null;
        if (parent == null) {
            jbidGroup = this.getRootGroup();
        } else {
            try {
                jbidGroup = this.getIdentitySession().getPersistenceManager().findGroup(parent.getGroupName(), this.orgService.getConfiguration().getGroupType(parent.getParentId()));
            }
            catch (Exception e) {
                log.info("Identity operation error: ", (Throwable)e);
            }
        }
        if (jbidGroup == null) {
            return Collections.emptyList();
        }
        String parentId = parent == null ? null : parent.getParentId();
        HashSet plGroups = new HashSet();
        try {
            plGroups.addAll(this.getIdentitySession().getRelationshipManager().findAssociatedGroups(jbidGroup, null, true, false));
        }
        catch (Exception e) {
            log.info("Identity operation error: ", (Throwable)e);
        }
        if (this.orgService.getConfiguration().isForceMembershipOfMappedTypes()) {
            String id = parent != null ? parent.getId() : "/";
            for (String type : this.orgService.getConfiguration().getTypes(id)) {
                try {
                    plGroups.addAll(this.getIdentitySession().getPersistenceManager().findGroup(type));
                }
                catch (Exception e) {
                    log.info("Identity operation error: ", (Throwable)e);
                }
            }
        }
        HashSet<Group> exoGroups = new HashSet<Group>();
        org.picketlink.idm.api.Group root = this.getRootGroup();
        for (org.picketlink.idm.api.Group group : plGroups) {
            if (group.equals(root)) continue;
            Group g = this.convertGroup(group);
            if (this.orgService.getConfiguration().isForceMembershipOfMappedTypes()) {
                String id = g.getParentId();
                if ((parent != null || id != null) && (id == null || !id.equals(parent.getId()))) continue;
                exoGroups.add(g);
                continue;
            }
            exoGroups.add(g);
        }
        return new LinkedList(exoGroups);
    }

    public Collection findGroupsOfUser(String user) throws Exception {
        if (user == null) {
            return Collections.emptyList();
        }
        Collection allGroups = new HashSet();
        try {
            allGroups = this.getIdentitySession().getRelationshipManager().findRelatedGroups(user, null, null);
        }
        catch (Exception e) {
            log.info("Identity operation error: ", (Throwable)e);
        }
        LinkedList<Group> exoGroups = new LinkedList<Group>();
        for (org.picketlink.idm.api.Group group : allGroups) {
            exoGroups.add(this.convertGroup(group));
        }
        return exoGroups;
    }

    public Collection getAllGroups() throws Exception {
        HashSet plGroups = new HashSet();
        try {
            plGroups.addAll(this.getIdentitySession().getRelationshipManager().findAssociatedGroups(this.getRootGroup(), null, true, true));
        }
        catch (Exception e) {
            log.info("Identity operation error: ", (Throwable)e);
        }
        if (this.orgService.getConfiguration().isForceMembershipOfMappedTypes()) {
            for (String type : this.orgService.getConfiguration().getAllTypes()) {
                try {
                    plGroups.addAll(this.getIdentitySession().getPersistenceManager().findGroup(type));
                }
                catch (Exception e) {
                    log.info("Identity operation error: ", (Throwable)e);
                }
            }
        }
        HashSet<Group> exoGroups = new HashSet<Group>();
        org.picketlink.idm.api.Group root = this.getRootGroup();
        for (org.picketlink.idm.api.Group group : plGroups) {
            if (group.equals(root)) continue;
            exoGroups.add(this.convertGroup(group));
        }
        return new LinkedList(exoGroups);
    }

    private void preSave(Group group, boolean isNew) throws Exception {
        for (GroupEventListener listener : this.listeners_) {
            listener.preSave(group, isNew);
        }
    }

    private void postSave(Group group, boolean isNew) throws Exception {
        for (GroupEventListener listener : this.listeners_) {
            listener.postSave(group, isNew);
        }
    }

    private void preDelete(Group group) throws Exception {
        for (GroupEventListener listener : this.listeners_) {
            listener.preDelete(group);
        }
    }

    private void postDelete(Group group) throws Exception {
        for (GroupEventListener listener : this.listeners_) {
            listener.postDelete(group);
        }
    }

    protected Group convertGroup(org.picketlink.idm.api.Group jbidGroup) throws Exception {
        Map attrs = new HashMap();
        try {
            attrs = this.getIdentitySession().getAttributesManager().getAttributes((IdentityType)jbidGroup);
        }
        catch (Exception e) {
            log.info("Identity operation error: ", (Throwable)e);
        }
        ExtGroup exoGroup = new ExtGroup(jbidGroup.getName());
        if (attrs.containsKey(GROUP_DESCRIPTION) && ((Attribute)attrs.get(GROUP_DESCRIPTION)).getValue() != null) {
            exoGroup.setDescription(((Attribute)attrs.get(GROUP_DESCRIPTION)).getValue().toString());
        }
        if (attrs.containsKey(GROUP_LABEL) && ((Attribute)attrs.get(GROUP_LABEL)).getValue() != null) {
            exoGroup.setLabel(((Attribute)attrs.get(GROUP_LABEL)).getValue().toString());
        } else {
            exoGroup.setLabel(exoGroup.getGroupName());
        }
        String id = this.getGroupId(jbidGroup);
        exoGroup.setId(id);
        if (id.length() == jbidGroup.getName().length() + 1) {
            exoGroup.setParentId(null);
        } else if (!id.equals("") && !id.equals("/")) {
            exoGroup.setParentId(id.substring(0, id.lastIndexOf("/")));
        }
        return exoGroup;
    }

    private String getGroupId(org.picketlink.idm.api.Group jbidGroup) throws Exception {
        if (jbidGroup.equals(this.getRootGroup())) {
            return "";
        }
        Collection parents = new HashSet();
        try {
            parents = this.getIdentitySession().getRelationshipManager().findAssociatedGroups(jbidGroup, null, false, false);
        }
        catch (Exception e) {
            log.info("Identity operation error: ", (Throwable)e);
        }
        if (parents.size() == 0 || parents.size() > 1) {
            String id;
            if (parents.size() > 1) {
                log.info("PLIDM Group has more than one parent: " + jbidGroup.getName() + "; Will try to use parent path " + "defined by type mappings or just place it under root /");
            }
            if ((id = this.orgService.getConfiguration().getParentId(jbidGroup.getGroupType())) != null && this.orgService.getConfiguration().isForceMembershipOfMappedTypes()) {
                if (id.endsWith("/*")) {
                    id = id.substring(0, id.length() - 2);
                }
                return id + "/" + jbidGroup.getName();
            }
            return "/" + jbidGroup.getName();
        }
        String parentGroupId = this.getGroupId((org.picketlink.idm.api.Group)parents.iterator().next());
        return parentGroupId + "/" + jbidGroup.getName();
    }

    private org.picketlink.idm.api.Group persistGroup(Group exoGroup) throws Exception {
        org.picketlink.idm.api.Group jbidGroup = null;
        try {
            jbidGroup = this.getIdentitySession().getPersistenceManager().findGroup(exoGroup.getGroupName(), this.orgService.getConfiguration().getGroupType(exoGroup.getParentId()));
        }
        catch (Exception e) {
            log.info("Identity operation error: ", (Throwable)e);
        }
        if (jbidGroup == null) {
            try {
                jbidGroup = this.getIdentitySession().getPersistenceManager().createGroup(exoGroup.getGroupName(), this.orgService.getConfiguration().getGroupType(exoGroup.getParentId()));
            }
            catch (Exception e) {
                log.info("Identity operation error: ", (Throwable)e);
            }
        }
        String description = exoGroup.getDescription();
        String label = exoGroup.getLabel();
        ArrayList<SimpleAttribute> attrsList = new ArrayList<SimpleAttribute>();
        if (description != null) {
            attrsList.add(new SimpleAttribute(GROUP_DESCRIPTION, (Object)description));
        }
        if (label != null) {
            attrsList.add(new SimpleAttribute(GROUP_LABEL, (Object)label));
        }
        if (attrsList.size() > 0) {
            Attribute[] attrs = new Attribute[attrsList.size()];
            attrs = attrsList.toArray(attrs);
            try {
                this.getIdentitySession().getAttributesManager().updateAttributes((IdentityType)jbidGroup, attrs);
            }
            catch (Exception e) {
                log.info("Identity operation error: ", (Throwable)e);
            }
        }
        return jbidGroup;
    }

    private IdentitySession getIdentitySession() throws Exception {
        return this.service_.getIdentitySession();
    }

    private org.picketlink.idm.api.Group getRootGroup() throws Exception {
        org.picketlink.idm.api.Group rootGroup = null;
        try {
            rootGroup = this.getIdentitySession().getPersistenceManager().findGroup(this.orgService.getConfiguration().getRootGroupName(), this.orgService.getConfiguration().getGroupType("/"));
        }
        catch (Exception e) {
            log.info("Identity operation error: ", (Throwable)e);
        }
        if (rootGroup == null) {
            try {
                rootGroup = this.getIdentitySession().getPersistenceManager().createGroup(this.orgService.getConfiguration().getRootGroupName(), this.orgService.getConfiguration().getGroupType("/"));
            }
            catch (Exception e) {
                log.info("Identity operation error: ", (Throwable)e);
            }
        }
        return rootGroup;
    }
}

