/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service;

import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.service.ForumService;

public class CalculateModeratorEventListener
implements EventListener {
    private String path_;
    private String workspace_;
    private String repository_;

    public String getSrcWorkspace() {
        return this.workspace_;
    }

    public String getRepository() {
        return this.repository_;
    }

    public String getPath() {
        return this.path_;
    }

    public void setPath(String path) {
        this.path_ = path;
    }

    public void onEvent(EventIterator evIter) {
        try {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            ForumService forumService = (ForumService)container.getComponentInstanceOfType(ForumService.class);
            while (evIter.hasNext()) {
                String evPath;
                Event ev = evIter.nextEvent();
                if (ev.getType() == 4) {
                    evPath = ev.getPath();
                    if (!evPath.substring(evPath.lastIndexOf("/") + 1).equals("exo:moderators")) continue;
                    forumService.calculateModerator(this.path_, true);
                    continue;
                }
                if (ev.getType() == 16) {
                    evPath = ev.getPath();
                    if (!evPath.substring(evPath.lastIndexOf("/") + 1).equals("exo:moderators")) continue;
                    forumService.calculateModerator(this.path_, false);
                    continue;
                }
                if (ev.getType() != 8 || !(evPath = ev.getPath()).substring(evPath.lastIndexOf("/") + 1).equals("exo:moderators")) continue;
                forumService.calculateModerator(this.path_, false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

