/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.common.jcr;

import javax.jcr.Session;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.ks.common.jcr.JCRTask;
import org.exoplatform.ks.common.jcr.SessionManager;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCRSessionManager
implements SessionManager {
    private ThreadLocal<Session> currentSession = new ThreadLocal();
    String workspaceName = "portal-system";
    String repositoryName = "repository";

    public JCRSessionManager(String repository, String workspace) {
        this.workspaceName = workspace;
        this.repositoryName = repository;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public void setWorkspaceName(String workspaceName) {
        this.workspaceName = workspaceName;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    @Override
    public Session getCurrentSession() {
        return this.openOrReuseSession();
    }

    public Session currentSession() {
        return this.getCurrentSession();
    }

    @Override
    public Session getSession(SessionProvider sessionProvider) {
        return this.openOrReuseSession();
    }

    @Override
    public Session openSession() {
        Session session = this.currentSession.get();
        if (session == null) {
            session = this.createSession();
        }
        return session;
    }

    private Session openOrReuseSession() {
        Session session = this.currentSession.get();
        if (session == null) {
            session = this.createSession();
        }
        return session;
    }

    @Override
    public Session createSession() {
        Session session = this.currentSession.get();
        if (session == null) {
            try {
                RepositoryService repositoryService = (RepositoryService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RepositoryService.class);
                if (repositoryService == null) {
                    repositoryService = (RepositoryService)ExoContainerContext.getContainerByName((String)PortalContainer.getCurrentPortalContainerName()).getComponentInstanceOfType(RepositoryService.class);
                }
                ManageableRepository repository = repositoryService.getRepository(this.repositoryName);
                session = SessionProvider.createSystemProvider().getSession(this.workspaceName, repository);
                this.currentSession.set(session);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return session;
    }

    @Override
    public boolean closeSession() {
        return this.closeSession(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean closeSession(boolean save) {
        Session session = this.currentSession.get();
        if (session == null) {
            return false;
        }
        this.currentSession.set(null);
        try {
            if (save) {
                session.save();
            }
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            session.logout();
        }
        return true;
    }

    @Override
    public <T> T executeAndSave(JCRTask<T> jcrTask) {
        try {
            T t = jcrTask.execute(this.getCurrentSession());
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.closeSession(true);
        }
    }

    @Override
    public <T> T execute(JCRTask<T> jcrTask) {
        try {
            T t = jcrTask.execute(this.getCurrentSession());
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.closeSession(true);
        }
    }
}

