/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.rss;

import java.util.Arrays;
import java.util.List;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.exoplatform.ks.common.jcr.KSDataLocation;
import org.exoplatform.ks.rss.AnswersFeedGenerator;

public class FAQRSSEventListener
implements EventListener {
    private String path_;
    private String workspace_;
    private String repository_;
    private List<String> listPropertyNotGetEvent = Arrays.asList("exo:rssWatching", "ks.rss", "exo:emailWatching", "exo:userWatching");
    private KSDataLocation locator;

    public FAQRSSEventListener(KSDataLocation dataLocator) throws Exception {
        this.workspace_ = dataLocator.getWorkspace();
        this.repository_ = dataLocator.getRepository();
        this.locator = dataLocator;
    }

    public String getSrcWorkspace() {
        return this.workspace_;
    }

    public String getRepository() {
        return this.repository_;
    }

    public String getPath() {
        return this.path_;
    }

    public void setPath(String path) {
        this.path_ = path;
    }

    public void onEvent(EventIterator evIter) {
        try {
            AnswersFeedGenerator process = new AnswersFeedGenerator(this.locator);
            String path = null;
            String path_ = "";
            while (evIter.hasNext()) {
                Event ev = evIter.nextEvent();
                path = ev.getPath();
                if (ev.getType() == 1) {
                    int length = ev.getPath().indexOf("/Question") + 41;
                    if (length == ev.getPath().length()) {
                        process.itemAdded(ev.getPath());
                        continue;
                    }
                    if (ev.getPath().indexOf("/faqCommentHome") <= 0 && ev.getPath().indexOf("/faqAnswerHome") <= 0) continue;
                    process.itemUpdated(ev.getPath());
                    continue;
                }
                if (ev.getType() == 16) {
                    process.itemUpdated(path.substring(0, path.lastIndexOf("/")));
                    continue;
                }
                if (ev.getType() != 2 || !path_.contains(path) && path_.length() != 0) continue;
                path_ = path;
            }
            if (path_.length() > 0) {
                int length = path.indexOf("/Question") + 41;
                if (length == path.length()) {
                    process.itemRemoved(path);
                } else if (path.indexOf("/faqCommentHome") > 0 || path.indexOf("/faqAnswerHome") > 0) {
                    process.itemUpdated(path.substring(0, path.indexOf("/Question") + 41));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

