/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol.conversion;

import java.beans.IntrospectionException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.betwixt.IntrospectionConfiguration;
import org.apache.commons.betwixt.io.BeanReader;
import org.apache.commons.betwixt.io.BeanWriter;
import org.apache.shindig.protocol.conversion.BeanConverter;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanAtomConverter
implements BeanConverter {
    private static final Logger logger = Logger.getLogger(BeanAtomConverter.class.getName());
    public static final String ERROR_MESSAGE_FMT = "Could not convert %s to %s";

    @Override
    public String getContentType() {
        return "application/atom+xml";
    }

    @Override
    public String convertToString(Object pojo) {
        return this.convertToXml(pojo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String convertToXml(Object obj) {
        String xmlHead = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        StringWriter outputWriter = new StringWriter();
        BeanWriter writer = new BeanWriter((Writer)outputWriter);
        IntrospectionConfiguration configuration = writer.getXMLIntrospector().getConfiguration();
        configuration.setAttributesForPrimitives(false);
        configuration.setWrapCollectionsInElement(true);
        writer.getBindingConfiguration().setMapIDs(false);
        writer.setEndOfLine("");
        writer.setWriteEmptyElements(false);
        String toReturn = xmlHead;
        try {
            writer.write("response", obj);
            toReturn = toReturn + outputWriter.toString();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("XML is: " + toReturn + "\n **** \n\n");
            }
        }
        catch (SAXException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (IntrospectionException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        finally {
            block21: {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    if (!logger.isLoggable(Level.FINEST)) break block21;
                    logger.log(Level.FINEST, e.getMessage(), e);
                }
            }
        }
        return toReturn;
    }

    @Override
    public <T> T convertToObject(String xml, Class<T> className) {
        xml = xml.substring(xml.indexOf("?>") + 2);
        BeanReader reader = new BeanReader();
        try {
            reader.registerBeanClass("activity", className);
            StringReader rd = new StringReader(xml);
            return (T)reader.parse((Reader)rd);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(String.format(ERROR_MESSAGE_FMT, xml, className), e);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format(ERROR_MESSAGE_FMT, xml, className), e);
        }
        catch (SAXException e) {
            throw new RuntimeException(String.format(ERROR_MESSAGE_FMT, xml, className), e);
        }
    }

    @Override
    public void append(Appendable buf, Object pojo) throws IOException {
        buf.append(this.convertToString(pojo));
    }
}

