/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.navigation;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeNode {
    private boolean isExpanded_;
    private boolean hasChild_;
    private String path_;
    private PageNode node_;
    private PageNavigation navigation_;
    private List<TreeNode> children_ = new ArrayList<TreeNode>();

    public TreeNode(PageNode node, PageNavigation nav, boolean hasChild) {
        this(node, node.getUri(), nav, hasChild);
    }

    private TreeNode(PageNode node, String path, PageNavigation nav, boolean hasChild) {
        this.node_ = node;
        this.navigation_ = nav;
        this.isExpanded_ = false;
        this.path_ = path;
        this.hasChild_ = hasChild;
    }

    public boolean isExpanded() {
        return this.isExpanded_;
    }

    public void setExpanded(boolean isExpanded) {
        this.isExpanded_ = isExpanded;
    }

    public String getName() throws RepositoryException {
        return this.node_.getName();
    }

    public String getPath() {
        return this.path_;
    }

    public String getNodePath() throws RepositoryException {
        return this.node_.getUri();
    }

    public PageNode getNode() {
        return this.node_;
    }

    public void setNode(PageNode node) {
        this.node_ = node;
    }

    public List<TreeNode> getChildren() {
        return this.children_;
    }

    public int getChildrenSize() {
        return this.children_.size();
    }

    public TreeNode getChildByPath(String path, TreeNode treeNode) {
        TreeNode returnVal = null;
        for (TreeNode child : treeNode.getChildren()) {
            if (returnVal != null) continue;
            if (child.getPath().equals(path)) {
                returnVal = child;
                continue;
            }
            if (child.getChildren() == null) continue;
            returnVal = child.getChildByPath(path, child);
        }
        return returnVal;
    }

    public void setChildren(List<PageNode> children, PageNavigation nav) throws Exception {
        this.setExpanded(true);
        for (PageNode child : children) {
            boolean isHasChild = child.getChildren().size() > 0;
            this.children_.add(new TreeNode(child, nav.getId() + "::" + child.getUri(), nav, isHasChild));
        }
    }

    public void addChildren(TreeNode treeNode) {
        this.children_.add(treeNode);
    }

    public void setNavigation(PageNavigation navigation_) {
        this.navigation_ = navigation_;
    }

    public PageNavigation getNavigation() {
        return this.navigation_;
    }

    public void setHasChild(boolean hasChild) {
        this.hasChild_ = hasChild;
    }

    public boolean isHasChild() {
        return this.hasChild_;
    }
}

