/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form.validator;

import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.validator.Validator;

public class PositiveNumberFormatValidator
implements Validator {
    public void validate(UIFormInput uiInput) throws Exception {
        String label;
        if (uiInput.getValue() == null || ((String)uiInput.getValue()).length() == 0) {
            return;
        }
        UIComponent uiComponent = (UIComponent)((Object)uiInput);
        UIForm uiForm = uiComponent.getAncestorOfType(UIForm.class);
        try {
            label = uiForm.getLabel(uiInput.getName());
        }
        catch (Exception e) {
            label = uiInput.getName();
        }
        label = label.trim();
        if (label.charAt(label.length() - 1) == ':') {
            label = label.substring(0, label.length() - 1);
        }
        String s = (String)uiInput.getValue();
        boolean error = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!(Character.isDigit(c) || s.charAt(0) == '-' && i == 0)) {
                error = false;
                Object[] args = new Object[]{label, uiInput.getBindingField()};
                throw new MessageException(new ApplicationMessage("NumberFormatValidator.msg.Invalid-number", args));
            }
            error = true;
        }
        if (error && s.charAt(0) == '-') {
            Object[] args = new Object[]{label, uiInput.getBindingField()};
            throw new MessageException(new ApplicationMessage("PositiveNumberFormatValidator.msg.Invalid-number", args));
        }
    }
}

