/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.conf;

import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;

public class NewUserListener
extends UserEventListener {
    private static Log log = ExoLogger.getLogger(NewUserListener.class);

    public NewUserListener(InitParams params) throws Exception {
    }

    public void postSave(User user, boolean isNew) throws Exception {
        if (isNew) {
            try {
                UserProfile template = this.newDefaultProfileTemplte();
                this.getForumService().addMember(user, template);
            }
            catch (Exception e) {
                log.warn((Object)"Error while adding new forum member: ", (Throwable)e);
            }
        } else {
            try {
                this.getForumService().updateUserProfile(user);
            }
            catch (Exception e) {
                log.warn((Object)"Error while updating forum profile: ", (Throwable)e);
            }
        }
    }

    private UserProfile newDefaultProfileTemplte() {
        return null;
    }

    private ForumService getForumService() {
        return (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
    }

    public void postDelete(User user) throws Exception {
        try {
            this.getForumService().removeMember(user);
        }
        catch (Exception e) {
            log.warn((Object)"failed to remove member : ", (Throwable)e);
        }
    }
}

