/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.database.impl;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.hibernate.HibernateException;
import org.hibernate.usertype.UserType;

public class TextClobType
implements UserType {
    public int[] sqlTypes() {
        return new int[]{2005};
    }

    public Class returnedClass() {
        return String.class;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return x == y || x != null && x.equals(y);
    }

    public void nullSafeSet(PreparedStatement stmt, Object value, int index) throws HibernateException, SQLException {
        if (value == null) {
            stmt.setNull(index, this.sqlTypes()[0]);
        } else {
            String str = value instanceof String ? (String)value : value.toString();
            stmt.setCharacterStream(index, (Reader)new StringReader(str), str.length());
        }
    }

    PreparedStatement getRealStatement(PreparedStatement stmt) throws HibernateException {
        Method[] methods = stmt.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String returnType = methods[i].getReturnType().getName();
            if (!Statement.class.getName().equals(returnType) && !PreparedStatement.class.getName().equals(returnType) || methods[i].getParameterTypes().length != 0) continue;
            Statement s = null;
            try {
                s = (Statement)methods[i].invoke((Object)stmt, null);
            }
            catch (SecurityException e) {
                throw new HibernateException("Security Error getting method [getDelegate] on [" + stmt.getClass().getName() + "::" + methods[i].getName() + "]", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new HibernateException("Error calling method [getDelegate] on [" + stmt.getClass().getName() + "::" + methods[i].getName() + "]", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new HibernateException("Error calling method [getDelegate] on [" + stmt.getClass().getName() + "::" + methods[i].getName() + "]", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new HibernateException("Error calling method [getDelegate] on [" + stmt.getClass().getName() + "::" + methods[i].getName() + "]", (Throwable)e);
            }
            return (PreparedStatement)s;
        }
        return stmt;
    }

    public Object deepCopy(Object value) throws HibernateException {
        if (value == null) {
            return null;
        }
        String stringValue = (String)value;
        return new String(stringValue);
    }

    public boolean isMutable() {
        return false;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        Reader charReader = rs.getCharacterStream(names[0]);
        if (charReader == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        try {
            int amountRead;
            char[] buffer = new char[2048];
            while ((amountRead = charReader.read(buffer, 0, buffer.length)) != -1) {
                sb.append(buffer, 0, amountRead);
            }
        }
        catch (IOException ioe) {
            throw new HibernateException("IOException occurred reading text", (Throwable)ioe);
        }
        finally {
            try {
                charReader.close();
            }
            catch (IOException e) {
                throw new HibernateException("IOException occurred closing stream", (Throwable)e);
            }
        }
        return sb.toString();
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return this.deepCopy(cached);
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return new String(value.toString());
    }

    public int hashCode(Object x) throws HibernateException {
        return super.hashCode();
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }
}

