/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.faq.service.Answer;
import org.exoplatform.faq.service.Category;
import org.exoplatform.faq.service.Comment;
import org.exoplatform.faq.service.FAQServiceUtils;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.FileAttachment;
import org.exoplatform.faq.service.JCRPageList;
import org.exoplatform.faq.service.ObjectSearchResult;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.service.Utils;
import org.exoplatform.faq.service.Watch;
import org.exoplatform.ks.common.jcr.SessionManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuestionPageList
extends JCRPageList {
    private NodeIterator iter_ = null;
    private boolean isQuery_ = false;
    private String value_;
    private boolean isNotYetAnswered = false;
    private List<Question> listQuestions_ = null;
    private List<ObjectSearchResult> listFAQFormSearchS_ = null;
    private List<Watch> listWatchs_ = null;
    private List<Category> listCategories_ = null;
    private String questionQuery_ = new String();
    private Node nodeCategory_ = null;
    private List<Object> listObject_ = new ArrayList<Object>();
    private FAQSetting faqSetting_ = null;
    private static final String ANSWER_HOME = "faqAnswerHome".intern();
    private static final String COMMENT_HOME = "faqCommentHome".intern();
    private SessionManager sessionManager = FAQServiceUtils.getSessionManager();
    private static Log log = ExoLogger.getLogger(QuestionPageList.class);

    public void setNotYetAnswered(boolean isNotYetAnswered) {
        this.isNotYetAnswered = isNotYetAnswered;
        this.setTotalQuestion();
    }

    private void setTotalQuestion() {
        this.listQuestions_ = new ArrayList<Question>();
        NodeIterator nodeIterator = this.iter_;
        NodeIterator languageIter = null;
        Node questionNode = null;
        Node languageNode = null;
        String languages = null;
        while (nodeIterator.hasNext()) {
            languages = new String();
            questionNode = nodeIterator.nextNode();
            try {
                if (!questionNode.hasNode(ANSWER_HOME) || questionNode.getNode(ANSWER_HOME).getNodes().getSize() < 1L) {
                    languages = questionNode.getProperty("exo:language").getValue().getString();
                }
                if (questionNode.hasNode("languages")) {
                    languageNode = questionNode.getNode("languages");
                    languageIter = languageNode.getNodes();
                    while (languageIter.hasNext()) {
                        Node language = languageIter.nextNode();
                        if (language.hasNode(ANSWER_HOME) && language.getNode(ANSWER_HOME).getNodes().getSize() >= 1L) continue;
                        if (languages != null && languages.trim().length() > 0) {
                            languages = languages + ",";
                        }
                        languages = languages + language.getProperty("exo:language").getString();
                    }
                }
                if (languages == null || languages.trim().length() <= 0) continue;
                this.listQuestions_.add(this.getQuestion(questionNode).setLanguagesNotYetAnswered(languages));
            }
            catch (Exception e) {
                log.error((Object)"Fail to set total questions: ", (Throwable)e);
            }
        }
        this.setAvailablePage(this.listQuestions_.size());
    }

    public QuestionPageList(NodeIterator iter, long pageSize, String value, boolean isQuery) throws Exception {
        super(pageSize);
        this.iter_ = iter;
        this.value_ = value;
        this.isQuery_ = isQuery;
        this.setAvailablePage(iter.getSize());
    }

    public QuestionPageList(List<ObjectSearchResult> faqFormSearchs, long pageSize) throws Exception {
        super(pageSize);
        this.listFAQFormSearchS_ = faqFormSearchs;
        this.setAvailablePage(faqFormSearchs.size());
    }

    public QuestionPageList(List<Watch> listWatch, double page) throws Exception {
        super(10L);
        this.listWatchs_ = listWatch;
        this.setAvailablePage(listWatch.size());
    }

    public QuestionPageList(List<Category> listCategories) throws Exception {
        super(10L);
        this.listCategories_ = listCategories;
        this.setAvailablePage(listCategories.size());
    }

    public QuestionPageList(List<Question> listQuestions, int size) throws Exception {
        super(10L);
        this.listQuestions_ = listQuestions;
        this.setAvailablePage(size);
    }

    public QuestionPageList(Node categoryNode, String quesQuerry, List<Object> listObject, FAQSetting setting) throws Exception {
        super(10L);
        this.questionQuery_ = quesQuerry;
        this.nodeCategory_ = categoryNode;
        this.listObject_.addAll(listObject);
        this.faqSetting_ = setting;
        this.setAvailablePage(listObject.size());
    }

    @Override
    protected void populateCurrentPage(long page, String username) throws Exception {
        if (this.iter_ == null || !this.iter_.hasNext()) {
            Session session = this.getJCRSession();
            if (this.isQuery_) {
                QueryManager qm = session.getWorkspace().getQueryManager();
                Query query = qm.createQuery(this.value_, "xpath");
                QueryResult result = query.execute();
                this.iter_ = result.getNodes();
            } else {
                Node node = (Node)session.getItem(this.value_);
                this.iter_ = node.getNodes();
            }
            if (this.isNotYetAnswered) {
                this.setTotalQuestion();
            }
            this.closeSession();
        }
        if (this.isNotYetAnswered) {
            this.setAvailablePage(this.listQuestions_.size());
        } else {
            this.setAvailablePage(this.iter_.getSize());
        }
        long pageSize = this.getPageSize();
        long position = 0L;
        position = page == 1L ? 0L : (page - 1L) * pageSize;
        this.currentListPage_ = new ArrayList();
        if (!this.isNotYetAnswered) {
            this.iter_.skip(position);
            Question question = new Question();
            int i = 0;
            while ((long)i < pageSize && this.iter_ != null && this.iter_.hasNext()) {
                question = this.getQuestion(this.iter_.nextNode());
                this.currentListPage_.add(question);
                ++i;
            }
        } else {
            pageSize += position;
            for (int i = (int)position; (long)i < pageSize && i < this.listQuestions_.size(); ++i) {
                this.currentListPage_.add(this.listQuestions_.get(i));
            }
        }
        this.iter_ = null;
    }

    @Override
    protected void populateCurrentPageItem(long page) throws Exception {
        if (this.iter_ == null || !this.iter_.hasNext()) {
            Session session = this.getJCRSession();
            if (this.isQuery_) {
                QueryManager qm = session.getWorkspace().getQueryManager();
                Query query = qm.createQuery(this.value_, "xpath");
                QueryResult result = query.execute();
                this.iter_ = result.getNodes();
            } else {
                Node node = (Node)session.getItem(this.value_);
                this.iter_ = node.getNodes();
            }
            this.closeSession();
            this.setAvailablePage(this.iter_.getSize());
            this.checkAndSetPage(page);
            page = this.currentPage_;
        }
        long pageSize = this.getPageSize();
        long position = 0L;
        if (page == 1L) {
            position = 0L;
        } else if (page > 1L) {
            position = (page - 1L) * pageSize;
            this.iter_.skip(position);
        } else {
            pageSize = this.iter_.getSize();
        }
        this.currentListObject_ = new ArrayList();
        int i = 0;
        while ((long)i < pageSize && this.iter_.hasNext()) {
            Node currentNode = this.iter_.nextNode();
            if (currentNode.isNodeType("exo:answer")) {
                this.currentListObject_.add(this.getAnswerByNode(currentNode));
            } else if (currentNode.isNodeType("exo:comment")) {
                this.currentListObject_.add(this.getCommentByNode(currentNode));
            }
            ++i;
        }
        this.iter_ = null;
    }

    @Override
    protected void populateCurrentPageWatch(long page, String username) throws Exception {
        if (this.iter_ == null || !this.iter_.hasNext()) {
            Session session = this.getJCRSession();
            QueryManager qm = session.getWorkspace().getQueryManager();
            Query query = qm.createQuery(this.value_, "xpath");
            QueryResult result = query.execute();
            this.iter_ = result.getNodes();
            this.closeSession();
        }
        long pageSize = this.getPageSize();
        long position = 0L;
        position = page <= 1L ? 0L : (page - 1L) * pageSize;
        this.currentListWatch_ = new ArrayList();
        Node watchNode = null;
        int count = 0;
        while (this.iter_.hasNext()) {
            ++count;
            watchNode = this.iter_.nextNode();
            this.currentListWatch_.addAll(this.getWatchs(watchNode, false, (int)position, (int)pageSize));
        }
        this.iter_ = null;
    }

    @Override
    protected void populateCurrentPageResultSearch(long page, String username) throws Exception {
        long pageSize = this.getPageSize();
        long position = 0L;
        position = page == 1L ? 0L : (page - 1L) * pageSize;
        pageSize *= page;
        this.currentListResultSearch_ = new ArrayList();
        for (int i = (int)position; (long)i < pageSize && i < this.listFAQFormSearchS_.size(); ++i) {
            this.currentListResultSearch_.add(this.listFAQFormSearchS_.get(i));
        }
    }

    @Override
    protected void populateCurrentPageCategoriesSearch(long page, String username) throws Exception {
        long pageSize = this.getPageSize();
        long position = 0L;
        if (!this.isQuery_) {
            position = page == 1L ? 0L : (page - 1L) * pageSize;
            pageSize *= page;
            this.currentListCategory_ = new ArrayList();
            for (int i = (int)position; (long)i < pageSize && i < this.listCategories_.size(); ++i) {
                this.currentListCategory_.add(this.listCategories_.get(i));
            }
        } else {
            if (this.iter_ == null || !this.iter_.hasNext()) {
                Session session = this.getJCRSession();
                QueryManager qm = session.getWorkspace().getQueryManager();
                Query query = qm.createQuery(this.value_, "xpath");
                QueryResult result = query.execute();
                this.iter_ = result.getNodes();
                this.closeSession();
            }
            this.setAvailablePage(this.iter_.getSize());
            position = page == 1L ? 0L : (page - 1L) * pageSize;
            this.currentListCategory_ = new ArrayList();
            this.iter_.skip(position);
            Category category = null;
            int i = 0;
            while ((long)i < pageSize && this.iter_ != null && this.iter_.hasNext()) {
                category = this.getCategory(this.iter_.nextNode());
                this.currentListCategory_.add(category);
                ++i;
            }
            this.iter_ = null;
        }
    }

    @Override
    protected void populateCurrentPageQuestionsSearch(long page, String username) throws Exception {
        long pageSize = this.getPageSize();
        long position = 0L;
        position = page == 1L ? 0L : (page - 1L) * pageSize;
        pageSize *= page;
        this.currentListPage_ = new ArrayList();
        for (int i = (int)position; (long)i < pageSize && i < this.listQuestions_.size(); ++i) {
            this.currentListPage_.add(this.listQuestions_.get(i));
        }
    }

    @Override
    protected void populateCurrentPageCategoriesQuestionsSearch(long page, String username) throws Exception {
        String idSearch = this.getObjectId();
        int posSearch = 0;
        if (this.listObject_ == null || this.listObject_.isEmpty()) {
            this.listObject_ = new ArrayList<Object>();
            int size = 0;
            Session session = this.getJCRSession();
            QueryManager qm = session.getWorkspace().getQueryManager();
            Query query = qm.createQuery(this.questionQuery_, "xpath");
            QueryResult result = query.execute();
            this.iter_ = result.getNodes();
            Question question = null;
            while (this.iter_.hasNext()) {
                question = this.getQuestion(this.iter_.nextNode());
                if (!question.getId().equals(idSearch)) {
                    ++size;
                } else {
                    posSearch = size + 1;
                }
                this.listObject_.add(question);
            }
            this.closeSession();
            this.iter_ = null;
            this.iter_ = this.nodeCategory_.getNodes();
            ArrayList<Category> listCategory = new ArrayList<Category>();
            while (this.iter_.hasNext()) {
                listCategory.add(this.getCategory(this.iter_.nextNode()));
            }
            if (this.faqSetting_.getOrderBy().equals("created")) {
                if (this.faqSetting_.getOrderType().equals("asc")) {
                    Collections.sort(listCategory, new Utils.DatetimeComparatorASC());
                } else {
                    Collections.sort(listCategory, new Utils.DatetimeComparatorDESC());
                }
            } else if (this.faqSetting_.getOrderType().equals("asc")) {
                Collections.sort(listCategory, new Utils.NameComparatorASC());
            } else {
                Collections.sort(listCategory, new Utils.NameComparatorDESC());
            }
            this.listObject_.addAll(listCategory);
            if (this.getAvailablePage() < (long)this.listObject_.size()) {
                this.setAvailablePage(this.listObject_.size());
            }
            this.iter_ = null;
        }
        long pageSize = this.getPageSize();
        long position = 0L;
        if (posSearch > 0) {
            int t = (posSearch /= (int)pageSize) % (int)pageSize;
            if (t > 0 || posSearch == 0) {
                ++posSearch;
            }
            page = posSearch;
            this.setObjectId(null);
        }
        this.setPageJump(page);
        position = page == 1L ? 0L : (page - 1L) * pageSize;
        pageSize *= page;
        this.currentListObject_ = new ArrayList();
        for (int i = (int)position; (long)i < pageSize && i < this.listObject_.size(); ++i) {
            this.currentListObject_.add(this.listObject_.get(i));
        }
        this.listObject_ = null;
    }

    private Question getQuestion(Node questionNode) throws Exception {
        Question question = new Question();
        question.setId(questionNode.getName());
        if (questionNode.hasProperty("exo:language")) {
            question.setLanguage(questionNode.getProperty("exo:language").getString());
        }
        if (questionNode.hasProperty("exo:name")) {
            question.setDetail(questionNode.getProperty("exo:name").getString());
        }
        if (questionNode.hasProperty("exo:author")) {
            question.setAuthor(questionNode.getProperty("exo:author").getString());
        }
        if (questionNode.hasProperty("exo:email")) {
            question.setEmail(questionNode.getProperty("exo:email").getString());
        }
        if (questionNode.hasProperty("exo:title")) {
            question.setQuestion(questionNode.getProperty("exo:title").getString());
        }
        if (questionNode.hasProperty("exo:createdDate")) {
            question.setCreatedDate(questionNode.getProperty("exo:createdDate").getDate().getTime());
        }
        if (questionNode.hasProperty("exo:categoryId")) {
            question.setCategoryId(questionNode.getProperty("exo:categoryId").getString());
        }
        if (questionNode.hasProperty("exo:isActivated")) {
            question.setActivated(questionNode.getProperty("exo:isActivated").getBoolean());
        }
        if (questionNode.hasProperty("exo:isApproved")) {
            question.setApproved(questionNode.getProperty("exo:isApproved").getBoolean());
        }
        if (questionNode.hasProperty("exo:relatives")) {
            question.setRelations(this.ValuesToStrings(questionNode.getProperty("exo:relatives").getValues()));
        }
        if (questionNode.hasProperty("exo:nameAttachs")) {
            question.setNameAttachs(this.ValuesToStrings(questionNode.getProperty("exo:nameAttachs").getValues()));
        }
        if (questionNode.hasProperty("exo:usersVote")) {
            question.setUsersVote(this.ValuesToStrings(questionNode.getProperty("exo:usersVote").getValues()));
        }
        if (questionNode.hasProperty("exo:markVote")) {
            question.setMarkVote(questionNode.getProperty("exo:markVote").getValue().getDouble());
        }
        if (questionNode.hasProperty("exo:emailWatching")) {
            question.setEmailsWatch(this.ValuesToStrings(questionNode.getProperty("exo:emailWatching").getValues()));
        }
        if (questionNode.hasProperty("exo:userWatching")) {
            question.setUsersWatch(this.ValuesToStrings(questionNode.getProperty("exo:userWatching").getValues()));
        }
        if (questionNode.hasProperty("exo:topicIdDiscuss")) {
            question.setTopicIdDiscuss(questionNode.getProperty("exo:topicIdDiscuss").getString());
        }
        if (questionNode.hasProperty("exo:lastActivity")) {
            question.setLastActivity(questionNode.getProperty("exo:lastActivity").getString());
        }
        if (questionNode.hasProperty("exo:numberOfPublicAnswers")) {
            question.setNumberOfPublicAnswers(questionNode.getProperty("exo:numberOfPublicAnswers").getLong());
        }
        String path = questionNode.getPath();
        question.setPath(path.substring(path.indexOf(Utils.FAQ_APP) + Utils.FAQ_APP.length() + 1));
        ArrayList<FileAttachment> listFile = new ArrayList<FileAttachment>();
        NodeIterator nodeIterator = questionNode.getNodes();
        FileAttachment attachment = null;
        String workspace = questionNode.getSession().getWorkspace().getName();
        while (nodeIterator.hasNext()) {
            Node node = nodeIterator.nextNode();
            if (!node.isNodeType("exo:faqAttachment")) continue;
            attachment = new FileAttachment();
            Node nodeFile = node.getNode("jcr:content");
            attachment.setId(node.getPath());
            attachment.setMimeType(nodeFile.getProperty("jcr:mimeType").getString());
            attachment.setNodeName(node.getName());
            attachment.setName(nodeFile.getProperty("exo:fileName").getValue().getString());
            attachment.setWorkspace(workspace);
            attachment.setPath("/" + workspace + node.getPath());
            try {
                if (nodeFile.hasProperty("jcr:data")) {
                    attachment.setSize(nodeFile.getProperty("jcr:data").getStream().available());
                } else {
                    attachment.setSize(0L);
                }
            }
            catch (Exception e) {
                attachment.setSize(0L);
            }
            listFile.add(attachment);
        }
        question.setAttachMent(listFile);
        question.setAnswers(this.getAnswers(questionNode));
        question.setComments(this.getComment(questionNode));
        return question;
    }

    public Answer[] getAnswers(Node questionNode) throws Exception {
        try {
            if (!questionNode.hasNode(ANSWER_HOME)) {
                return new Answer[0];
            }
            NodeIterator nodeIterator = questionNode.getNode(ANSWER_HOME).getNodes();
            Answer[] answers = new Answer[(int)nodeIterator.getSize()];
            Node answerNode = null;
            int i = 0;
            while (nodeIterator.hasNext()) {
                answerNode = nodeIterator.nextNode();
                answers[i] = this.getAnswerByNode(answerNode);
                ++i;
            }
            return answers;
        }
        catch (Exception e) {
            return new Answer[0];
        }
    }

    public Answer getAnswerByNode(Node answerNode) throws Exception {
        Answer answer = new Answer();
        answer.setId(answerNode.getName());
        if (answerNode.hasProperty("exo:responses")) {
            answer.setResponses(answerNode.getProperty("exo:responses").getValue().getString());
        }
        if (answerNode.hasProperty("exo:responseBy")) {
            answer.setResponseBy(answerNode.getProperty("exo:responseBy").getValue().getString());
        }
        if (answerNode.hasProperty("exo:fullName")) {
            answer.setFullName(answerNode.getProperty("exo:fullName").getValue().getString());
        }
        if (answerNode.hasProperty("exo:dateResponse")) {
            answer.setDateResponse(answerNode.getProperty("exo:dateResponse").getValue().getDate().getTime());
        }
        if (answerNode.hasProperty("exo:usersVoteAnswer")) {
            answer.setUsersVoteAnswer(this.ValuesToStrings(answerNode.getProperty("exo:usersVoteAnswer").getValues()));
        }
        if (answerNode.hasProperty("exo:MarkVotes")) {
            answer.setMarkVotes(answerNode.getProperty("exo:MarkVotes").getValue().getLong());
        }
        if (answerNode.hasProperty("exo:approveResponses")) {
            answer.setApprovedAnswers(answerNode.getProperty("exo:approveResponses").getValue().getBoolean());
        }
        if (answerNode.hasProperty("exo:activateResponses")) {
            answer.setActivateAnswers(answerNode.getProperty("exo:activateResponses").getValue().getBoolean());
        }
        if (answerNode.hasProperty("exo:postId")) {
            answer.setPostId(answerNode.getProperty("exo:postId").getString());
        }
        String path = answerNode.getPath();
        answer.setPath(path.substring(path.indexOf(Utils.FAQ_APP) + Utils.FAQ_APP.length() + 1));
        return answer;
    }

    public Comment[] getComment(Node questionNode) throws Exception {
        try {
            if (!questionNode.hasNode(COMMENT_HOME)) {
                return new Comment[0];
            }
            NodeIterator nodeIterator = questionNode.getNode(COMMENT_HOME).getNodes();
            Comment[] comments = new Comment[(int)nodeIterator.getSize()];
            Node commentNode = null;
            int i = 0;
            while (nodeIterator.hasNext()) {
                commentNode = nodeIterator.nextNode();
                comments[i] = this.getCommentByNode(commentNode);
                ++i;
            }
            return comments;
        }
        catch (Exception e) {
            log.error((Object)"Fail to get comments: ", (Throwable)e);
            return new Comment[0];
        }
    }

    public Comment getCommentByNode(Node commentNode) throws Exception {
        Comment comment = new Comment();
        comment.setId(commentNode.getName());
        if (commentNode.hasProperty("exo:comments")) {
            comment.setComments(commentNode.getProperty("exo:comments").getString());
        }
        if (commentNode.hasProperty("exo:commentBy")) {
            comment.setCommentBy(commentNode.getProperty("exo:commentBy").getString());
        }
        if (commentNode.hasProperty("exo:fullName")) {
            comment.setFullName(commentNode.getProperty("exo:fullName").getValue().getString());
        }
        if (commentNode.hasProperty("exo:dateComment")) {
            comment.setDateComment(commentNode.getProperty("exo:dateComment").getDate().getTime());
        }
        if (commentNode.hasProperty("exo:postId")) {
            comment.setPostId(commentNode.getProperty("exo:postId").getString());
        }
        return comment;
    }

    private Category getCategory(Node categoryNode) throws Exception {
        Category cat = new Category();
        cat.setId(categoryNode.getName());
        if (categoryNode.hasProperty("exo:name")) {
            cat.setName(categoryNode.getProperty("exo:name").getString());
        }
        if (categoryNode.hasProperty("exo:description")) {
            cat.setDescription(categoryNode.getProperty("exo:description").getString());
        }
        if (categoryNode.hasProperty("exo:createdDate")) {
            cat.setCreatedDate(categoryNode.getProperty("exo:createdDate").getDate().getTime());
        }
        if (categoryNode.hasProperty("exo:moderators")) {
            cat.setModerators(this.ValuesToStrings(categoryNode.getProperty("exo:moderators").getValues()));
        }
        if (categoryNode.hasProperty("exo:userPrivate")) {
            cat.setUserPrivate(this.ValuesToStrings(categoryNode.getProperty("exo:userPrivate").getValues()));
        }
        if (categoryNode.hasProperty("exo:isModerateQuestions")) {
            cat.setModerateQuestions(categoryNode.getProperty("exo:isModerateQuestions").getBoolean());
        }
        String path = categoryNode.getPath();
        cat.setPath(path.substring(path.indexOf(Utils.FAQ_APP) + Utils.FAQ_APP.length() + 1));
        return cat;
    }

    private List<Watch> getWatchs(Node watchNode, boolean isGetAll, int start, int max) throws Exception {
        Watch watch = new Watch();
        ArrayList<Watch> listWatches = new ArrayList<Watch>();
        String[] userWatch = null;
        String[] emails = null;
        String[] RSS = null;
        if (watchNode.hasProperty("exo:emailWatching")) {
            emails = this.ValuesToStrings(watchNode.getProperty("exo:emailWatching").getValues());
        }
        if (watchNode.hasProperty("exo:userWatching")) {
            userWatch = this.ValuesToStrings(watchNode.getProperty("exo:userWatching").getValues());
        }
        if (watchNode.hasProperty("exo:rssWatching")) {
            RSS = this.ValuesToStrings(watchNode.getProperty("exo:rssWatching").getValues());
        }
        if (userWatch != null) {
            if (isGetAll) {
                start = 0;
                max = userWatch.length;
            } else {
                max += start;
                this.setAvailablePage(userWatch.length);
            }
        }
        for (int i = start; i < max && i < userWatch.length; ++i) {
            watch = new Watch();
            watch.setEmails(emails[i]);
            watch.setUser(userWatch[i]);
            listWatches.add(watch);
        }
        return listWatches;
    }

    private String[] ValuesToStrings(Value[] Val) throws Exception {
        if (Val.length == 1) {
            return new String[]{Val[0].getString()};
        }
        String[] Str = new String[Val.length];
        for (int i = 0; i < Val.length; ++i) {
            Str[i] = Val[i].getString();
        }
        return Str;
    }

    private long[] ValuesToLong(Value[] Val) throws Exception {
        if (Val.length < 1) {
            return new long[]{0L};
        }
        long[] d = new long[Val.length];
        for (int i = 0; i < Val.length; ++i) {
            d[i] = Val[i].getLong();
        }
        return d;
    }

    @Override
    public List<Question> getAll() throws Exception {
        if (this.iter_ == null || !this.iter_.hasNext()) {
            Session session = this.getJCRSession();
            if (this.isQuery_) {
                QueryManager qm = session.getWorkspace().getQueryManager();
                Query query = qm.createQuery(this.value_, "xpath");
                QueryResult result = query.execute();
                this.iter_ = result.getNodes();
            } else {
                Node node = (Node)session.getItem(this.value_);
                this.iter_ = node.getNodes();
            }
            this.closeSession();
        }
        ArrayList<Question> questions = new ArrayList<Question>();
        while (this.iter_.hasNext()) {
            Node questionNode = this.iter_.nextNode();
            questions.add(this.getQuestion(questionNode));
        }
        this.iter_ = null;
        return questions;
    }

    public List<Watch> getAllWatch() throws Exception {
        ArrayList<Watch> listWatches = new ArrayList<Watch>();
        if (this.iter_ == null) {
            Session session = this.getJCRSession();
            if (this.isQuery_) {
                QueryManager qm = session.getWorkspace().getQueryManager();
                Query query = qm.createQuery(this.value_, "xpath");
                QueryResult result = query.execute();
                this.iter_ = result.getNodes();
            } else {
                Node node = (Node)session.getItem(this.value_);
                this.iter_ = node.getNodes();
            }
            this.iter_ = null;
            this.closeSession();
        }
        Node watchNode = null;
        while (this.iter_.hasNext()) {
            watchNode = this.iter_.nextNode();
            listWatches.addAll(this.getWatchs(watchNode, true, 0, 0));
        }
        return listWatches;
    }

    @Override
    public void setList(List<Question> contacts) {
    }

    private Session getJCRSession() throws Exception {
        return this.sessionManager.openSession();
    }

    private void closeSession() throws Exception {
        this.sessionManager.closeSession();
    }
}

