/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.exoplatform.commons.utils.PortalPrinter;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.portal.application.PortalURLBuilder;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.Orientation;
import org.exoplatform.web.application.Application;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.web.application.URLBuilder;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.gatein.common.http.QueryStringParser;
import org.gatein.common.util.ParameterMap;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortalRequestContext
extends WebuiRequestContext {
    protected static Log log = ExoLogger.getLogger((String)"portal:PortalRequestContext");
    public static final int PUBLIC_ACCESS = 0;
    public static final int PRIVATE_ACCESS = 1;
    public static final String UI_COMPONENT_ACTION = "portal:action";
    public static final String UI_COMPONENT_ID = "portal:componentId";
    public static final String CACHE_LEVEL = "portal:cacheLevel";
    public static final String REQUEST_TITLE = "portal:requestTitle".intern();
    public static final String REQUEST_METADATA = "portal:requestMetadata".intern();
    private String portalOwner_;
    private String nodePath_;
    private String requestURI_;
    private String portalURI;
    private int accessPath = -1;
    private HttpServletRequest request_;
    private HttpServletResponse response_;
    private String cacheLevel_ = "cacheLevelPortlet";
    private boolean ajaxRequest_ = true;
    private boolean forceFullUpdate = false;
    private Writer writer_;
    protected JavascriptManager jsmanager_ = new JavascriptManager();
    private List<Element> extraMarkupHeaders;
    private final PortalURLBuilder urlBuilder;
    private Map<String, String[]> parameterMap;

    public JavascriptManager getJavascriptManager() {
        return this.jsmanager_;
    }

    public PortalRequestContext(WebuiApplication app, HttpServletRequest req, HttpServletResponse res) throws Exception {
        super((Application)app);
        int colonIndex;
        this.request_ = req;
        this.response_ = res;
        this.response_.setBufferSize(102400);
        this.setSessionId(req.getSession().getId());
        this.response_.setContentType("text/html; charset=UTF-8");
        try {
            this.request_.setCharacterEncoding("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"Encoding not supported", (Throwable)e);
        }
        this.parameterMap = new HashMap<String, String[]>();
        this.parameterMap.putAll(this.request_.getParameterMap());
        String queryString = req.getQueryString();
        if (queryString != null) {
            ParameterMap queryParams = QueryStringParser.getInstance().parseQueryString(queryString);
            this.parameterMap.putAll((Map<String, String[]>)queryParams);
        }
        this.ajaxRequest_ = "true".equals(req.getParameter("ajaxRequest"));
        String cache = req.getParameter(CACHE_LEVEL);
        if (cache != null) {
            this.cacheLevel_ = cache;
        }
        this.requestURI_ = URLDecoder.decode(req.getRequestURI(), "UTF-8");
        String servletPath = URLDecoder.decode(req.getServletPath(), "UTF-8");
        String contextPath = URLDecoder.decode(req.getContextPath(), "UTF-8");
        String pathInfo = this.requestURI_.substring((servletPath + contextPath).length());
        if (pathInfo == null || pathInfo.length() == 0) {
            pathInfo = "/";
        }
        if ((colonIndex = pathInfo.indexOf("/", 1)) < 0) {
            colonIndex = pathInfo.length();
        }
        this.portalOwner_ = pathInfo.substring(1, colonIndex);
        this.nodePath_ = pathInfo.substring(colonIndex, pathInfo.length());
        this.portalURI = this.requestURI_.substring(0, this.requestURI_.lastIndexOf(this.nodePath_)) + "/";
        if (this.requestURI_.indexOf("/public/") >= 0) {
            this.accessPath = 0;
        } else if (this.requestURI_.indexOf("/private/") >= 0) {
            this.accessPath = 1;
        }
        this.urlBuilder = new PortalURLBuilder(this.requestURI_);
    }

    public void refreshResourceBundle() throws Exception {
        this.appRes_ = this.getApplication().getResourceBundle(this.getLocale());
    }

    public String getTitle() throws Exception {
        UIPortal uiportal;
        PageNode node;
        String title = (String)this.request_.getAttribute(REQUEST_TITLE);
        if (title == null && (node = (uiportal = Util.getUIPortal()).getSelectedNode()) != null) {
            ExoContainer container = this.getApplication().getApplicationServiceContainer();
            container.getComponentInstanceOfType(UserPortalConfigService.class);
            UserPortalConfigService configService = (UserPortalConfigService)container.getComponentInstanceOfType(UserPortalConfigService.class);
            Page page = configService.getPage(node.getPageReference(), this.getRemoteUser());
            title = page != null ? page.getTitle() : node.getResolvedLabel();
        }
        return title;
    }

    public Orientation getOrientation() {
        return ((UIPortalApplication)this.uiApplication_).getOrientation();
    }

    public Locale getLocale() {
        return ((UIPortalApplication)this.uiApplication_).getLocale();
    }

    public Map<String, String> getMetaInformation() {
        return (Map)this.request_.getAttribute(REQUEST_METADATA);
    }

    public String getCacheLevel() {
        return this.cacheLevel_;
    }

    public String getRequestParameter(String name) {
        if (this.parameterMap.get(name) != null && this.parameterMap.get(name).length > 0) {
            return this.parameterMap.get(name)[0];
        }
        return null;
    }

    public String[] getRequestParameterValues(String name) {
        return this.parameterMap.get(name);
    }

    public Map<String, String[]> getPortletParameters() {
        Map<String, String[]> unsortedParams = this.parameterMap;
        HashMap<String, String[]> sortedParams = new HashMap<String, String[]>();
        Set<String> keys = unsortedParams.keySet();
        for (String key : keys) {
            if (key.startsWith("portal:")) continue;
            sortedParams.put(key, unsortedParams.get(key));
        }
        return sortedParams;
    }

    public final String getRequestContextPath() {
        return this.request_.getContextPath();
    }

    public String getPortalContextPath() {
        return this.getRequestContextPath();
    }

    public String getActionParameterName() {
        return UI_COMPONENT_ACTION;
    }

    public String getUIComponentIdParameterName() {
        return UI_COMPONENT_ID;
    }

    public String getPortalOwner() {
        return this.portalOwner_;
    }

    public String getNodePath() {
        return this.nodePath_;
    }

    public String getRequestURI() {
        return this.requestURI_;
    }

    public String getPortalURI() {
        return this.portalURI;
    }

    public URLBuilder<UIComponent> getURLBuilder() {
        return this.urlBuilder;
    }

    public int getAccessPath() {
        return this.accessPath;
    }

    public final String getRemoteUser() {
        return this.request_.getRemoteUser();
    }

    public final boolean isUserInRole(String roleUser) {
        return this.request_.isUserInRole(roleUser);
    }

    public final Writer getWriter() throws Exception {
        if (this.writer_ == null) {
            PortalPrinter printer = new PortalPrinter((OutputStream)this.response_.getOutputStream(), true, 30000);
            this.writer_ = printer;
        }
        return this.writer_;
    }

    public final void setWriter(Writer writer) {
        this.writer_ = writer;
    }

    public final boolean useAjax() {
        return this.ajaxRequest_;
    }

    public final HttpServletRequest getRequest() {
        return this.request_;
    }

    public final HttpServletResponse getResponse() {
        return this.response_;
    }

    public final boolean getFullRender() {
        return this.forceFullUpdate;
    }

    public final void setFullRender(boolean forceFullUpdate) {
        this.forceFullUpdate = forceFullUpdate;
    }

    public final void sendRedirect(String url) throws IOException {
        this.setResponseComplete(true);
        this.response_.sendRedirect(url);
    }

    public void setHeaders(Map<String, String> headers) {
        Set<String> keys = headers.keySet();
        for (String key : keys) {
            this.response_.setHeader(key, headers.get(key));
        }
    }

    public List<String> getExtraMarkupHeadersAsStrings() throws Exception {
        ArrayList<String> markupHeaders = new ArrayList<String>();
        if (this.extraMarkupHeaders != null && !this.extraMarkupHeaders.isEmpty()) {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            for (Element element : this.extraMarkupHeaders) {
                DOMSource source = new DOMSource(element);
                StreamResult result = new StreamResult(new StringWriter());
                if (element.getNodeName().equalsIgnoreCase("script")) {
                    transformer.setOutputProperty("method", "html");
                } else {
                    transformer.setOutputProperty("method", "xml");
                }
                transformer.transform(source, result);
                markupHeaders.add(result.getWriter().toString());
            }
        }
        return markupHeaders;
    }

    public List<Element> getExtraMarkupHeaders() {
        return this.extraMarkupHeaders;
    }

    public void addExtraMarkupHeader(Element element) {
        if (this.extraMarkupHeaders == null) {
            this.extraMarkupHeaders = new ArrayList<Element>();
        }
        this.extraMarkupHeaders.add(element);
    }
}

