/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.common.http.client;

import java.io.IOException;
import org.exoplatform.common.http.client.GlobalConstants;
import org.exoplatform.common.http.client.HTTPClientModule;
import org.exoplatform.common.http.client.HTTPConnection;
import org.exoplatform.common.http.client.IdempotentSequence;
import org.exoplatform.common.http.client.ModuleException;
import org.exoplatform.common.http.client.NVPair;
import org.exoplatform.common.http.client.ParseException;
import org.exoplatform.common.http.client.Request;
import org.exoplatform.common.http.client.Response;
import org.exoplatform.common.http.client.RetryException;
import org.exoplatform.common.http.client.RoRequest;
import org.exoplatform.common.http.client.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

class RetryModule
implements HTTPClientModule,
GlobalConstants {
    private static final Log log = ExoLogger.getLogger((String)"exo.ws.commons.RetryModule");

    RetryModule() {
    }

    public int requestHandler(Request req, Response[] resp) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void responsePhase1Handler(Response resp, RoRequest roreq) throws IOException, ModuleException {
        try {
            resp.getStatusCode();
        }
        catch (RetryException re) {
            log.error((Object)"Caught RetryException");
            boolean got_lock = false;
            try {
                RetryException retryException = re.first;
                synchronized (retryException) {
                    got_lock = true;
                    IdempotentSequence seq = new IdempotentSequence();
                    RetryException e = re.first;
                    while (e != null) {
                        seq.add(e.request);
                        e = e.next;
                    }
                    e = re.first;
                    while (e != null) {
                        log.error((Object)"Handling exception ", (Throwable)e);
                        Request req = e.request;
                        HTTPConnection con = req.getConnection();
                        if (!seq.isIdempotent(req) || con.ServProtVersKnown && con.ServerProtocolVersion >= 65537 && req.num_retries > 0 || (!con.ServProtVersKnown || con.ServerProtocolVersion <= 65536) && req.num_retries > 4 || e.response.got_headers) {
                            e.first = null;
                        } else if (req.getStream() != null) {
                            if (HTTPConnection.deferStreamed) {
                                req.getStream().reset();
                                e.response.setRetryRequest(true);
                            }
                            e.first = null;
                        } else {
                            if (req.getData() != null && e.conn_reset) {
                                if (con.ServProtVersKnown && con.ServerProtocolVersion >= 65537) {
                                    this.addToken(req, "Expect", "100-continue");
                                } else {
                                    req.delay_entity = 5000L << req.num_retries;
                                }
                            }
                            if (e.next != null && e.next.request.getData() != null && (!con.ServProtVersKnown || con.ServerProtocolVersion < 65537) && e.conn_reset) {
                                this.addToken(req, "Connection", "close");
                            }
                            if (con.ServProtVersKnown && con.ServerProtocolVersion >= 65537 && e.conn_reset) {
                                req.dont_pipeline = true;
                            }
                            req.dont_pipeline = true;
                            log.info((Object)("Retrying request '" + req.getMethod() + " " + req.getRequestURI() + "'"));
                            if (e.conn_reset) {
                                ++req.num_retries;
                            }
                            e.response.http_resp.set(req, con.sendRequest(req, e.response.timeout));
                            e.exception = null;
                            e.first = null;
                        }
                        e = e.next;
                    }
                }
            }
            catch (NullPointerException npe) {
                if (got_lock) {
                    throw npe;
                }
            }
            catch (ParseException pe) {
                throw new IOException(pe.getMessage());
            }
            if (re.exception != null) {
                throw re.exception;
            }
            re.restart = true;
            throw re;
        }
    }

    public int responsePhase2Handler(Response resp, Request req) {
        req.delay_entity = 0L;
        req.dont_pipeline = false;
        req.num_retries = 0;
        return 10;
    }

    public void responsePhase3Handler(Response resp, RoRequest req) {
    }

    public void trailerHandler(Response resp, RoRequest req) {
    }

    private void addToken(Request req, String hdr, String tok) throws ParseException {
        int idx;
        NVPair[] hdrs = req.getHeaders();
        for (idx = 0; idx < hdrs.length && !hdrs[idx].getName().equalsIgnoreCase(hdr); ++idx) {
        }
        if (idx == hdrs.length) {
            hdrs = Util.resizeArray(hdrs, idx + 1);
            hdrs[idx] = new NVPair(hdr, tok);
            req.setHeaders(hdrs);
        } else if (!Util.hasToken(hdrs[idx].getValue(), tok)) {
            hdrs[idx] = new NVPair(hdr, hdrs[idx].getValue() + ", " + tok);
        }
    }
}

