/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.ExtendedFieldCache;
import org.apache.lucene.search.FieldCacheImpl;

class ExtendedFieldCacheImpl
extends FieldCacheImpl
implements ExtendedFieldCache {
    private static final ExtendedFieldCache.LongParser LONG_PARSER = new ExtendedFieldCache.LongParser(){

        public long parseLong(String value) {
            return Long.parseLong(value);
        }
    };
    private static final ExtendedFieldCache.DoubleParser DOUBLE_PARSER = new ExtendedFieldCache.DoubleParser(){

        public double parseDouble(String value) {
            return Double.parseDouble(value);
        }
    };
    FieldCacheImpl.Cache longsCache = new FieldCacheImpl.Cache(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object createValue(IndexReader reader, Object entryKey) throws IOException {
            FieldCacheImpl.Entry entry = (FieldCacheImpl.Entry)entryKey;
            String field = entry.field;
            ExtendedFieldCache.LongParser parser = (ExtendedFieldCache.LongParser)entry.custom;
            long[] retArray = new long[reader.maxDoc()];
            TermDocs termDocs = reader.termDocs();
            TermEnum termEnum = reader.terms(new Term(field));
            try {
                Term term;
                while ((term = termEnum.term()) != null) {
                    if (term.field() != field) {
                    } else {
                        long termval = parser.parseLong(term.text());
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            retArray[termDocs.doc()] = termval;
                        }
                        if (termEnum.next()) continue;
                    }
                    break;
                }
            }
            finally {
                termDocs.close();
                termEnum.close();
            }
            return retArray;
        }
    };
    FieldCacheImpl.Cache doublesCache = new FieldCacheImpl.Cache(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object createValue(IndexReader reader, Object entryKey) throws IOException {
            FieldCacheImpl.Entry entry = (FieldCacheImpl.Entry)entryKey;
            String field = entry.field;
            ExtendedFieldCache.DoubleParser parser = (ExtendedFieldCache.DoubleParser)entry.custom;
            double[] retArray = new double[reader.maxDoc()];
            TermDocs termDocs = reader.termDocs();
            TermEnum termEnum = reader.terms(new Term(field));
            try {
                Term term;
                while ((term = termEnum.term()) != null) {
                    if (term.field() != field) {
                    } else {
                        double termval = parser.parseDouble(term.text());
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            retArray[termDocs.doc()] = termval;
                        }
                        if (termEnum.next()) continue;
                    }
                    break;
                }
            }
            finally {
                termDocs.close();
                termEnum.close();
            }
            return retArray;
        }
    };
    FieldCacheImpl.Cache autoCache = new FieldCacheImpl.Cache(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object createValue(IndexReader reader, Object fieldKey) throws IOException {
            String field = ((String)fieldKey).intern();
            TermEnum enumerator = reader.terms(new Term(field));
            try {
                Term term = enumerator.term();
                if (term == null) {
                    throw new RuntimeException("no terms in field " + field + " - cannot determine sort type");
                }
                Object ret = null;
                if (term.field() == field) {
                    String termtext = term.text().trim();
                    try {
                        Integer.parseInt(termtext);
                        ret = ExtendedFieldCacheImpl.this.getInts(reader, field);
                    }
                    catch (NumberFormatException nfe1) {
                        try {
                            Long.parseLong(termtext);
                            ret = ExtendedFieldCacheImpl.this.getLongs(reader, field);
                        }
                        catch (NumberFormatException nfe2) {
                            try {
                                Float.parseFloat(termtext);
                                ret = ExtendedFieldCacheImpl.this.getFloats(reader, field);
                            }
                            catch (NumberFormatException nfe3) {
                                ret = ExtendedFieldCacheImpl.this.getStringIndex(reader, field);
                            }
                        }
                    }
                } else {
                    throw new RuntimeException("field \"" + field + "\" does not appear to be indexed");
                }
                int[] nArray = ret;
                return nArray;
            }
            finally {
                enumerator.close();
            }
        }
    };

    ExtendedFieldCacheImpl() {
    }

    public long[] getLongs(IndexReader reader, String field) throws IOException {
        return this.getLongs(reader, field, LONG_PARSER);
    }

    public long[] getLongs(IndexReader reader, String field, ExtendedFieldCache.LongParser parser) throws IOException {
        return (long[])this.longsCache.get(reader, new FieldCacheImpl.Entry(field, parser));
    }

    public double[] getDoubles(IndexReader reader, String field) throws IOException {
        return this.getDoubles(reader, field, DOUBLE_PARSER);
    }

    public double[] getDoubles(IndexReader reader, String field, ExtendedFieldCache.DoubleParser parser) throws IOException {
        return (double[])this.doublesCache.get(reader, new FieldCacheImpl.Entry(field, parser));
    }

    public Object getAuto(IndexReader reader, String field) throws IOException {
        return this.autoCache.get(reader, field);
    }
}

