/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.concurrent;

import net.sf.ehcache.CacheException;
import net.sf.ehcache.concurrent.ConcurrencyUtil;
import net.sf.ehcache.concurrent.Mutex;

public class StripedMutex {
    public static final int DEFAULT_NUMBER_OF_MUTEXES = 2048;
    protected final Mutex[] mutexes;
    private int numberOfStripes;

    public StripedMutex() {
        this.numberOfStripes = 2048;
        this.mutexes = new Mutex[this.numberOfStripes];
        for (int i = 0; i < this.numberOfStripes; ++i) {
            this.mutexes[i] = new Mutex();
        }
    }

    public StripedMutex(int numberOfStripes) {
        if (numberOfStripes % 2 != 0) {
            throw new CacheException("Cannot create a StripedMutex with an odd number of stripes");
        }
        if (numberOfStripes == 0) {
            throw new CacheException("A zero size StripedMutex does not have useful semantics.");
        }
        this.numberOfStripes = numberOfStripes;
        this.mutexes = new Mutex[numberOfStripes];
        for (int i = 0; i < numberOfStripes; ++i) {
            this.mutexes[i] = new Mutex();
        }
    }

    public Mutex getMutexForKey(Object key) {
        int lockNumber = ConcurrencyUtil.selectLock(key, this.numberOfStripes);
        return this.mutexes[lockNumber];
    }
}

