/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wsqa.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.exoplatform.swing.Application;
import org.exoplatform.swing.JExoJavascriptEditor;
import org.exoplatform.swing.JExoToolBar;
import org.exoplatform.swing.ViewPlugin;
import org.exoplatform.swing.event.EventManager;
import org.exoplatform.wsqa.httpclient.Suite;
import org.exoplatform.wsqa.httpclient.WebUnit;
import org.exoplatform.wsqa.recorder.ProxyServer;
import org.exoplatform.wsqa.recorder.RequestFilter;
import org.exoplatform.wsqa.swing.AddRowDialog;
import org.exoplatform.wsqa.swing.ByteComparatorPanel;
import org.exoplatform.wsqa.swing.HttpClientLogViewPlugin;
import org.exoplatform.wsqa.swing.WebUnitCaptor;
import org.exoplatform.wsqa.swing.WebUnitDataViewPlugin;
import org.exoplatform.wsqa.swing.WebunitJavaScriptGenerator;

public class WebunitRecorderViewPlugin
extends JPanel
implements ViewPlugin {
    public static final String WORKSPACE_NAME = "WSQAWorkspace";
    private static String[] TABLE_HEADERS = new String[]{"#", "Name", "Description"};
    private JExoToolBar toolBar_ = new JExoToolBar();
    private ProxyServer server_;
    private Suite suite_ = new Suite();
    private WebunitTableModel webunitTableModel_;
    private JTable webunitTable_;
    private int count = 1;

    public WebunitRecorderViewPlugin() {
        this.setLayout(new BorderLayout());
        this.webunitTable_ = new JTable();
        this.webunitTableModel_ = new WebunitTableModel((Object[][])null, TABLE_HEADERS);
        this.webunitTable_.setModel(this.webunitTableModel_);
        this.webunitTable_.getColumnModel().getColumn(0).setMaxWidth(3);
        final WebUnitPopupMenu popupMenu = new WebUnitPopupMenu();
        this.webunitTable_.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                if (evt.getButton() == 3 || evt.isPopupTrigger()) {
                    JTable source = (JTable)evt.getSource();
                    popupMenu.show(source, evt.getX(), evt.getY());
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.webunitTable_);
        scrollPane.setPreferredSize(new Dimension(150, 150));
        this.add((Component)scrollPane, "Center");
        JButton button = new JButton("Start");
        button.addActionListener(new StartServerListener());
        this.toolBar_.addButton(button);
        button = new JButton("Stop");
        button.addActionListener(new StopServerListener());
        this.toolBar_.addButton(button);
        button = new JButton("Clear");
        button.addActionListener(new ClearWebunitsListener());
        this.toolBar_.addButton(button);
        this.toolBar_.addSeparator();
        button = new JButton("Generate");
        button.setToolTipText("Generate Javascript code");
        button.addActionListener(new GenerateScriptListener());
        this.toolBar_.addButton(button);
        button = new JButton("Log");
        button.setToolTipText("Show Http Client Log");
        button.addActionListener(new ShowLogListener());
        this.toolBar_.addButton(button);
        this.toolBar_.addSeparator();
        this.add((Component)this.toolBar_, "North");
    }

    public String getName() {
        return WORKSPACE_NAME;
    }

    public String getTitle() {
        return "WSQA Workspace";
    }

    public void addUnit(WebUnit unit) throws Exception {
        this.suite_.addWebUnit(unit);
        this.count = this.webunitTableModel_.getRowCount() == 0 ? 1 : 1 + Integer.parseInt(this.webunitTableModel_.getValueAt(this.webunitTableModel_.getRowCount() - 1, 0).toString());
        this.webunitTableModel_.addRow(new String[]{"" + this.count, unit.getPathInfo(), "new "});
        this.webunitTableModel_.fireTableDataChanged();
    }

    public void removeUnit(int row) {
        this.webunitTableModel_.removeRow(row);
        this.webunitTableModel_.fireTableDataChanged();
    }

    public class WebUnitPopupMenu
    extends JPopupMenu {
        public WebUnitPopupMenu() {
            JMenuItem menuItem = new JMenuItem("View Data");
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        int selectedRow = WebunitRecorderViewPlugin.this.webunitTable_.getSelectedRow();
                        WebUnit unit = WebunitRecorderViewPlugin.this.suite_.getWebUnits().get(selectedRow);
                        JInternalFrame frame = Application.getInstance().getWorkspaces().openFrame("Webunit Data");
                        WebUnitDataViewPlugin view = new WebUnitDataViewPlugin();
                        String requestData = unit.getHttpRequest().getRequestDataAsText();
                        String responseData = unit.getHttpResponse().getResponseDataAsText();
                        view.setData(requestData, responseData);
                        frame.add(view);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            this.add(menuItem);
            menuItem = new JMenuItem("View Original Data");
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        int selectedRow = WebunitRecorderViewPlugin.this.webunitTable_.getSelectedRow();
                        WebUnit unit = WebunitRecorderViewPlugin.this.suite_.getWebUnits().get(selectedRow);
                        JInternalFrame frame = Application.getInstance().getWorkspaces().openFrame("Webunit Original Data");
                        WebUnitDataViewPlugin view = new WebUnitDataViewPlugin();
                        String requestData = new String(unit.getHttpRequest().getOriginalRequestData());
                        String responseData = new String(unit.getHttpResponse().getOriginalResponseData());
                        view.setData(requestData, responseData);
                        frame.add(view);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            this.add(menuItem);
            menuItem = new JMenuItem("Remove");
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    int n = JOptionPane.showConfirmDialog(WebunitRecorderViewPlugin.this.webunitTable_, "Do you want to delete this row ?", "Confirm", 0);
                    if (n == 0) {
                        WebunitRecorderViewPlugin.this.removeUnit(WebunitRecorderViewPlugin.this.webunitTable_.getSelectedRow());
                    }
                }
            });
            this.add(menuItem);
            menuItem = new JMenuItem("Add Row");
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    new AddRowDialog();
                }
            });
            menuItem = new JMenuItem("Compare Request");
            menuItem.addActionListener(new RequestComparatorActionListener());
            this.add(menuItem);
            menuItem = new JMenuItem("Compare Response");
            menuItem.addActionListener(new ResponseComparatorActionListener());
            this.add(menuItem);
        }
    }

    public class ResponseComparatorActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            try {
                JInternalFrame frame = Application.getInstance().getWorkspaces().openFrame("Response Data Comparator");
                int selectedRow = WebunitRecorderViewPlugin.this.webunitTable_.getSelectedRow();
                WebUnit unit = WebunitRecorderViewPlugin.this.suite_.getWebUnits().get(selectedRow);
                byte[] resData = unit.getHttpResponse().getResponseData();
                byte[] origResData = unit.getHttpResponse().getOriginalResponseData();
                ByteComparatorPanel byteComparatorPanel = new ByteComparatorPanel(resData, origResData);
                frame.add(byteComparatorPanel);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public class RequestComparatorActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            try {
                JInternalFrame frame = Application.getInstance().getWorkspaces().openFrame("Request Data Comparator");
                int selectedRow = WebunitRecorderViewPlugin.this.webunitTable_.getSelectedRow();
                WebUnit unit = WebunitRecorderViewPlugin.this.suite_.getWebUnits().get(selectedRow);
                byte[] requestData = unit.getHttpRequest().getRequestData();
                byte[] origReqData = unit.getHttpRequest().getOriginalRequestData();
                ByteComparatorPanel byteComparatorPanel = new ByteComparatorPanel(requestData, origReqData);
                frame.add(byteComparatorPanel);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public class GenerateScriptListener
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            try {
                String scriptText = WebunitJavaScriptGenerator.generate(WebunitRecorderViewPlugin.this.suite_);
                JInternalFrame frame = Application.getInstance().getWorkspaces().openFrame("Webunit Script");
                JExoJavascriptEditor editor = new JExoJavascriptEditor();
                editor.setText(scriptText);
                frame.add(editor);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public class ShowLogListener
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            JInternalFrame frame = Application.getInstance().getWorkspaces().getFrame("HttpClientLogViewPlugin");
            if (frame == null) {
                try {
                    frame = Application.getInstance().getWorkspaces().openFrame("Http Client Log");
                    frame.add(HttpClientLogViewPlugin.getInstance());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public class ClearWebunitsListener
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            WebunitRecorderViewPlugin.this.webunitTableModel_.setDataVector((Object[][])null, TABLE_HEADERS);
            WebunitRecorderViewPlugin.this.suite_.getWebUnits().clear();
        }
    }

    public class StopServerListener
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            try {
                if (WebunitRecorderViewPlugin.this.server_ == null) {
                    String message = "Server is already stop..........................";
                    EventManager.getInstance().broadcast("log.event.info", WebunitRecorderViewPlugin.this.server_, "Server is already stop..........................");
                    return;
                }
                WebunitRecorderViewPlugin.this.server_.stopServer();
                WebunitRecorderViewPlugin.this.server_ = null;
                String message = "Stop The Proxy Server..........................";
                EventManager.getInstance().broadcast("log.event.info", WebunitRecorderViewPlugin.this.server_, "Stop The Proxy Server..........................");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public class StartServerListener
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            try {
                if (WebunitRecorderViewPlugin.this.server_ != null) {
                    String message = "Server is already start..........................";
                    EventManager.getInstance().broadcast("log.event.info", WebunitRecorderViewPlugin.this.server_, "Server is already start..........................");
                    return;
                }
                WebunitRecorderViewPlugin.this.server_ = new ProxyServer();
                String[] pattern = new String[]{"/portal/private/.*", "/portal/public/.*", "/portal/j_security_check.*", "/portal/post.jsp.*"};
                RequestFilter filter = new RequestFilter(pattern);
                WebUnitCaptor captor = new WebUnitCaptor();
                captor.setRequestFilter(filter);
                WebunitRecorderViewPlugin.this.server_.add(captor);
                WebunitRecorderViewPlugin.this.server_.start();
                String message = "Start The Proxy Server..........................";
                EventManager.getInstance().broadcast("log.event.info", WebunitRecorderViewPlugin.this.server_, "Start The Proxy Server..........................");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static class WebunitTableModel
    extends DefaultTableModel {
        public WebunitTableModel(Object[][] obj, String[] str) {
            super(obj, str);
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }
}

