/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.application.javascript;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.exoplatform.commons.utils.Safe;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.resource.compressor.ResourceCompressor;
import org.exoplatform.portal.resource.compressor.ResourceType;
import org.exoplatform.web.application.javascript.Javascript;
import org.exoplatform.web.application.javascript.JavascriptDeployer;
import org.exoplatform.web.application.javascript.JavascriptRemoval;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.wci.WebAppListener;
import org.gatein.wci.impl.DefaultServletContainerFactory;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavascriptConfigService
implements Startable {
    private final Logger log = LoggerFactory.getLogger(JavascriptConfigService.class);
    private Collection<String> availableScripts_;
    private Collection<String> availableScriptsPaths_;
    private List<Javascript> availableScriptsKey_;
    private String mergedJavascript = "";
    private HashMap<String, String> extendedJavascripts;
    private byte[] jsBytes = null;
    private long lastModified = Long.MAX_VALUE;
    private JavascriptDeployer deployer;
    private JavascriptRemoval removal;
    private ResourceCompressor compressor;
    private Map<String, List<String>> object_view_of_merged_JS;

    public JavascriptConfigService(ExoContainerContext context, ResourceCompressor compressor) {
        this.compressor = compressor;
        this.availableScripts_ = new ArrayList<String>();
        this.availableScriptsPaths_ = new ArrayList<String>();
        this.availableScriptsKey_ = new ArrayList<Javascript>();
        this.extendedJavascripts = new HashMap();
        this.deployer = new JavascriptDeployer(context.getPortalContainerName(), this);
        this.removal = new JavascriptRemoval(context.getPortalContainerName(), this);
        this.object_view_of_merged_JS = new HashMap<String, List<String>>();
    }

    public Collection<String> getAvailableScripts() {
        return this.availableScripts_;
    }

    public Collection<String> getAvailableScriptsPaths() {
        return this.availableScriptsPaths_;
    }

    public synchronized void addExtendedJavascript(String module, String scriptPath, ServletContext scontext, String scriptData) {
        String servletContextName = scontext.getServletContextName();
        String path = "/" + servletContextName + scriptPath;
        this.availableScripts_.add(module);
        this.availableScriptsPaths_.add(path);
        this.extendedJavascripts.put(path, scriptData);
    }

    public synchronized void addJavascripts(List<Javascript> jsKeys) {
        this.availableScriptsKey_.addAll(jsKeys);
        Collections.sort(this.availableScriptsKey_, new Comparator<Javascript>(){

            @Override
            public int compare(Javascript o1, Javascript o2) {
                if (o1.getPriority() == o2.getPriority()) {
                    return o1.getKey().getModule().compareTo(o2.getKey().getModule());
                }
                if (o1.getPriority() < 0) {
                    return 1;
                }
                if (o2.getPriority() < 0) {
                    return -1;
                }
                return o1.getPriority() - o2.getPriority();
            }
        });
        this.mergedJavascript = "";
        this.availableScripts_.clear();
        this.availableScriptsPaths_.clear();
        this.object_view_of_merged_JS.clear();
        for (Javascript script : this.availableScriptsKey_) {
            this.addJavascript(script);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addJavascript(Javascript javascript) {
        this.availableScripts_.add(javascript.getKey().getModule());
        this.availableScriptsPaths_.add(javascript.getPath());
        List<String> mergedJS_list = this.object_view_of_merged_JS.get(javascript.getKey().getContextPath());
        if (mergedJS_list == null) {
            mergedJS_list = new ArrayList<String>();
            this.object_view_of_merged_JS.put(javascript.getKey().getContextPath(), mergedJS_list);
        }
        if (!javascript.getKey().isExternalScript()) {
            StringBuffer sB = new StringBuffer();
            String line = "";
            try {
                BufferedReader reader = javascript.getReader();
                try {
                    while ((line = reader.readLine()) != null) {
                        line = line + "\n";
                        sB.append(line);
                        mergedJS_list.add(line);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                finally {
                    Safe.close((Closeable)reader);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            sB.append("\n");
            mergedJS_list.add("\n");
            this.mergedJavascript = this.mergedJavascript.concat(sB.toString());
        }
    }

    public synchronized void remove(ServletContext context) {
        for (Javascript script : new ArrayList<Javascript>(this.availableScriptsKey_)) {
            if (!script.getContext().getContextPath().equals(context.getContextPath())) continue;
            this.removeJavascript(script);
        }
    }

    public synchronized void removeJavascript(Javascript script) {
        this.availableScripts_.remove(script.getKey().getModule());
        this.availableScriptsPaths_.remove(script.getPath());
        this.object_view_of_merged_JS.remove(script.getKey().getContextPath());
        Iterator<Javascript> i = this.availableScriptsKey_.iterator();
        while (i.hasNext()) {
            Javascript _script = i.next();
            if (!script.getKey().equals(_script.getKey())) continue;
            i.remove();
        }
    }

    public void refreshMergedJavascript() {
        this.mergedJavascript = "";
        StringBuffer buffer = new StringBuffer();
        for (String webApp : this.object_view_of_merged_JS.keySet()) {
            for (String jsPath : this.object_view_of_merged_JS.get(webApp)) {
                buffer.append(jsPath);
            }
        }
        this.mergedJavascript = buffer.toString();
    }

    public void writeMergedJavascript(OutputStream out) throws IOException {
        this.jsBytes = this.getMergedJavascript();
        out.write(this.jsBytes);
    }

    public byte[] getMergedJavascript() {
        if (this.jsBytes == null) {
            byte[] bytes;
            StringBuffer allJavascript = new StringBuffer();
            allJavascript.append(this.mergedJavascript);
            for (String script : this.extendedJavascripts.values()) {
                allJavascript.append(script);
            }
            String s = allJavascript.toString();
            try {
                bytes = s.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)"No access to UTF-8, e");
            }
            try {
                StringReader input = new StringReader(s);
                StringWriter output = new StringWriter();
                this.compressor.compress(input, output, ResourceType.JAVASCRIPT);
                this.jsBytes = output.toString().getBytes();
            }
            catch (Exception e) {
                this.log.error((Object)"Error when generating minified javascript, will use normal javascript instead", (Throwable)e);
                this.jsBytes = bytes;
            }
            this.lastModified = new Date().getTime() / 1000L * 1000L;
        }
        return this.jsBytes;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public boolean isModuleLoaded(CharSequence module) {
        return this.getAvailableScripts().contains(module);
    }

    public void removeExtendedJavascript(String module, String scriptPath, ServletContext scontext) {
        String servletContextName = scontext.getServletContextName();
        this.availableScripts_.remove(module);
        String path = "/" + servletContextName + scriptPath;
        this.availableScriptsPaths_.remove(path);
        this.extendedJavascripts.remove(path);
        this.jsBytes = null;
    }

    public void start() {
        DefaultServletContainerFactory.getInstance().getServletContainer().addWebAppListener((WebAppListener)this.deployer);
        DefaultServletContainerFactory.getInstance().getServletContainer().addWebAppListener((WebAppListener)this.removal);
    }

    public void stop() {
        DefaultServletContainerFactory.getInstance().getServletContainer().removeWebAppListener((WebAppListener)this.deployer);
        DefaultServletContainerFactory.getInstance().getServletContainer().removeWebAppListener((WebAppListener)this.removal);
    }
}

