/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.priority;

import java.util.List;
import org.exoplatform.services.jcr.ext.replication.Packet;
import org.exoplatform.services.jcr.ext.replication.priority.AbstractPriorityChecker;
import org.exoplatform.services.jcr.ext.replication.transport.AbstractPacket;
import org.exoplatform.services.jcr.ext.replication.transport.ChannelManager;
import org.exoplatform.services.jcr.ext.replication.transport.MemberAddress;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericPriorityChecker
extends AbstractPriorityChecker {
    private static Log log = ExoLogger.getLogger("exo.jcr.component.ext.GenericPriorityChecker");

    public GenericPriorityChecker(ChannelManager channelManager, int ownPriority, String ownName, List<String> otherParticipants) {
        super(channelManager, ownPriority, ownName, otherParticipants);
    }

    @Override
    public boolean isMaxPriority() {
        return true;
    }

    @Override
    public void receive(AbstractPacket p, MemberAddress sourceAddress) {
        Packet packet = (Packet)p;
        if (log.isDebugEnabled()) {
            log.debug(" ------->>> receive from " + packet.getOwnerName() + ", byte == " + packet.getByteArray().length);
        }
        try {
            if (!this.ownName.equals(packet.getOwnerName())) {
                switch (packet.getPacketType()) {
                    case 30: {
                        Packet pktMyPriority = new Packet(31, this.ownName, this.ownPriority, packet.getIdentifier());
                        this.channelManager.sendPacket(pktMyPriority);
                        break;
                    }
                    case 31: {
                        if (this.identifier != null && this.identifier.equals(packet.getIdentifier())) {
                            this.currentParticipants.put(packet.getOwnerName(), (int)packet.getSize());
                            if (log.isDebugEnabled()) {
                                log.info(this.channelManager.getChannel().getClusterName() + " : " + this.identifier + " : added member :");
                                log.info("   +" + packet.getOwnerName() + ":" + this.currentParticipants.get(packet.getOwnerName()));
                            }
                        }
                        if (!log.isDebugEnabled()) break;
                        this.printOnlineMembers();
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("An error in processing packet : ", e);
        }
    }

    @Override
    public boolean hasDuplicatePriority() {
        return false;
    }

    @Override
    public void onError(MemberAddress sourceAddress) {
    }
}

