/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.eviction.EvictionActionPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEvictionActionPolicy
implements EvictionActionPolicy {
    Cache<?, ?> cache;
    private static final Log log = LogFactory.getLog(DefaultEvictionActionPolicy.class);

    @Override
    public void setCache(Cache<?, ?> cache) {
        this.cache = cache;
    }

    @Override
    public boolean evict(Fqn fqn) {
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Evicting Fqn " + fqn));
            }
            this.cache.evict(fqn);
            return true;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unable to evict " + fqn), (Throwable)e);
            }
            return false;
        }
    }
}

