/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.ComponentLifecycleScope;
import org.exoplatform.services.rest.ContainerObjectFactory;
import org.exoplatform.services.rest.FilterDescriptor;
import org.exoplatform.services.rest.ObjectFactory;
import org.exoplatform.services.rest.PerRequestObjectFactory;
import org.exoplatform.services.rest.RequestFilter;
import org.exoplatform.services.rest.ResponseFilter;
import org.exoplatform.services.rest.SingletonObjectFactory;
import org.exoplatform.services.rest.impl.ApplicationContextImpl;
import org.exoplatform.services.rest.impl.DefaultExceptionMapper;
import org.exoplatform.services.rest.impl.FilterDescriptorImpl;
import org.exoplatform.services.rest.impl.header.MediaTypeHelper;
import org.exoplatform.services.rest.impl.provider.ByteEntityProvider;
import org.exoplatform.services.rest.impl.provider.DOMSourceEntityProvider;
import org.exoplatform.services.rest.impl.provider.DataSourceEntityProvider;
import org.exoplatform.services.rest.impl.provider.FileEntityProvider;
import org.exoplatform.services.rest.impl.provider.InputStreamEntityProvider;
import org.exoplatform.services.rest.impl.provider.JAXBContextResolver;
import org.exoplatform.services.rest.impl.provider.JAXBElementEntityProvider;
import org.exoplatform.services.rest.impl.provider.JAXBObjectEntityProvider;
import org.exoplatform.services.rest.impl.provider.JsonEntityProvider;
import org.exoplatform.services.rest.impl.provider.MultipartFormDataEntityProvider;
import org.exoplatform.services.rest.impl.provider.MultivaluedMapEntityProvider;
import org.exoplatform.services.rest.impl.provider.ProviderDescriptorImpl;
import org.exoplatform.services.rest.impl.provider.ReaderEntityProvider;
import org.exoplatform.services.rest.impl.provider.SAXSourceEntityProvider;
import org.exoplatform.services.rest.impl.provider.StreamOutputEntityProvider;
import org.exoplatform.services.rest.impl.provider.StreamSourceEntityProvider;
import org.exoplatform.services.rest.impl.provider.StringEntityProvider;
import org.exoplatform.services.rest.impl.resource.ResourceDescriptorValidator;
import org.exoplatform.services.rest.method.MethodInvokerFilter;
import org.exoplatform.services.rest.provider.ProviderDescriptor;
import org.exoplatform.services.rest.resource.ResourceDescriptorVisitor;
import org.exoplatform.services.rest.uri.UriPattern;
import org.exoplatform.services.rest.util.MediaTypeMap;
import org.exoplatform.services.rest.util.MediaTypeMultivaluedMap;
import org.exoplatform.services.rest.util.UriPatternMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProviderBinder
implements Providers {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.ws.rest.core.ProviderBinder");
    private static AtomicReference<ProviderBinder> ainst = new AtomicReference();
    private final MediaTypeMultivaluedMap<ObjectFactory<ProviderDescriptor>> writeProviders = new MediaTypeMultivaluedMap();
    private final MediaTypeMultivaluedMap<ObjectFactory<ProviderDescriptor>> readProviders = new MediaTypeMultivaluedMap();
    private final Map<Class<? extends Throwable>, ObjectFactory<ProviderDescriptor>> exceptionMappers = new HashMap<Class<? extends Throwable>, ObjectFactory<ProviderDescriptor>>();
    private final Map<Class<?>, MediaTypeMap<ObjectFactory<ProviderDescriptor>>> contextResolvers = new HashMap();
    private final UriPatternMap<ObjectFactory<FilterDescriptor>> requestFilters = new UriPatternMap();
    private final UriPatternMap<ObjectFactory<FilterDescriptor>> responseFilters = new UriPatternMap();
    private final UriPatternMap<ObjectFactory<FilterDescriptor>> invokerFilters = new UriPatternMap();
    private final ResourceDescriptorVisitor rdv = ResourceDescriptorValidator.getInstance();

    public static ProviderBinder getInstance() {
        ProviderBinder t = ainst.get();
        if (t == null) {
            ainst.compareAndSet(null, new ProviderBinder());
            t = ainst.get();
        }
        return t;
    }

    public static void setInstance(ProviderBinder inst) {
        ainst.set(inst);
    }

    public ProviderBinder() {
        this.init();
    }

    protected void init() {
        ByteEntityProvider baep = new ByteEntityProvider();
        this.addMessageBodyReader(baep);
        this.addMessageBodyWriter(baep);
        DataSourceEntityProvider dsep = new DataSourceEntityProvider();
        this.addMessageBodyReader(dsep);
        this.addMessageBodyWriter(dsep);
        DOMSourceEntityProvider domsep = new DOMSourceEntityProvider();
        this.addMessageBodyReader(domsep);
        this.addMessageBodyWriter(domsep);
        FileEntityProvider fep = new FileEntityProvider();
        this.addMessageBodyReader(fep);
        this.addMessageBodyWriter(fep);
        MultivaluedMapEntityProvider mvep = new MultivaluedMapEntityProvider();
        this.addMessageBodyReader(mvep);
        this.addMessageBodyWriter(mvep);
        InputStreamEntityProvider isep = new InputStreamEntityProvider();
        this.addMessageBodyReader(isep);
        this.addMessageBodyWriter(isep);
        ReaderEntityProvider rep = new ReaderEntityProvider();
        this.addMessageBodyReader(rep);
        this.addMessageBodyWriter(rep);
        SAXSourceEntityProvider saxep = new SAXSourceEntityProvider();
        this.addMessageBodyReader(saxep);
        this.addMessageBodyWriter(saxep);
        StreamSourceEntityProvider ssep = new StreamSourceEntityProvider();
        this.addMessageBodyReader(ssep);
        this.addMessageBodyWriter(ssep);
        StringEntityProvider sep = new StringEntityProvider();
        this.addMessageBodyReader(sep);
        this.addMessageBodyWriter(sep);
        StreamOutputEntityProvider soep = new StreamOutputEntityProvider();
        this.addMessageBodyReader(soep);
        this.addMessageBodyWriter(soep);
        JsonEntityProvider jsep = new JsonEntityProvider();
        this.addMessageBodyReader(jsep);
        this.addMessageBodyWriter(jsep);
        this.addMessageBodyReader(JAXBElementEntityProvider.class);
        this.addMessageBodyWriter(JAXBElementEntityProvider.class);
        this.addMessageBodyReader(JAXBObjectEntityProvider.class);
        this.addMessageBodyWriter(JAXBObjectEntityProvider.class);
        this.addMessageBodyReader(MultipartFormDataEntityProvider.class);
        this.addContextResolver(JAXBContextResolver.class, null, ComponentLifecycleScope.CONTAINER);
        this.addExceptionMapper(new DefaultExceptionMapper());
    }

    public void addContextResolver(Class<? extends ContextResolver> clazz) {
        try {
            this.addContextResolver(clazz, null, ComponentLifecycleScope.PER_REQUEST);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed add ContextResolver " + clazz.getName()), (Throwable)e);
        }
    }

    public void addContextResolver(ContextResolver instance) {
        Class<?> clazz = instance.getClass();
        try {
            this.addContextResolver(clazz, instance, ComponentLifecycleScope.SINGLETON);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed add ContextResolver " + clazz.getName()), (Throwable)e);
        }
    }

    public void addExceptionMapper(Class<? extends ExceptionMapper> clazz) {
        try {
            this.addExceptionMapper(clazz, null, ComponentLifecycleScope.PER_REQUEST);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed add ExceptionMapper " + clazz.getName()), (Throwable)e);
        }
    }

    public void addExceptionMapper(ExceptionMapper instance) {
        Class<?> clazz = instance.getClass();
        try {
            this.addExceptionMapper(clazz, instance, ComponentLifecycleScope.SINGLETON);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed add ExceptionMapper " + clazz.getName()), (Throwable)e);
        }
    }

    public void addMessageBodyReader(Class<? extends MessageBodyReader> clazz) {
        try {
            this.addMessageBodyReader(clazz, null, ComponentLifecycleScope.PER_REQUEST);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed add MessageBodyReader " + clazz.getName()), (Throwable)e);
        }
    }

    public void addMessageBodyReader(MessageBodyReader instance) {
        Class<?> clazz = instance.getClass();
        try {
            this.addMessageBodyReader(clazz, instance, ComponentLifecycleScope.SINGLETON);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed add MessageBodyReader " + clazz.getName()), (Throwable)e);
        }
    }

    public void addMessageBodyWriter(Class<? extends MessageBodyWriter> clazz) {
        try {
            this.addMessageBodyWriter(clazz, null, ComponentLifecycleScope.PER_REQUEST);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed add MessageBodyWriter " + clazz.getName()), (Throwable)e);
        }
    }

    public void addMessageBodyWriter(MessageBodyWriter instance) {
        Class<?> clazz = instance.getClass();
        try {
            this.addMessageBodyWriter(clazz, instance, ComponentLifecycleScope.SINGLETON);
        }
        catch (Exception e) {
            LOG.error((Object)"Failed add MessageBodyWriter ", (Throwable)e);
        }
    }

    public List<MediaType> getAcceptableWriterMediaTypes(Class<?> type, Type genericType, Annotation[] annotations) {
        ArrayList<MediaType> l = new ArrayList<MediaType>();
        for (Map.Entry e : this.writeProviders.entrySet()) {
            MediaType mime = (MediaType)e.getKey();
            for (ObjectFactory pf : (List)e.getValue()) {
                MessageBodyWriter writer = (MessageBodyWriter)pf.getInstance(ApplicationContextImpl.getCurrent());
                if (!writer.isWriteable(type, genericType, annotations, MediaTypeHelper.DEFAULT_TYPE)) continue;
                l.add(mime);
            }
        }
        Collections.sort(l, MediaTypeHelper.MEDIA_TYPE_COMPARATOR);
        return l;
    }

    public <T> ContextResolver<T> getContextResolver(Class<T> contextType, MediaType mediaType) {
        MediaTypeMap<ObjectFactory<ProviderDescriptor>> pm = this.contextResolvers.get(contextType);
        ContextResolver<T> resolver = null;
        if (pm != null) {
            if (mediaType == null) {
                return this._getContextResolver(pm, contextType, MediaTypeHelper.DEFAULT_TYPE);
            }
            resolver = this._getContextResolver(pm, contextType, mediaType);
            if (resolver == null) {
                resolver = this._getContextResolver(pm, contextType, new MediaType(mediaType.getType(), "*"));
            }
            if (resolver == null) {
                resolver = this._getContextResolver(pm, contextType, MediaTypeHelper.DEFAULT_TYPE);
            }
        }
        return resolver;
    }

    public <T extends Throwable> ExceptionMapper<T> getExceptionMapper(Class<T> type) {
        ObjectFactory<ProviderDescriptor> pf = this.exceptionMappers.get(type);
        if (pf != null) {
            return (ExceptionMapper)pf.getInstance(ApplicationContextImpl.getCurrent());
        }
        return null;
    }

    public <T> MessageBodyReader<T> getMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (mediaType == null) {
            return this._getMessageBodyReader(type, genericType, annotations, MediaTypeHelper.DEFAULT_TYPE);
        }
        MessageBodyReader<T> reader = this._getMessageBodyReader(type, genericType, annotations, mediaType);
        if (reader == null) {
            reader = this._getMessageBodyReader(type, genericType, annotations, new MediaType(mediaType.getType(), "*"));
        }
        if (reader == null) {
            reader = this._getMessageBodyReader(type, genericType, annotations, MediaTypeHelper.DEFAULT_TYPE);
        }
        return reader;
    }

    public <T> MessageBodyWriter<T> getMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (mediaType == null) {
            return this._getMessageBodyWriter(type, genericType, annotations, MediaTypeHelper.DEFAULT_TYPE);
        }
        MessageBodyWriter<T> writer = this._getMessageBodyWriter(type, genericType, annotations, mediaType);
        if (writer == null) {
            writer = this._getMessageBodyWriter(type, genericType, annotations, new MediaType(mediaType.getType(), "*"));
        }
        if (writer == null) {
            writer = this._getMessageBodyWriter(type, genericType, annotations, MediaTypeHelper.DEFAULT_TYPE);
        }
        return writer;
    }

    public void addMethodInvokerFilter(Class<? extends MethodInvokerFilter> clazz) {
        try {
            this.addMethodInvokerFilter(clazz, null, ComponentLifecycleScope.PER_REQUEST);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed add MethodInvokerFilter " + clazz.getName()), (Throwable)e);
        }
    }

    public void addMethodInvokerFilter(MethodInvokerFilter instance) {
        Class<?> clazz = instance.getClass();
        try {
            this.addMethodInvokerFilter(clazz, instance, ComponentLifecycleScope.SINGLETON);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed add RequestFilter " + clazz.getName()), (Throwable)e);
        }
    }

    public void addRequestFilter(Class<? extends RequestFilter> clazz) {
        try {
            this.addRequestFilter(clazz, null, ComponentLifecycleScope.PER_REQUEST);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed add MethodInvokerFilter " + clazz.getName()), (Throwable)e);
        }
    }

    public void addRequestFilter(RequestFilter instance) {
        Class<?> clazz = instance.getClass();
        try {
            this.addRequestFilter(clazz, instance, ComponentLifecycleScope.SINGLETON);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed add RequestFilter " + clazz.getName()), (Throwable)e);
        }
    }

    public void addResponseFilter(Class<? extends ResponseFilter> clazz) {
        try {
            this.addResponseFilter(clazz, null, ComponentLifecycleScope.PER_REQUEST);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed add ResponseFilter " + clazz.getName()), (Throwable)e);
        }
    }

    public void addResponseFilter(ResponseFilter instance) {
        Class<?> clazz = instance.getClass();
        try {
            this.addResponseFilter(clazz, instance, ComponentLifecycleScope.SINGLETON);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed add ResponseFilter " + clazz.getName()), (Throwable)e);
        }
    }

    public List<ObjectFactory<FilterDescriptor>> getMethodInvokerFilters(String path) {
        return this.getMatchedFilters(path, this.invokerFilters);
    }

    public List<ObjectFactory<FilterDescriptor>> getRequestFilters(String path) {
        return this.getMatchedFilters(path, this.requestFilters);
    }

    public List<ObjectFactory<FilterDescriptor>> getResponseFilters(String path) {
        return this.getMatchedFilters(path, this.responseFilters);
    }

    private List<ObjectFactory<FilterDescriptor>> getMatchedFilters(String path, UriPatternMap<ObjectFactory<FilterDescriptor>> m) {
        ArrayList<ObjectFactory<FilterDescriptor>> l = new ArrayList<ObjectFactory<FilterDescriptor>>();
        ArrayList<String> capturingValues = new ArrayList<String>();
        for (Map.Entry e : m.entrySet()) {
            int len;
            UriPattern uriPattern = (UriPattern)e.getKey();
            if (uriPattern != null && (!((UriPattern)e.getKey()).match(path, capturingValues) || capturingValues.get((len = capturingValues.size()) - 1) != null && !"/".equals(capturingValues.get(len - 1)))) continue;
            l.addAll((Collection)e.getValue());
        }
        return l;
    }

    private <T> ContextResolver<T> _getContextResolver(MediaTypeMap<ObjectFactory<ProviderDescriptor>> pm, Class<T> contextType, MediaType mediaType) {
        for (Map.Entry e : pm.entrySet()) {
            if (!mediaType.isCompatible((MediaType)e.getKey())) continue;
            return (ContextResolver)((ObjectFactory)e.getValue()).getInstance(ApplicationContextImpl.getCurrent());
        }
        return null;
    }

    private <T> MessageBodyReader<T> _getMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        for (ObjectFactory<ProviderDescriptor> pf : this.readProviders.getList(mediaType)) {
            MessageBodyReader reader = (MessageBodyReader)pf.getInstance(ApplicationContextImpl.getCurrent());
            if (!reader.isReadable(type, genericType, annotations, mediaType)) continue;
            return reader;
        }
        return null;
    }

    private <T> MessageBodyWriter<T> _getMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        for (ObjectFactory<ProviderDescriptor> pf : this.writeProviders.getList(mediaType)) {
            MessageBodyWriter writer = (MessageBodyWriter)pf.getInstance(ApplicationContextImpl.getCurrent());
            if (!writer.isWriteable(type, genericType, annotations, mediaType)) continue;
            return writer;
        }
        return null;
    }

    public void addContextResolver(Class<? extends ContextResolver> clazz, ContextResolver instance, ComponentLifecycleScope scope) {
        for (Type type : clazz.getGenericInterfaces()) {
            ParameterizedType pt;
            if (!(type instanceof ParameterizedType) || ContextResolver.class != (pt = (ParameterizedType)type).getRawType()) continue;
            Type[] atypes = pt.getActualTypeArguments();
            if (atypes.length > 1) {
                throw new RuntimeException("Unable strong determine actual type argument, more then one type found.");
            }
            Class aclazz = (Class)atypes[0];
            MediaTypeMap<ObjectFactory<ProviderDescriptor>> pm = this.contextResolvers.get(aclazz);
            if (pm == null) {
                pm = new MediaTypeMap();
                this.contextResolvers.put(aclazz, pm);
            }
            ProviderDescriptorImpl descriptor = new ProviderDescriptorImpl(clazz);
            descriptor.accept(this.rdv);
            ObjectFactory<ProviderDescriptorImpl> factory = null;
            switch (scope) {
                case PER_REQUEST: {
                    factory = new PerRequestObjectFactory<ProviderDescriptorImpl>(descriptor);
                    break;
                }
                case SINGLETON: {
                    if (instance == null) {
                        throw new NullPointerException("ContextResolver instance is null.");
                    }
                    factory = new SingletonObjectFactory<ProviderDescriptorImpl>(descriptor, instance);
                    break;
                }
                case CONTAINER: {
                    factory = new ContainerObjectFactory<ProviderDescriptorImpl>(descriptor);
                }
            }
            for (MediaType mime : ((ProviderDescriptor)factory.getObjectModel()).produces()) {
                if (pm.get(mime) != null) {
                    String msg = "ContextResolver for " + aclazz.getName() + " and media type " + mime + " already registered.";
                    throw new RuntimeException(msg);
                }
                pm.put(mime, factory);
            }
        }
    }

    public void addMessageBodyReader(Class<? extends MessageBodyReader> clazz, MessageBodyReader instance, ComponentLifecycleScope scope) {
        ProviderDescriptorImpl descriptor = new ProviderDescriptorImpl(clazz);
        descriptor.accept(this.rdv);
        ObjectFactory<ProviderDescriptorImpl> factory = null;
        switch (scope) {
            case PER_REQUEST: {
                factory = new PerRequestObjectFactory<ProviderDescriptorImpl>(descriptor);
                break;
            }
            case SINGLETON: {
                if (instance == null) {
                    throw new NullPointerException("MessageBodyReader instance is null.");
                }
                factory = new SingletonObjectFactory<ProviderDescriptorImpl>(descriptor, instance);
                break;
            }
            case CONTAINER: {
                factory = new ContainerObjectFactory<ProviderDescriptorImpl>(descriptor);
            }
        }
        for (MediaType mime : ((ProviderDescriptor)factory.getObjectModel()).consumes()) {
            this.readProviders.getList(mime).add(factory);
        }
    }

    public void addMessageBodyWriter(Class<? extends MessageBodyWriter> clazz, MessageBodyWriter instance, ComponentLifecycleScope scope) {
        ProviderDescriptorImpl descriptor = new ProviderDescriptorImpl(clazz);
        descriptor.accept(this.rdv);
        ObjectFactory<ProviderDescriptorImpl> factory = null;
        switch (scope) {
            case PER_REQUEST: {
                factory = new PerRequestObjectFactory<ProviderDescriptorImpl>(descriptor);
                break;
            }
            case SINGLETON: {
                if (instance == null) {
                    throw new NullPointerException("MessageBodyWriter instance is null.");
                }
                factory = new SingletonObjectFactory<ProviderDescriptorImpl>(descriptor, instance);
                break;
            }
            case CONTAINER: {
                factory = new ContainerObjectFactory<ProviderDescriptorImpl>(descriptor);
            }
        }
        for (MediaType mime : ((ProviderDescriptor)factory.getObjectModel()).produces()) {
            this.writeProviders.getList(mime).add(factory);
        }
    }

    public void addExceptionMapper(Class<? extends ExceptionMapper> clazz, ExceptionMapper instance, ComponentLifecycleScope scope) {
        for (Type type : clazz.getGenericInterfaces()) {
            ParameterizedType pt;
            if (!(type instanceof ParameterizedType) || ExceptionMapper.class != (pt = (ParameterizedType)type).getRawType()) continue;
            Type[] atypes = pt.getActualTypeArguments();
            if (atypes.length > 1) {
                throw new RuntimeException("Unable strong determine actual type argument, more then one type found.");
            }
            Class exc = (Class)atypes[0];
            if (this.exceptionMappers.get(exc) != null) {
                String msg = "ExceptionMapper for exception " + exc + " already registered.";
                throw new RuntimeException(msg);
            }
            ProviderDescriptorImpl descriptor = new ProviderDescriptorImpl(clazz);
            descriptor.accept(this.rdv);
            ObjectFactory<ProviderDescriptorImpl> factory = null;
            switch (scope) {
                case PER_REQUEST: {
                    factory = new PerRequestObjectFactory<ProviderDescriptorImpl>(descriptor);
                    break;
                }
                case SINGLETON: {
                    if (instance == null) {
                        throw new NullPointerException("ExceptionMapper instance is null.");
                    }
                    factory = new SingletonObjectFactory<ProviderDescriptorImpl>(descriptor, instance);
                    break;
                }
                case CONTAINER: {
                    factory = new ContainerObjectFactory<ProviderDescriptorImpl>(descriptor);
                }
            }
            this.exceptionMappers.put(exc, factory);
        }
    }

    public void addRequestFilter(Class<? extends RequestFilter> clazz, RequestFilter instance, ComponentLifecycleScope scope) {
        FilterDescriptorImpl descriptor = new FilterDescriptorImpl(clazz);
        descriptor.accept(this.rdv);
        ObjectFactory<FilterDescriptorImpl> factory = new PerRequestObjectFactory<FilterDescriptorImpl>(descriptor);
        switch (scope) {
            case PER_REQUEST: {
                factory = new PerRequestObjectFactory<FilterDescriptorImpl>(descriptor);
                break;
            }
            case SINGLETON: {
                if (instance == null) {
                    throw new NullPointerException("RequestFilter instance is null.");
                }
                factory = new SingletonObjectFactory<FilterDescriptorImpl>(descriptor, instance);
                break;
            }
            case CONTAINER: {
                factory = new ContainerObjectFactory<FilterDescriptorImpl>(descriptor);
            }
        }
        this.requestFilters.getList(descriptor.getUriPattern()).add(factory);
    }

    public void addResponseFilter(Class<? extends ResponseFilter> clazz, ResponseFilter instance, ComponentLifecycleScope scope) {
        FilterDescriptorImpl descriptor = new FilterDescriptorImpl(clazz);
        descriptor.accept(this.rdv);
        ObjectFactory<FilterDescriptorImpl> factory = new PerRequestObjectFactory<FilterDescriptorImpl>(descriptor);
        switch (scope) {
            case PER_REQUEST: {
                factory = new PerRequestObjectFactory<FilterDescriptorImpl>(descriptor);
                break;
            }
            case SINGLETON: {
                if (instance == null) {
                    throw new NullPointerException("ResponseFilter instance is null.");
                }
                factory = new SingletonObjectFactory<FilterDescriptorImpl>(descriptor, instance);
                break;
            }
            case CONTAINER: {
                factory = new ContainerObjectFactory<FilterDescriptorImpl>(descriptor);
            }
        }
        this.responseFilters.getList(descriptor.getUriPattern()).add(factory);
    }

    public void addMethodInvokerFilter(Class<? extends MethodInvokerFilter> clazz, MethodInvokerFilter instance, ComponentLifecycleScope scope) {
        FilterDescriptorImpl descriptor = new FilterDescriptorImpl(clazz);
        descriptor.accept(this.rdv);
        ObjectFactory<FilterDescriptorImpl> factory = new PerRequestObjectFactory<FilterDescriptorImpl>(descriptor);
        switch (scope) {
            case PER_REQUEST: {
                factory = new PerRequestObjectFactory<FilterDescriptorImpl>(descriptor);
                break;
            }
            case SINGLETON: {
                if (instance == null) {
                    throw new NullPointerException("MethodInvokerFilter instance is null.");
                }
                factory = new SingletonObjectFactory<FilterDescriptorImpl>(descriptor, instance);
                break;
            }
            case CONTAINER: {
                factory = new ContainerObjectFactory<FilterDescriptorImpl>(descriptor);
            }
        }
        this.invokerFilters.getList(descriptor.getUriPattern()).add(factory);
    }
}

