/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class DetermineFragSize {
    static int senseMaxFragSize() {
        InetAddress local_addr;
        DatagramSocket sock;
        int upper = 4096;
        int lower = 0;
        int highest_failed = -1;
        int num_iterations = 15;
        try {
            sock = new DatagramSocket();
            local_addr = InetAddress.getLocalHost();
        }
        catch (Exception ex) {
            System.err.println("failed creating DatagramSocket: " + ex);
            return lower;
        }
        for (int i = 0; i < 15 && lower < upper; ++i) {
            try {
                byte[] buf = new byte[upper];
                DatagramPacket packet = new DatagramPacket(buf, buf.length, local_addr, 9);
                sock.send(packet);
                lower = Math.max(lower, upper);
                System.out.println("-- trying " + lower + " [OK]");
                upper *= 2;
                if (highest_failed <= -1) continue;
                upper = Math.min(highest_failed, upper);
                continue;
            }
            catch (IOException io_ex) {
                highest_failed = highest_failed > -1 ? Math.min(highest_failed, upper) : upper;
                upper = (upper + lower) / 2;
                continue;
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                break;
            }
        }
        return lower;
    }

    public static void main(String[] args) {
        int size = 0;
        int frag_size = 0;
        try {
            size = DetermineFragSize.senseMaxFragSize();
            System.out.println("-- fine tuning (starting at " + size + "):");
            DatagramSocket sock = new DatagramSocket();
            while (true) {
                byte[] buf = new byte[size];
                DatagramPacket packet = new DatagramPacket(buf, buf.length, InetAddress.getLocalHost(), 9);
                sock.send(packet);
                frag_size = size++;
            }
        }
        catch (Throwable t) {
            System.out.println("\n***** fragmentation size on your system is " + frag_size + " bytes *******\n");
            return;
        }
    }
}

