/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.common.webui;

import java.util.concurrent.CopyOnWriteArrayList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.commons.utils.SerializablePageList;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.organization.account.UIUserSelector;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/organization/account/UIUserSelector.gtmpl", events={@EventConfig(listeners={UIUserSelector.AddActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIUserSelector.AddUserActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIUserSelector.SearchActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIUserSelector.SearchGroupActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIUserSelector.SelectGroupActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIUserSelector.FindGroupActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIUserSelector.ShowPageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIUserSelector.CloseActionListener.class}, phase=Event.Phase.DECODE)})
public class UIUserSelect
extends UIUserSelector {
    private String permisionType;
    private String spaceGroupId = null;

    public void processRender(WebuiRequestContext context) throws Exception {
        if (this.spaceGroupId != null && this.spaceGroupId.length() > 0 && this.uiIterator_ != null) {
            OrganizationService service = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
            CopyOnWriteArrayList results = new CopyOnWriteArrayList();
            results.addAll(this.uiIterator_.getPageList().getAll());
            MembershipHandler memberShipHandler = service.getMembershipHandler();
            for (User user : results) {
                if (memberShipHandler.findMembershipsByUserAndGroup(user.getUserName(), this.spaceGroupId).size() != 0) continue;
                results.remove(user);
            }
            this.uiIterator_.setPageList((PageList)new SerializablePageList((ListAccess)new ListAccessImpl(User.class, results), 10));
        }
        super.processRender(context);
    }

    public String getSpaceGroupId() {
        return this.spaceGroupId;
    }

    public void setSpaceGroupId(String spaceGroupId) {
        this.spaceGroupId = spaceGroupId;
    }

    public String getPermisionType() {
        return this.permisionType;
    }

    public void setPermisionType(String permisionType) {
        this.permisionType = permisionType;
    }
}

