/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.toc;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.BulletedListBlock;
import org.xwiki.rendering.block.HeaderBlock;
import org.xwiki.rendering.block.LinkBlock;
import org.xwiki.rendering.block.ListBLock;
import org.xwiki.rendering.block.ListItemBlock;
import org.xwiki.rendering.block.NumberedListBlock;
import org.xwiki.rendering.block.SectionBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.internal.macro.toc.TocBlockFilter;
import org.xwiki.rendering.listener.Link;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.toc.TocMacroParameters;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.renderer.LinkLabelGenerator;
import org.xwiki.rendering.transformation.MacroTransformationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="toc")
public class TocMacro
extends AbstractMacro<TocMacroParameters> {
    private static final String DESCRIPTION = "Generates a Table Of Contents.";
    private TocBlockFilter tocBlockFilter;
    @Requirement(value="plain/1.0")
    private Parser plainTextParser;
    @Requirement
    private LinkLabelGenerator linkLabelGenerator;

    public TocMacro() {
        super("Table Of Contents", DESCRIPTION, TocMacroParameters.class);
        this.setPriority(2000);
        this.setDefaultCategory("Navigation");
    }

    public void initialize() throws InitializationException {
        super.initialize();
        this.tocBlockFilter = new TocBlockFilter(this.plainTextParser, this.linkLabelGenerator);
    }

    public boolean supportsInlineMode() {
        return false;
    }

    public List<Block> execute(TocMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        Block tocBlock;
        Block block;
        XDOM root;
        int start = parameters.getStart();
        int depth = parameters.getDepth();
        if (parameters.getScope() == TocMacroParameters.Scope.LOCAL) {
            SectionBlock rootSection;
            HeaderBlock header;
            root = context.getCurrentMacroBlock().getParent();
            if (!parameters.isCustomStart() && (header = (rootSection = (SectionBlock)context.getCurrentMacroBlock().getParentBlockByType(SectionBlock.class)).getHeaderBlock()) != null) {
                start = header.getLevel().getAsInt() + 1;
            }
        } else {
            root = context.getXDOM();
        }
        List headers = root.getChildrenByType(HeaderBlock.class, true);
        if (root instanceof SectionBlock && (block = (Block)root.getChildren().get(0)) instanceof HeaderBlock) {
            headers.remove(block);
        }
        List<Block> result = (tocBlock = this.generateTree(headers, start, depth, parameters.isNumbered())) != null ? Arrays.asList(tocBlock) : Collections.emptyList();
        return result;
    }

    private Block generateTree(List<HeaderBlock> headers, int start, int depth, boolean numbered) {
        Block tocBlock = null;
        int currentLevel = start - 1;
        Block currentBlock = null;
        for (HeaderBlock headerBlock : headers) {
            int headerLevel = headerBlock.getLevel().getAsInt();
            if (headerLevel < start || headerLevel > depth) continue;
            if (currentLevel < headerLevel) {
                while (currentLevel < headerLevel) {
                    if (currentBlock instanceof ListBLock) {
                        currentBlock = this.addItemBlock(currentBlock, null);
                    }
                    currentBlock = this.createChildListBlock(numbered, currentBlock);
                    ++currentLevel;
                }
            } else {
                while (currentLevel > headerLevel) {
                    currentBlock = currentBlock.getParent().getParent();
                    --currentLevel;
                }
                currentBlock = currentBlock.getParent();
            }
            currentBlock = this.addItemBlock(currentBlock, headerBlock);
        }
        if (currentBlock != null) {
            tocBlock = currentBlock.getRoot();
        }
        return tocBlock;
    }

    private Block addItemBlock(Block currentBlock, HeaderBlock headerBlock) {
        ListItemBlock itemBlock = headerBlock == null ? this.createEmptyTocEntry() : this.createTocEntry(headerBlock);
        currentBlock.addChild((Block)itemBlock);
        return itemBlock;
    }

    private ListItemBlock createEmptyTocEntry() {
        return new ListItemBlock(Collections.emptyList());
    }

    private ListItemBlock createTocEntry(HeaderBlock headerBlock) {
        Link link = new Link();
        link.setAnchor(headerBlock.getId());
        LinkBlock linkBlock = new LinkBlock(this.tocBlockFilter.generateLabel(headerBlock), link, false);
        return new ListItemBlock(Collections.singletonList(linkBlock));
    }

    private ListBLock createChildListBlock(boolean numbered, Block parentBlock) {
        NumberedListBlock childListBlock;
        Object object = childListBlock = numbered ? new NumberedListBlock(Collections.emptyList()) : new BulletedListBlock(Collections.emptyList());
        if (parentBlock != null) {
            parentBlock.addChild((Block)childListBlock);
        }
        return childListBlock;
    }
}

