/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.poll.service.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.ks.common.jcr.KSDataLocation;
import org.exoplatform.ks.common.jcr.PropertyReader;
import org.exoplatform.ks.common.jcr.SessionManager;
import org.exoplatform.poll.service.DataStorage;
import org.exoplatform.poll.service.InitialDefaultDataPlugin;
import org.exoplatform.poll.service.Poll;
import org.exoplatform.poll.service.PollData;
import org.exoplatform.poll.service.PollInitialData;
import org.exoplatform.poll.service.PollSummary;
import org.exoplatform.poll.service.impl.PollNodeTypes;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCRDataStorage
implements DataStorage,
PollNodeTypes {
    private static final Log log = ExoLogger.getLogger(JCRDataStorage.class);
    private List<InitialDefaultDataPlugin> defaultDataPlugins = new ArrayList<InitialDefaultDataPlugin>();
    private NodeHierarchyCreator nodeHierarchyCreator_;
    private SessionManager sessionManager;
    KSDataLocation dataLocator;

    public JCRDataStorage(NodeHierarchyCreator nodeHierarchyCreator, KSDataLocation dataLocator) {
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
        this.dataLocator = dataLocator;
        this.sessionManager = dataLocator.getSessionManager();
    }

    void addInitialDefaultDataPlugin(ComponentPlugin plugin) throws Exception {
        if (plugin instanceof InitialDefaultDataPlugin) {
            this.defaultDataPlugins.add((InitialDefaultDataPlugin)plugin);
        }
    }

    public Node getNodeByPath(String nodePath, SessionProvider sessionProvider) throws Exception {
        return (Node)this.getSession(sessionProvider).getItem(nodePath);
    }

    public Session getSession(SessionProvider sprovider) throws Exception {
        return this.sessionManager.getSession(sprovider);
    }

    private Node getPublicPollHomeNode(SessionProvider sProvider) throws Exception {
        Node publicApp = this.getNodeByPath(this.nodeHierarchyCreator_.getPublicApplicationNode(sProvider).getPath(), sProvider);
        try {
            return publicApp.getNode(EXO_POLLS);
        }
        catch (Exception e) {
            Node pollApp = publicApp.addNode(EXO_POLLS, "nt:unstructured");
            publicApp.getSession().save();
            return pollApp;
        }
    }

    private Node getGroupPollHomeNode(SessionProvider sProvider) throws Exception {
        Node privateApp = this.getNodeByPath(this.nodeHierarchyCreator_.getJcrPath("groupsPath"), sProvider);
        return privateApp;
    }

    private Node getParentNode(SessionProvider sProvider, String parentId) throws Exception {
        Node appNode = null;
        try {
            appNode = this.getNodeByPath(parentId, sProvider);
        }
        catch (Exception e) {
            if (e instanceof PathNotFoundException || e instanceof RepositoryException) {
                if (parentId.indexOf(APPLICATION_DATA) > 0) {
                    return this.getNode(this.getGroupPollHomeNode(sProvider), parentId);
                }
                if (parentId.indexOf(POLLS) > 0) {
                    return this.getNode(this.getPublicPollHomeNode(sProvider), parentId);
                }
            }
            log.error((Object)("Failed to get parent node of poll: " + parentId), (Throwable)e);
        }
        return appNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDefaultData() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            for (InitialDefaultDataPlugin pln : this.defaultDataPlugins) {
                PollInitialData initialData = pln.getPollInitialData();
                List<PollData> datas = initialData.getPollDatas();
                if (datas.size() <= 0) continue;
                String parentPath = datas.get(0).getParentPath();
                Node parentNode = this.getParentNode(sProvider, parentPath);
                if (parentNode.hasNode(PollData.DEFAULT_ID)) {
                    return;
                }
                boolean first = true;
                for (PollData pollData : datas) {
                    Poll poll = new Poll();
                    if (first) {
                        poll.setId(PollData.DEFAULT_ID);
                    }
                    first = false;
                    int size = pollData.getOptions().size();
                    String[] vote = new String[size];
                    for (int j = 0; j < size; ++j) {
                        vote[j] = "0.0";
                    }
                    poll.setParentPath(pollData.getParentPath());
                    poll.setQuestion(pollData.getQuestion());
                    poll.setOption(pollData.getOptions().toArray(new String[size]));
                    poll.setVote(vote);
                    poll.setOwner(pollData.getOwner());
                    poll.setModifiedBy(pollData.getOwner());
                    poll.setCreatedDate(new Date());
                    poll.setModifiedDate(new Date());
                    poll.setUserVote(new String[0]);
                    poll.setTimeOut(Long.parseLong(pollData.getTimeOut()));
                    poll.setIsAgainVote(Boolean.parseBoolean(pollData.getIsAgainVote()));
                    poll.setIsMultiCheck(Boolean.parseBoolean(pollData.getIsMultiCheck()));
                    poll.setIsClosed(Boolean.parseBoolean(pollData.getIsClosed()));
                    this.savePoll(poll, true, false);
                }
            }
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Poll getPoll(String pollId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            String parentId = "";
            if (pollId.lastIndexOf("/") > 0) {
                parentId = pollId.substring(0, pollId.lastIndexOf("/") + 1);
                pollId = pollId.substring(pollId.lastIndexOf("/") + 1);
            }
            Node appNode = this.getParentNode(sProvider, parentId);
            Node pollNode = appNode.getNode(pollId);
            Poll poll = this.getPollNode(pollNode);
            return poll;
        }
        catch (Exception e) {
            Poll poll = this.getPollNode(this.getNodeById(sProvider, pollId));
            return poll;
        }
        finally {
            sProvider.close();
        }
    }

    private Node getNodeById(SessionProvider sProvider, String pollId) throws Exception {
        QueryManager qm = this.getSession(sProvider).getWorkspace().getQueryManager();
        StringBuffer queryString = new StringBuffer("/jcr:root");
        queryString.append("//element(*,").append("exo:poll").append(")").append("[fn:name() = '").append(pollId).append("']");
        Query query = qm.createQuery(queryString.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        if (iter.getSize() > 0L) {
            return iter.nextNode();
        }
        return null;
    }

    private Poll getPollNode(Node pollNode) throws Exception {
        if (pollNode == null) {
            return null;
        }
        Poll pollNew = new Poll();
        pollNew.setId(pollNode.getName());
        pollNew.setParentPath(pollNode.getParent().getPath());
        PropertyReader reader = new PropertyReader(pollNode);
        pollNew.setOwner(reader.string("exo:owner"));
        pollNew.setModifiedBy(reader.string("exo:modifiedBy"));
        pollNew.setCreatedDate(reader.date("exo:createdDate"));
        pollNew.setModifiedDate(reader.date("exo:modifiedDate"));
        pollNew.setLastVote(reader.date("exo:lastVote"));
        pollNew.setTimeOut(reader.l("exo:timeOut", 0L));
        pollNew.setQuestion(reader.string("exo:question"));
        pollNew.setOption(reader.strings("exo:option", new String[0]));
        pollNew.setVote(reader.strings("exo:vote", new String[0]));
        pollNew.setUserVote(reader.strings("exo:userVote", new String[0]));
        pollNew.setIsMultiCheck(reader.bool("exo:isMultiCheck"));
        pollNew.setIsAgainVote(reader.bool("exo:isAgainVote", false));
        pollNew.setIsClosed(reader.bool("exo:isClosed", false));
        return pollNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Poll> getPagePoll() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ArrayList<Poll> listPoll = new ArrayList<Poll>();
        try {
            NodeIterator iter = this.getIterNodePoll(sProvider);
            while (iter.hasNext()) {
                Node node = iter.nextNode();
                listPoll.add(this.getPollNode(node));
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to get page poll", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return listPoll;
    }

    private NodeIterator getIterNodePoll(SessionProvider sProvider) throws Exception {
        QueryManager qm = this.getSession(sProvider).getWorkspace().getQueryManager();
        StringBuffer queryString = new StringBuffer("/jcr:root");
        queryString.append("//element(*,").append("exo:poll").append(")").append(" order by @").append("exo:createdDate").append(" descending");
        Query query = qm.createQuery(queryString.toString(), "xpath");
        QueryResult result = query.execute();
        return result.getNodes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PollSummary getPollSummary(List<String> groupOfUser) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        PollSummary poll = new PollSummary();
        try {
            NodeIterator iter = this.getIterNodePoll(sProvider);
            ArrayList<String> pollId = new ArrayList<String>();
            ArrayList<String> pollName = new ArrayList<String>();
            ArrayList<String> groupPrivate = new ArrayList<String>();
            boolean isAdd = false;
            while (iter.hasNext()) {
                Node node = iter.nextNode();
                String path = node.getPath();
                if (path.indexOf(APPLICATION_DATA) > 0 && groupOfUser != null) {
                    isAdd = false;
                    for (String group : groupOfUser) {
                        if (group.indexOf(path.substring(path.indexOf(GROUPS + "/") + GROUPS.length(), path.indexOf("/" + APPLICATION_DATA))) != 0) continue;
                        isAdd = true;
                        break;
                    }
                    if (!isAdd) continue;
                }
                pollId.add(node.getName());
                pollName.add(node.getProperty("exo:question").getString());
                groupPrivate.add(path);
            }
            poll.setPollId(pollId);
            poll.setPollName(pollName);
            poll.setGroupPrivate(groupPrivate);
        }
        catch (Exception e) {
            log.error((Object)"Failed to get poll summary", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return poll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Poll removePoll(String pollId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Poll poll = null;
        try {
            Node pollNode = null;
            pollNode = pollId.lastIndexOf("/") > 0 ? this.getNodeByPath(pollId, sProvider) : this.getNodeById(sProvider, pollId);
            poll = this.getPollNode(pollNode);
            Node parentNode = pollNode.getParent();
            pollNode.remove();
            if (parentNode.hasProperty("exo:isPoll")) {
                parentNode.setProperty("exo:isPoll", false);
            }
            if (parentNode.isNew()) {
                parentNode.getSession().save();
            } else {
                parentNode.save();
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to remove poll: " + pollId), (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return poll;
    }

    private Node getNode(Node nodeApp, String ids) throws Exception {
        Node node = null;
        if (ids.indexOf("/") < 0) {
            node = nodeApp.addNode(ids);
        } else {
            String[] ar = ids.split("/");
            for (int i = 0; i < ar.length; ++i) {
                try {
                    node = nodeApp.getNode(ar[i]);
                }
                catch (PathNotFoundException e) {
                    node = nodeApp.addNode(ar[i], "nt:unstructured");
                }
                nodeApp = node;
            }
            if (nodeApp.isNew()) {
                nodeApp.getSession().save();
            } else {
                nodeApp.getParent().save();
            }
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void savePoll(Poll poll, boolean isNew, boolean isVote) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            String pollId = poll.getId();
            Node parentNode = this.getParentNode(sProvider, poll.getParentPath() != null ? poll.getParentPath() : pollId);
            if (isVote) {
                Node pollNode = parentNode.getNode(pollId);
                pollNode.setProperty("exo:vote", poll.getVote());
                pollNode.setProperty("exo:userVote", poll.getUserVote());
                try {
                    pollNode.setProperty("exo:lastVote", JCRDataStorage.getGreenwichMeanTime());
                }
                catch (RepositoryException e) {}
            } else {
                Node pollNode;
                if (isNew) {
                    if (parentNode.hasNode(pollId)) {
                        return;
                    }
                    pollNode = parentNode.addNode(pollId, "exo:poll");
                    pollNode.setProperty("exo:id", pollId);
                    pollNode.setProperty("exo:owner", poll.getOwner());
                    pollNode.setProperty("exo:userVote", new String[0]);
                    pollNode.setProperty("exo:createdDate", JCRDataStorage.getGreenwichMeanTime());
                    pollNode.setProperty("exo:modifiedDate", JCRDataStorage.getGreenwichMeanTime());
                    if (parentNode.hasProperty("exo:isPoll")) {
                        parentNode.setProperty("exo:isPoll", true);
                    }
                } else {
                    if (!JCRDataStorage.isEmpty(poll.getOldParentPath()) && !parentNode.getPath().equals(poll.getOldParentPath())) {
                        Session session = this.getSession(sProvider);
                        session.move(poll.getOldParentPath() + "/" + pollId, parentNode.getPath() + "/" + pollId);
                        session.save();
                        pollNode = parentNode.getNode(pollId);
                    }
                    pollNode = parentNode.getNode(pollId);
                }
                if (poll.getUserVote() != null) {
                    pollNode.setProperty("exo:userVote", poll.getUserVote());
                }
                pollNode.setProperty("exo:vote", poll.getVote());
                pollNode.setProperty("exo:modifiedBy", poll.getModifiedBy());
                if (!isNew && pollNode.getProperty("exo:timeOut").getLong() != poll.getTimeOut()) {
                    pollNode.setProperty("exo:modifiedDate", JCRDataStorage.getGreenwichMeanTime());
                }
                pollNode.setProperty("exo:timeOut", poll.getTimeOut());
                pollNode.setProperty("exo:question", poll.getQuestion());
                pollNode.setProperty("exo:option", poll.getOption());
                pollNode.setProperty("exo:isMultiCheck", poll.getIsMultiCheck());
                pollNode.setProperty("exo:isClosed", poll.getIsClosed());
                pollNode.setProperty("exo:isAgainVote", poll.getIsAgainVote());
            }
            if (parentNode.isNew()) {
                parentNode.getSession().save();
            } else {
                parentNode.save();
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to save poll: " + poll.getId()), (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClosedPoll(Poll poll) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node appNode = this.getParentNode(sProvider, poll.getParentPath());
            Node pollNode = appNode.getNode(poll.getId());
            pollNode.setProperty("exo:isClosed", poll.getIsClosed());
            if (poll.getTimeOut() == 0L) {
                pollNode.setProperty("exo:modifiedDate", JCRDataStorage.getGreenwichMeanTime());
                pollNode.setProperty("exo:timeOut", 0L);
            }
            appNode.save();
        }
        catch (Exception e) {
            log.error((Object)("Failed to close poll: " + poll.getId()), (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    public static Calendar getGreenwichMeanTime() {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setLenient(false);
        int gmtoffset = calendar.get(16) + calendar.get(15);
        calendar.setTimeInMillis(System.currentTimeMillis() - (long)gmtoffset);
        return calendar;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() <= 0;
    }

    public String[] valuesToArray(Value[] Val) throws Exception {
        if (Val.length < 1) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < Val.length; ++i) {
            String s = Val[i].getString();
            if (JCRDataStorage.isEmpty(s)) continue;
            list.add(s);
        }
        return list.toArray(new String[list.size()]);
    }

    public List<String> valuesToList(Value[] values) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        if (values.length < 1) {
            return list;
        }
        for (int i = 0; i < values.length; ++i) {
            String s = values[i].getString();
            if (JCRDataStorage.isEmpty(s)) continue;
            list.add(s);
        }
        return list;
    }
}

