/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ftp.client;

import java.net.Socket;
import java.net.SocketException;
import org.apache.commons.chain.Context;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.ftp.FtpContext;
import org.exoplatform.services.ftp.client.FtpClientSession;
import org.exoplatform.services.ftp.command.FtpCommand;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class FtpClientCommandThread
extends Thread {
    private static Log log = ExoLogger.getLogger("exo.jcr.component.ftp.FtpClientCommandThread");
    protected FtpClientSession clientSession;

    public FtpClientCommandThread(FtpClientSession clientSession) {
        this.clientSession = clientSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        PortalContainer container = this.clientSession.getFtpServer().getConfiguration().getPortalContainer();
        if (container == null) {
            if (log.isDebugEnabled()) {
                log.debug("No Portal Container found.");
            }
            container = ExoContainerContext.getTopContainer();
        }
        try {
            ExoContainerContext.setCurrentContainer((ExoContainer)container);
            try {
                String command;
                while ((command = this.readLine()) != null) {
                    if ("".equals(command)) continue;
                    String logStr = "";
                    String[] comms = command.split(" ");
                    FtpCommand curCommand = this.clientSession.getFtpServer().getCommand(comms[0].toUpperCase());
                    logStr = comms[0].toUpperCase();
                    if (curCommand != null) {
                        if (comms.length > 1) {
                            for (int i = 2; i < comms.length; ++i) {
                                comms[1] = "".equals(comms[i]) ? comms[1] + " " : comms[1] + " " + comms[i];
                            }
                            logStr = logStr + " " + comms[1];
                        }
                        FtpContext ftpContext = new FtpContext(this.clientSession, comms);
                        curCommand.execute((Context)ftpContext);
                        continue;
                    }
                    this.clientSession.reply(String.format("500 %s not understood", comms[0].toUpperCase()));
                    this.clientSession.setPrevCommand(null);
                }
            }
            catch (SocketException exc) {
            }
            catch (Exception exc) {
                log.info("Unhandled exception. " + exc.getMessage(), exc);
            }
            try {
                this.clientSession.logout();
            }
            catch (Exception exc) {
                log.info("Unhandled exception. " + exc.getMessage(), exc);
            }
        }
        finally {
            ExoContainerContext.setCurrentContainer(null);
        }
    }

    protected String readLine() throws Exception {
        int[] buffer = new int[4096];
        int bufPos = 0;
        int prevByte = 0;
        Socket clientSocket = this.clientSession.getClientSocket();
        int received;
        while ((received = clientSocket.getInputStream().read()) >= 0) {
            this.clientSession.refreshTimeOut();
            buffer[bufPos] = (byte)received;
            ++bufPos;
            if (prevByte == 13 && received == 10) {
                byte[] commandLine = new byte[bufPos - 2];
                for (int i = 0; i < bufPos - 2; ++i) {
                    commandLine[i] = (byte)buffer[i];
                }
                try {
                    String encoding = this.clientSession.getFtpServer().getConfiguration().getClientSideEncoding();
                    String readyCommand = new String(commandLine, encoding);
                    if (log.isDebugEnabled()) {
                        log.debug("FTP_CMD:[" + readyCommand + "]");
                    }
                    return readyCommand;
                }
                catch (Exception exc) {
                    log.info("Unahdled exception. " + exc.getMessage());
                    exc.printStackTrace();
                }
            }
            prevByte = (byte)received;
        }
        return null;
    }
}

