/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyBuiltinCallable$PyExposer;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.core.PyType;
import org.python.expose.ExposedType;

@ExposedType(name="builtin_function_or_method", isBaseType=false)
public abstract class PyBuiltinCallable
extends PyObject {
    protected Info info;
    protected String doc;

    protected PyBuiltinCallable(PyType type, Info info) {
        super(type);
        this.info = info;
    }

    protected PyBuiltinCallable(Info info) {
        this.info = info;
    }

    public abstract PyBuiltinCallable bind(PyObject var1);

    public PyObject fastGetName() {
        return Py.newString(this.info.getName());
    }

    public String getDoc() {
        return this.doc;
    }

    public PyObject getModule() {
        return Py.None;
    }

    public PyObject makeCall() {
        return this;
    }

    public PyObject getSelf() {
        return Py.None;
    }

    public void setInfo(Info info) {
        this.info = info;
    }

    public String toString() {
        PyObject self = this.getSelf();
        if (self == null) {
            return String.format("<built-in function %s>", this.info.getName());
        }
        return String.format("<built-in method %s of %s object at %s>", this.info.getName(), self.getType().fastGetName(), Py.idstr(self));
    }

    static {
        PyType.addBuilder(PyBuiltinCallable.class, new PyBuiltinCallable$PyExposer());
    }

    public static class DefaultInfo
    implements Info {
        private String name;
        private int maxargs;
        private int minargs;

        public DefaultInfo(String name, int minargs, int maxargs) {
            this.name = name;
            this.minargs = minargs;
            this.maxargs = maxargs;
        }

        public DefaultInfo(String name) {
            this(name, -1, -1);
        }

        public String getName() {
            return this.name;
        }

        public int getMaxargs() {
            return this.maxargs;
        }

        public int getMinargs() {
            return this.minargs;
        }

        public static boolean check(int nargs, int minargs, int maxargs) {
            if (nargs < minargs) {
                return false;
            }
            return maxargs == -1 || nargs <= maxargs;
        }

        public static PyException unexpectedCall(int nargs, boolean keywords, String name, int minargs, int maxargs) {
            String argsblurb;
            if (keywords) {
                return Py.TypeError(name + "() takes no keyword arguments");
            }
            if (minargs == maxargs) {
                argsblurb = minargs == 0 ? "no arguments" : (minargs == 1 ? "exactly one argument" : minargs + " arguments");
            } else {
                if (maxargs == -1) {
                    return Py.TypeError(String.format("%s() requires at least %d arguments (%d) given", name, minargs, nargs));
                }
                argsblurb = minargs <= 0 ? "at most " + maxargs + " arguments" : minargs + "-" + maxargs + " arguments";
            }
            return Py.TypeError(String.format("%s() takes %s (%d given)", name, argsblurb, nargs));
        }

        public PyException unexpectedCall(int nargs, boolean keywords) {
            return DefaultInfo.unexpectedCall(nargs, keywords, this.name, this.minargs, this.maxargs);
        }
    }

    public static interface Info {
        public String getName();

        public int getMaxargs();

        public int getMinargs();

        public PyException unexpectedCall(int var1, boolean var2);
    }
}

