/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.block;

import java.io.StringReader;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.BlockFilter;
import org.xwiki.rendering.block.LinkBlock;
import org.xwiki.rendering.block.NewLineBlock;
import org.xwiki.rendering.block.SpaceBlock;
import org.xwiki.rendering.block.SpecialSymbolBlock;
import org.xwiki.rendering.block.WordBlock;
import org.xwiki.rendering.listener.Link;
import org.xwiki.rendering.listener.LinkType;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.renderer.LinkLabelGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlainTextBlockFilter
implements BlockFilter {
    private static final Set<Class<? extends Block>> VALID_PLAINTEXT_BLOCKS = new HashSet<Class<? extends Block>>(){
        {
            this.add(WordBlock.class);
            this.add(SpaceBlock.class);
            this.add(SpecialSymbolBlock.class);
            this.add(NewLineBlock.class);
        }
    };
    private Parser plainTextParser;
    private LinkLabelGenerator linkLabelGenerator;

    public PlainTextBlockFilter(Parser plainTextParser, LinkLabelGenerator linkLabelGenerator) {
        this.plainTextParser = plainTextParser;
        this.linkLabelGenerator = linkLabelGenerator;
    }

    @Override
    public List<Block> filter(Block block) {
        if (VALID_PLAINTEXT_BLOCKS.contains(block.getClass())) {
            return Collections.singletonList(block);
        }
        if (block.getClass() == LinkBlock.class && block.getChildren().size() == 0) {
            Link link = ((LinkBlock)block).getLink();
            try {
                String label = link.getType() == LinkType.DOCUMENT ? this.linkLabelGenerator.generate(link) : link.getReference();
                return this.plainTextParser.parse(new StringReader(label)).getChildren().get(0).getChildren();
            }
            catch (ParseException e) {
                throw new RuntimeException("Failed to parse link label as plain text", e);
            }
        }
        return Collections.emptyList();
    }
}

