/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.component.logging.AbstractLogEnabled;
import org.xwiki.rendering.configuration.RenderingConfiguration;
import org.xwiki.rendering.macro.MacroCategoryManager;
import org.xwiki.rendering.macro.MacroId;
import org.xwiki.rendering.macro.MacroLookupException;
import org.xwiki.rendering.macro.MacroManager;
import org.xwiki.rendering.syntax.Syntax;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class DefaultMacroCategoryManager
extends AbstractLogEnabled
implements MacroCategoryManager {
    @Requirement
    private RenderingConfiguration configuration;
    @Requirement
    private MacroManager macroManager;

    @Override
    public Set<String> getMacroCategories() throws MacroLookupException {
        return this.getMacroCategories(null);
    }

    @Override
    public Set<String> getMacroCategories(final Syntax syntax) throws MacroLookupException {
        Set<String> categories = this.getMacroIdsByCategory(new MacroMatcher(){

            public boolean match(MacroId macroId) {
                return syntax == null || macroId.getSyntax() == null || macroId.getSyntax() == syntax;
            }
        }).keySet();
        return Collections.unmodifiableSet(categories);
    }

    @Override
    public Set<MacroId> getMacroIds(String category) throws MacroLookupException {
        return this.getMacroIds(category, null);
    }

    @Override
    public Set<MacroId> getMacroIds(String category, final Syntax syntax) throws MacroLookupException {
        Set<MacroId> macros = this.getMacroIdsByCategory(new MacroMatcher(){

            public boolean match(MacroId macroId) {
                return syntax == null || macroId.getSyntax() == null || macroId.getSyntax().equals(syntax);
            }
        }).get(category);
        return null != macros ? Collections.unmodifiableSet(macros) : Collections.emptySet();
    }

    private Map<String, Set<MacroId>> getMacroIdsByCategory(MacroMatcher matcher) throws MacroLookupException {
        HashMap<String, Set<MacroId>> result = new HashMap<String, Set<MacroId>>();
        Set<MacroId> macroIds = this.macroManager.getMacroIds();
        Properties categories = this.configuration.getMacroCategories();
        for (MacroId macroId : macroIds) {
            HashSet<MacroId> ids;
            if (!matcher.match(macroId)) continue;
            String category = categories.getProperty(macroId.toString());
            if (category == null) {
                category = this.macroManager.getMacro(macroId).getDescriptor().getDefaultCategory();
            }
            if ((ids = (HashSet<MacroId>)result.get(category)) == null) {
                ids = new HashSet<MacroId>();
            }
            ids.add(macroId);
            result.put(category, ids);
        }
        return result;
    }

    private static interface MacroMatcher {
        public boolean match(MacroId var1);
    }
}

