/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.xhtml;

import java.util.Map;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.rendering.internal.renderer.DefaultLinkReferenceSerializer;
import org.xwiki.rendering.listener.Link;
import org.xwiki.rendering.renderer.printer.XHTMLWikiPrinter;
import org.xwiki.rendering.renderer.xhtml.XHTMLLinkRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="annotated")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class AnnotatedXHTMLLinkRenderer
implements XHTMLLinkRenderer {
    @Requirement
    private XHTMLLinkRenderer defaultLinkRenderer;
    private DefaultLinkReferenceSerializer linkReferenceSerializer = new DefaultLinkReferenceSerializer();

    @Override
    public void setXHTMLWikiPrinter(XHTMLWikiPrinter printer) {
        this.defaultLinkRenderer.setXHTMLWikiPrinter(printer);
    }

    @Override
    public void setHasLabel(boolean hasLabel) {
        this.defaultLinkRenderer.setHasLabel(hasLabel);
    }

    @Override
    public void beginLink(Link link, boolean isFreeStandingURI, Map<String, String> parameters) {
        this.getXHTMLWikiPrinter().printXMLComment("startwikilink:" + this.linkReferenceSerializer.serialize(link), true);
        this.defaultLinkRenderer.beginLink(link, isFreeStandingURI, parameters);
    }

    @Override
    public void endLink(Link link, boolean isFreeStandingURI, Map<String, String> parameters) {
        this.defaultLinkRenderer.endLink(link, isFreeStandingURI, parameters);
        this.getXHTMLWikiPrinter().printXMLComment("stopwikilink");
    }

    @Override
    public XHTMLWikiPrinter getXHTMLWikiPrinter() {
        return this.defaultLinkRenderer.getXHTMLWikiPrinter();
    }
}

