/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.xhtml;

import java.util.LinkedHashMap;
import java.util.Map;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.listener.DocumentImage;
import org.xwiki.rendering.listener.Image;
import org.xwiki.rendering.listener.ImageType;
import org.xwiki.rendering.listener.URLImage;
import org.xwiki.rendering.renderer.printer.XHTMLWikiPrinter;
import org.xwiki.rendering.renderer.xhtml.XHTMLImageRenderer;
import org.xwiki.rendering.wiki.WikiModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DefaultXHTMLImageRenderer
implements XHTMLImageRenderer,
Initializable {
    private XHTMLWikiPrinter xhtmlPrinter;
    private WikiModel wikiModel;
    @Requirement
    private ComponentManager componentManager;

    public void initialize() throws InitializationException {
        try {
            this.wikiModel = (WikiModel)this.componentManager.lookup(WikiModel.class);
        }
        catch (ComponentLookupException componentLookupException) {
            // empty catch block
        }
    }

    @Override
    public void setXHTMLWikiPrinter(XHTMLWikiPrinter printer) {
        this.xhtmlPrinter = printer;
    }

    @Override
    public XHTMLWikiPrinter getXHTMLWikiPrinter() {
        return this.xhtmlPrinter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onImage(Image image, boolean isFreeStandingURI, Map<String, String> parameters) {
        String imageURL;
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        if (image.getType() == ImageType.DOCUMENT) {
            if (this.wikiModel == null) throw new RuntimeException("Invalid Image type. In non wiki mode, all image types must be URL images.");
            DocumentImage documentImage = (DocumentImage)DocumentImage.class.cast(image);
            imageURL = this.wikiModel.getAttachmentURL(documentImage.getDocumentName(), documentImage.getAttachmentName());
        } else {
            URLImage urlImage = (URLImage)URLImage.class.cast(image);
            imageURL = urlImage.getURL();
        }
        attributes.put("src", imageURL);
        if (isFreeStandingURI) {
            attributes.put("class", "wikimodel-freestanding");
        }
        attributes.putAll(parameters);
        if (!parameters.containsKey("alt")) {
            attributes.put("alt", image.getName());
        }
        this.getXHTMLWikiPrinter().printXMLElement("img", attributes);
    }
}

