/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.xwiki;

import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import org.xwiki.rendering.internal.parser.PlainTextStreamParser;
import org.xwiki.rendering.internal.renderer.ParametersPrinter;
import org.xwiki.rendering.internal.renderer.printer.XWikiSyntaxEscapeWikiPrinter;
import org.xwiki.rendering.listener.Link;
import org.xwiki.rendering.listener.QueueListener;
import org.xwiki.rendering.listener.chaining.EventType;
import org.xwiki.rendering.renderer.LinkReferenceSerializer;
import org.xwiki.rendering.renderer.XWikiSyntaxListenerChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWikiSyntaxLinkRenderer {
    private ParametersPrinter parametersPrinter = new ParametersPrinter();
    private Stack<Boolean> forceFullSyntax = new Stack();
    private XWikiSyntaxListenerChain listenerChain;
    private LinkReferenceSerializer linkReferenceSerializer;

    public XWikiSyntaxLinkRenderer(XWikiSyntaxListenerChain listenerChain, LinkReferenceSerializer linkReferenceSerializer) {
        this.listenerChain = listenerChain;
        this.linkReferenceSerializer = linkReferenceSerializer;
        this.forceFullSyntax.push(false);
    }

    public String serialize(Link link, boolean isFreeStanding) {
        String result = this.linkReferenceSerializer.serialize(link);
        if (!isFreeStanding) {
            result = result.replace("~", "~~").replace(">>", "~>~>").replace("||", "~|~|");
        }
        return result;
    }

    public void beginRenderLink(XWikiSyntaxEscapeWikiPrinter printer, Link link, boolean isFreeStandingURI, Map<String, String> parameters) {
        boolean isLastSyntax = printer.getBuffer().length() == 0;
        printer.flush();
        if (this.forceFullSyntax(printer, isLastSyntax, isFreeStandingURI, parameters)) {
            this.forceFullSyntax.push(true);
            printer.print("[[");
        } else {
            this.forceFullSyntax.push(false);
        }
    }

    public boolean forceFullSyntax(XWikiSyntaxEscapeWikiPrinter printer, boolean isFreeStandingURI, Map<String, String> parameters) {
        return this.forceFullSyntax(printer, true, isFreeStandingURI, parameters);
    }

    public boolean forceFullSyntax(XWikiSyntaxEscapeWikiPrinter printer, boolean isLastSyntax, boolean isFreeStandingURI, Map<String, String> parameters) {
        QueueListener.Event nextEvent = this.listenerChain.getLookaheadChainingListener().getNextEvent();
        return !isFreeStandingURI || !parameters.isEmpty() || !isLastSyntax && !printer.isAfterWhiteSpace() && !PlainTextStreamParser.SPECIALSYMBOL_PATTERN.matcher(String.valueOf(printer.getLastPrinted().charAt(printer.getLastPrinted().length() - 1))).matches() || nextEvent != null && nextEvent.eventType != EventType.ON_SPACE && nextEvent.eventType != EventType.ON_NEW_LINE && nextEvent.eventType != EventType.END_PARAGRAPH && nextEvent.eventType != EventType.END_LINK && nextEvent.eventType != EventType.END_LIST_ITEM && nextEvent.eventType != EventType.END_DEFINITION_DESCRIPTION && nextEvent.eventType != EventType.END_DEFINITION_TERM && nextEvent.eventType != EventType.END_QUOTATION_LINE && nextEvent.eventType != EventType.END_SECTION;
    }

    public void renderLinkContent(XWikiSyntaxEscapeWikiPrinter printer, String label) {
        if (!StringUtils.isEmpty((String)label)) {
            printer.print(label);
            printer.print(">>");
        }
    }

    public void endRenderLink(XWikiSyntaxEscapeWikiPrinter printer, Link link, boolean isFreeStandingURI, Map<String, String> parameters) {
        printer.print(this.serialize(link, isFreeStandingURI));
        if (!parameters.isEmpty()) {
            printer.print("||");
            printer.print(this.parametersPrinter.print(parameters, '~'));
        }
        if (this.forceFullSyntax.peek().booleanValue() || !isFreeStandingURI) {
            printer.print("]]");
        }
        this.forceFullSyntax.pop();
    }
}

