/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.listener;

import java.util.LinkedList;
import java.util.Map;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.listener.HeaderLevel;
import org.xwiki.rendering.listener.Image;
import org.xwiki.rendering.listener.Link;
import org.xwiki.rendering.listener.ListType;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.listener.chaining.EventType;
import org.xwiki.rendering.syntax.Syntax;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueListener
extends LinkedList<Event>
implements Listener {
    private static final long serialVersionUID = 2869508092440006345L;

    public Event getEvent(int depth) {
        Event event = null;
        if (depth > 0 && this.size() > depth - 1) {
            event = (Event)this.get(depth - 1);
        }
        return event;
    }

    public void consumeEvents(Listener listener) {
        while (!this.isEmpty()) {
            Event event = (Event)this.remove();
            event.eventType.fireEvent(listener, event.eventParameters);
        }
    }

    private void saveEvent(EventType eventType, Object ... objects) {
        this.offer(new Event(eventType, objects));
    }

    @Override
    public void beginDefinitionDescription() {
        this.saveEvent(EventType.BEGIN_DEFINITION_DESCRIPTION, new Object[0]);
    }

    @Override
    public void beginDefinitionList(Map<String, String> parameters) {
        this.saveEvent(EventType.BEGIN_DEFINITION_LIST, parameters);
    }

    @Override
    public void beginDefinitionTerm() {
        this.saveEvent(EventType.BEGIN_DEFINITION_TERM, new Object[0]);
    }

    @Override
    public void beginDocument(Map<String, String> parameters) {
        this.saveEvent(EventType.BEGIN_DOCUMENT, parameters);
    }

    @Override
    public void beginGroup(Map<String, String> parameters) {
        this.saveEvent(EventType.BEGIN_GROUP, parameters);
    }

    @Override
    public void beginFormat(Format format, Map<String, String> parameters) {
        this.saveEvent(EventType.BEGIN_FORMAT, new Object[]{format, parameters});
    }

    @Override
    public void beginHeader(HeaderLevel level, String id, Map<String, String> parameters) {
        this.saveEvent(EventType.BEGIN_HEADER, new Object[]{level, id, parameters});
    }

    @Override
    public void beginLink(Link link, boolean isFreeStandingURI, Map<String, String> parameters) {
        this.saveEvent(EventType.BEGIN_LINK, link, isFreeStandingURI, parameters);
    }

    @Override
    public void beginList(ListType listType, Map<String, String> parameters) {
        this.saveEvent(EventType.BEGIN_LIST, new Object[]{listType, parameters});
    }

    @Override
    public void beginListItem() {
        this.saveEvent(EventType.BEGIN_LIST_ITEM, new Object[0]);
    }

    @Override
    public void beginMacroMarker(String name, Map<String, String> parameters, String content, boolean isInline) {
        this.saveEvent(EventType.BEGIN_MACRO_MARKER, name, parameters, content, isInline);
    }

    @Override
    public void beginParagraph(Map<String, String> parameters) {
        this.saveEvent(EventType.BEGIN_PARAGRAPH, parameters);
    }

    @Override
    public void beginQuotation(Map<String, String> parameters) {
        this.saveEvent(EventType.BEGIN_QUOTATION, parameters);
    }

    @Override
    public void beginQuotationLine() {
        this.saveEvent(EventType.BEGIN_QUOTATION_LINE, new Object[0]);
    }

    @Override
    public void beginSection(Map<String, String> parameters) {
        this.saveEvent(EventType.BEGIN_SECTION, parameters);
    }

    @Override
    public void beginTable(Map<String, String> parameters) {
        this.saveEvent(EventType.BEGIN_TABLE, parameters);
    }

    @Override
    public void beginTableCell(Map<String, String> parameters) {
        this.saveEvent(EventType.BEGIN_TABLE_CELL, parameters);
    }

    @Override
    public void beginTableHeadCell(Map<String, String> parameters) {
        this.saveEvent(EventType.BEGIN_TABLE_HEAD_CELL, parameters);
    }

    @Override
    public void beginTableRow(Map<String, String> parameters) {
        this.saveEvent(EventType.BEGIN_TABLE_ROW, parameters);
    }

    @Override
    public void endDefinitionDescription() {
        this.saveEvent(EventType.END_DEFINITION_DESCRIPTION, new Object[0]);
    }

    @Override
    public void endDefinitionList(Map<String, String> parameters) {
        this.saveEvent(EventType.END_DEFINITION_LIST, parameters);
    }

    @Override
    public void endDefinitionTerm() {
        this.saveEvent(EventType.END_DEFINITION_TERM, new Object[0]);
    }

    @Override
    public void endDocument(Map<String, String> parameters) {
        this.saveEvent(EventType.END_DOCUMENT, parameters);
    }

    @Override
    public void endGroup(Map<String, String> parameters) {
        this.saveEvent(EventType.END_GROUP, parameters);
    }

    @Override
    public void endFormat(Format format, Map<String, String> parameters) {
        this.saveEvent(EventType.END_FORMAT, new Object[]{format, parameters});
    }

    @Override
    public void endHeader(HeaderLevel level, String id, Map<String, String> parameters) {
        this.saveEvent(EventType.END_HEADER, new Object[]{level, id, parameters});
    }

    @Override
    public void endLink(Link link, boolean isFreeStandingURI, Map<String, String> parameters) {
        this.saveEvent(EventType.END_LINK, link, isFreeStandingURI, parameters);
    }

    @Override
    public void endList(ListType listType, Map<String, String> parameters) {
        this.saveEvent(EventType.END_LIST, new Object[]{listType, parameters});
    }

    @Override
    public void endListItem() {
        this.saveEvent(EventType.END_LIST_ITEM, new Object[0]);
    }

    @Override
    public void endMacroMarker(String name, Map<String, String> parameters, String content, boolean isInline) {
        this.saveEvent(EventType.END_MACRO_MARKER, name, parameters, content, isInline);
    }

    @Override
    public void endParagraph(Map<String, String> parameters) {
        this.saveEvent(EventType.END_PARAGRAPH, parameters);
    }

    @Override
    public void endQuotation(Map<String, String> parameters) {
        this.saveEvent(EventType.END_QUOTATION, parameters);
    }

    @Override
    public void endQuotationLine() {
        this.saveEvent(EventType.END_QUOTATION_LINE, new Object[0]);
    }

    @Override
    public void endSection(Map<String, String> parameters) {
        this.saveEvent(EventType.END_SECTION, parameters);
    }

    @Override
    public void endTable(Map<String, String> parameters) {
        this.saveEvent(EventType.END_TABLE, parameters);
    }

    @Override
    public void endTableCell(Map<String, String> parameters) {
        this.saveEvent(EventType.END_TABLE_CELL, parameters);
    }

    @Override
    public void endTableHeadCell(Map<String, String> parameters) {
        this.saveEvent(EventType.END_TABLE_HEAD_CELL, parameters);
    }

    @Override
    public void endTableRow(Map<String, String> parameters) {
        this.saveEvent(EventType.END_TABLE_ROW, parameters);
    }

    @Override
    public void onRawText(String text, Syntax syntax) {
        this.saveEvent(EventType.ON_RAW_TEXT, text, syntax);
    }

    @Override
    public void onEmptyLines(int count) {
        this.saveEvent(EventType.ON_EMPTY_LINES, count);
    }

    @Override
    public void onHorizontalLine(Map<String, String> parameters) {
        this.saveEvent(EventType.ON_HORIZONTAL_LINE, parameters);
    }

    @Override
    public void onId(String name) {
        this.saveEvent(EventType.ON_ID, name);
    }

    @Override
    public void onImage(Image image, boolean isFreeStandingURI, Map<String, String> parameters) {
        this.saveEvent(EventType.ON_IMAGE, image, isFreeStandingURI, parameters);
    }

    @Override
    public void onMacro(String id, Map<String, String> parameters, String content, boolean isInline) {
        this.saveEvent(EventType.ON_MACRO, id, parameters, content, isInline);
    }

    @Override
    public void onNewLine() {
        this.saveEvent(EventType.ON_NEW_LINE, new Object[0]);
    }

    @Override
    public void onSpace() {
        this.saveEvent(EventType.ON_SPACE, new Object[0]);
    }

    @Override
    public void onSpecialSymbol(char symbol) {
        this.saveEvent(EventType.ON_SPECIAL_SYMBOL, Character.valueOf(symbol));
    }

    @Override
    public void onVerbatim(String protectedString, boolean isInline, Map<String, String> parameters) {
        this.saveEvent(EventType.ON_VERBATIM, protectedString, isInline, parameters);
    }

    @Override
    public void onWord(String word) {
        this.saveEvent(EventType.ON_WORD, word);
    }

    public class Event {
        public EventType eventType;
        public Object[] eventParameters;

        public Event(EventType eventType, Object[] eventParameters) {
            this.eventType = eventType;
            this.eventParameters = eventParameters;
        }
    }
}

