/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.htmlcleaner.ContentToken;
import org.htmlcleaner.DoctypeToken;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.TagToken;
import org.htmlcleaner.TagTransformation;
import org.htmlcleaner.Utils;
import org.htmlcleaner.XPather;
import org.htmlcleaner.XPatherException;
import org.htmlcleaner.XmlSerializer;

public class TagNode
extends TagToken {
    private TagNode parent = null;
    private Map attributes = new LinkedHashMap();
    private List children = new ArrayList();
    private DoctypeToken docType = null;
    private List itemsToMove = null;
    private transient HtmlCleaner cleaner = null;
    private transient boolean isFormed = false;

    public TagNode(String string) {
        this(string, null);
    }

    public TagNode(String string, HtmlCleaner htmlCleaner) {
        super(string == null ? null : string.toLowerCase());
        Set set;
        this.cleaner = htmlCleaner;
        if (htmlCleaner != null && (set = htmlCleaner.getPruneTagSet()) != null && string != null && set.contains(string.toLowerCase())) {
            htmlCleaner.addPruneNode(this);
        }
    }

    public String getAttributeByName(String string) {
        return string != null ? (String)this.attributes.get(string.toLowerCase()) : null;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public boolean hasAttribute(String string) {
        return string != null ? this.attributes.containsKey(string.toLowerCase()) : false;
    }

    public void addAttribute(String string, String string2) {
        if (string != null && !"".equals(string.trim())) {
            this.attributes.put(string.toLowerCase(), string2 == null ? "" : string2);
        }
    }

    public void removeAttribute(String string) {
        if (string != null && !"".equals(string.trim())) {
            this.attributes.remove(string.toLowerCase());
        }
    }

    public List getChildren() {
        return this.children;
    }

    void setChildren(List list) {
        this.children = list;
    }

    public List getChildTagList() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.children.size(); ++i) {
            Object e = this.children.get(i);
            if (!(e instanceof TagNode)) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    public TagNode[] getChildTags() {
        List list = this.getChildTagList();
        TagNode[] tagNodeArray = new TagNode[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            tagNodeArray[i] = (TagNode)list.get(i);
        }
        return tagNodeArray;
    }

    public StringBuffer getText() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.children.size(); ++i) {
            Object e = this.children.get(i);
            if (e instanceof ContentToken) {
                stringBuffer.append(((ContentToken)e).getContent());
                continue;
            }
            if (!(e instanceof TagNode)) continue;
            StringBuffer stringBuffer2 = ((TagNode)e).getText();
            stringBuffer.append(stringBuffer2);
        }
        return stringBuffer;
    }

    public TagNode getParent() {
        return this.parent;
    }

    public DoctypeToken getDocType() {
        return this.docType;
    }

    public void setDocType(DoctypeToken doctypeToken) {
        this.docType = doctypeToken;
    }

    public void addChild(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof List) {
            this.addChildren((List)object);
        } else {
            this.children.add(object);
            if (object instanceof TagNode) {
                TagNode tagNode = (TagNode)object;
                tagNode.parent = this;
            }
        }
    }

    public void addChildren(List list) {
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                this.addChild(e);
            }
        }
    }

    private TagNode findElement(ITagNodeCondition iTagNodeCondition, boolean bl) {
        if (iTagNodeCondition == null) {
            return null;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            TagNode tagNode;
            Object e = this.children.get(i);
            if (!(e instanceof TagNode)) continue;
            TagNode tagNode2 = (TagNode)e;
            if (iTagNodeCondition.satisfy(tagNode2)) {
                return tagNode2;
            }
            if (!bl || (tagNode = tagNode2.findElement(iTagNodeCondition, bl)) == null) continue;
            return tagNode;
        }
        return null;
    }

    private List getElementList(ITagNodeCondition iTagNodeCondition, boolean bl) {
        LinkedList<TagNode> linkedList = new LinkedList<TagNode>();
        if (iTagNodeCondition == null) {
            return linkedList;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            List list;
            Object e = this.children.get(i);
            if (!(e instanceof TagNode)) continue;
            TagNode tagNode = (TagNode)e;
            if (iTagNodeCondition.satisfy(tagNode)) {
                linkedList.add(tagNode);
            }
            if (!bl || (list = tagNode.getElementList(iTagNodeCondition, bl)) == null || list.size() <= 0) continue;
            linkedList.addAll(list);
        }
        return linkedList;
    }

    private TagNode[] getElements(ITagNodeCondition iTagNodeCondition, boolean bl) {
        List list = this.getElementList(iTagNodeCondition, bl);
        TagNode[] tagNodeArray = new TagNode[list == null ? 0 : list.size()];
        for (int i = 0; i < list.size(); ++i) {
            tagNodeArray[i] = (TagNode)list.get(i);
        }
        return tagNodeArray;
    }

    public List getAllElementsList(boolean bl) {
        return this.getElementList(new TagAllCondition(), bl);
    }

    public TagNode[] getAllElements(boolean bl) {
        return this.getElements(new TagAllCondition(), bl);
    }

    public TagNode findElementByName(String string, boolean bl) {
        return this.findElement(new TagNodeNameCondition(string), bl);
    }

    public List getElementListByName(String string, boolean bl) {
        return this.getElementList(new TagNodeNameCondition(string), bl);
    }

    public TagNode[] getElementsByName(String string, boolean bl) {
        return this.getElements(new TagNodeNameCondition(string), bl);
    }

    public TagNode findElementHavingAttribute(String string, boolean bl) {
        return this.findElement(new TagNodeAttExistsCondition(string), bl);
    }

    public List getElementListHavingAttribute(String string, boolean bl) {
        return this.getElementList(new TagNodeAttExistsCondition(string), bl);
    }

    public TagNode[] getElementsHavingAttribute(String string, boolean bl) {
        return this.getElements(new TagNodeAttExistsCondition(string), bl);
    }

    public TagNode findElementByAttValue(String string, String string2, boolean bl, boolean bl2) {
        return this.findElement(new TagNodeAttValueCondition(string, string2, bl2), bl);
    }

    public List getElementListByAttValue(String string, String string2, boolean bl, boolean bl2) {
        return this.getElementList(new TagNodeAttValueCondition(string, string2, bl2), bl);
    }

    public TagNode[] getElementsByAttValue(String string, String string2, boolean bl, boolean bl2) {
        return this.getElements(new TagNodeAttValueCondition(string, string2, bl2), bl);
    }

    public Object[] evaluateXPath(String string) throws XPatherException {
        return new XPather(string).evaluateAgainstNode(this);
    }

    public boolean removeFromTree() {
        return this.parent != null ? this.parent.removeChild(this) : false;
    }

    public boolean removeChild(Object object) {
        return this.children.remove(object);
    }

    void addItemForMoving(Object object) {
        if (this.itemsToMove == null) {
            this.itemsToMove = new ArrayList();
        }
        this.itemsToMove.add(object);
    }

    List getItemsToMove() {
        return this.itemsToMove;
    }

    void setItemsToMove(List list) {
        this.itemsToMove = list;
    }

    boolean isFormed() {
        return this.isFormed;
    }

    void setFormed(boolean bl) {
        this.isFormed = bl;
    }

    void setFormed() {
        this.setFormed(true);
    }

    void transformAttributes(TagTransformation tagTransformation) {
        boolean bl = tagTransformation.isPreserveSourceAttributes();
        boolean bl2 = tagTransformation.hasAttributeTransformations();
        if (bl2 || !bl) {
            LinkedHashMap<String, String> linkedHashMap;
            LinkedHashMap<String, String> linkedHashMap2 = linkedHashMap = bl ? new LinkedHashMap<String, String>(this.attributes) : new LinkedHashMap();
            if (bl2) {
                Map map = tagTransformation.getAttributeTransformations();
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    String string = (String)entry.getKey();
                    String string2 = (String)entry.getValue();
                    if (string2 == null) {
                        linkedHashMap.remove(string);
                        continue;
                    }
                    String string3 = Utils.evaluateTemplate(string2, this.attributes);
                    linkedHashMap.put(string, string3);
                }
            }
            this.attributes = linkedHashMap;
        }
    }

    public void serialize(XmlSerializer xmlSerializer, Writer writer) throws IOException {
        xmlSerializer.serialize(this, writer);
    }

    public TagNode makeCopy() {
        TagNode tagNode = new TagNode(this.name, this.cleaner);
        tagNode.attributes.putAll(this.attributes);
        return tagNode;
    }

    public class TagNodeAttValueCondition
    implements ITagNodeCondition {
        private String attName;
        private String attValue;
        private boolean isCaseSensitive;

        public TagNodeAttValueCondition(String string, String string2, boolean bl) {
            this.attName = string;
            this.attValue = string2;
            this.isCaseSensitive = bl;
        }

        public boolean satisfy(TagNode tagNode) {
            if (tagNode == null || this.attName == null || this.attValue == null) {
                return false;
            }
            return this.isCaseSensitive ? this.attValue.equals(tagNode.getAttributeByName(this.attName)) : this.attValue.equalsIgnoreCase(tagNode.getAttributeByName(this.attName));
        }
    }

    public class TagNodeAttExistsCondition
    implements ITagNodeCondition {
        private String attName;

        public TagNodeAttExistsCondition(String string) {
            this.attName = string;
        }

        public boolean satisfy(TagNode tagNode) {
            return tagNode == null ? false : tagNode.attributes.containsKey(this.attName.toLowerCase());
        }
    }

    public class TagNodeNameCondition
    implements ITagNodeCondition {
        private String name;

        public TagNodeNameCondition(String string) {
            this.name = string;
        }

        public boolean satisfy(TagNode tagNode) {
            return tagNode == null ? false : tagNode.name.equalsIgnoreCase(this.name);
        }
    }

    public class TagAllCondition
    implements ITagNodeCondition {
        public boolean satisfy(TagNode tagNode) {
            return true;
        }
    }

    public static interface ITagNodeCondition {
        public boolean satisfy(TagNode var1);
    }
}

