/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.XPatherException;

public class XPather {
    private String[] tokenArray;

    public XPather(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/()[]\"'=<>", true);
        int n = stringTokenizer.countTokens();
        this.tokenArray = new String[n];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            this.tokenArray[n2++] = stringTokenizer.nextToken();
        }
    }

    public Object[] evaluateAgainstNode(TagNode tagNode) throws XPatherException {
        if (tagNode == null) {
            throw new XPatherException("Cannot evaluate XPath expression against null value!");
        }
        Collection collection = this.evaluateAgainst(this.singleton(tagNode), 0, this.tokenArray.length - 1, false, 1, 0, false, null);
        Object[] objectArray = new Object[collection.size()];
        Iterator iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            objectArray[n++] = iterator.next();
        }
        return objectArray;
    }

    private void throwStandardException() throws XPatherException {
        throw new XPatherException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Collection evaluateAgainst(Collection collection, int n, int n2, boolean bl, int n3, int n4, boolean bl2, Collection collection2) throws XPatherException {
        if (n < 0 || n2 >= this.tokenArray.length || n > n2) return collection;
        if ("".equals(this.tokenArray[n].trim())) {
            return this.evaluateAgainst(collection, n + 1, n2, bl, n3, n4, bl2, collection2);
        }
        if (this.isToken("(", n)) {
            int n5 = this.findClosingIndex(n, n2);
            if (n5 > 0) {
                Collection collection3 = this.evaluateAgainst(collection, n + 1, n5 - 1, false, n3, n4, bl2, collection2);
                return this.evaluateAgainst(collection3, n5 + 1, n2, false, n3, n4, bl2, collection2);
            }
            this.throwStandardException();
            throw new XPatherException();
        } else if (this.isToken("[", n)) {
            int n6 = this.findClosingIndex(n, n2);
            if (n6 > 0 && collection instanceof Collection) {
                Collection collection4 = this.filterByCondition(collection, n + 1, n6 - 1);
                return this.evaluateAgainst(collection4, n6 + 1, n2, false, n3, n4, bl2, collection2);
            }
            this.throwStandardException();
            throw new XPatherException();
        } else if (this.isToken("\"", n) || this.isToken("'", n)) {
            int n7 = this.findClosingIndex(n, n2);
            if (n7 > n) {
                Collection collection5 = this.singleton(this.flatten(n + 1, n7 - 1));
                return this.evaluateAgainst(collection5, n7 + 1, n2, false, n3, n4, bl2, collection2);
            }
            this.throwStandardException();
            throw new XPatherException();
        } else {
            if ((this.isToken("=", n) || this.isToken("<", n) || this.isToken(">", n)) && bl2) {
                boolean bl3;
                if (this.isToken("=", n + 1) && (this.isToken("<", n) || this.isToken(">", n))) {
                    Collection collection6 = this.evaluateAgainst(collection2, n + 2, n2, false, n3, n4, bl2, collection2);
                    bl3 = this.evaluateLogic(collection, collection6, this.tokenArray[n] + this.tokenArray[n + 1]);
                    return this.singleton(new Boolean(bl3));
                } else {
                    Collection collection7 = this.evaluateAgainst(collection2, n + 1, n2, false, n3, n4, bl2, collection2);
                    bl3 = this.evaluateLogic(collection, collection7, this.tokenArray[n]);
                }
                return this.singleton(new Boolean(bl3));
            }
            if (this.isToken("/", n)) {
                boolean bl4 = this.isToken("/", n + 1);
                if (bl4) {
                    ++n;
                }
                if (n < n2) {
                    int n8 = this.findClosingIndex(n, n2) - 1;
                    if (n8 <= n) {
                        n8 = n2;
                    }
                    Collection collection8 = this.evaluateAgainst(collection, n + 1, n8, bl4, 1, n4, bl2, collection2);
                    return this.evaluateAgainst(collection8, n8 + 1, n2, false, 1, n4, bl2, collection2);
                }
                this.throwStandardException();
                throw new XPatherException();
            } else {
                if (this.isFunctionCall(n, n2)) {
                    int n9 = this.findClosingIndex(n + 1, n2);
                    Collection collection9 = this.evaluateFunction(collection, n, n2, n3, n4, bl2);
                    return this.evaluateAgainst(collection9, n9 + 1, n2, false, 1, n4, bl2, collection2);
                }
                if (this.isValidInteger(this.tokenArray[n])) {
                    Collection collection10 = this.singleton(new Integer(this.tokenArray[n]));
                    return this.evaluateAgainst(collection10, n + 1, n2, false, n3, n4, bl2, collection2);
                }
                if (!this.isValidDouble(this.tokenArray[n])) return this.getElementsByName(collection, n, n2, bl, bl2);
                Collection collection11 = this.singleton(new Double(this.tokenArray[n]));
                return this.evaluateAgainst(collection11, n + 1, n2, false, n3, n4, bl2, collection2);
            }
        }
    }

    private String flatten(int n, int n2) {
        if (n <= n2) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = n; i <= n2; ++i) {
                stringBuffer.append(this.tokenArray[i]);
            }
            return stringBuffer.toString();
        }
        return "";
    }

    private boolean isValidInteger(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private boolean isValidDouble(String string) {
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private boolean isIdentifier(String string) {
        if (string == null) {
            return false;
        }
        if ((string = string.trim()).length() > 0) {
            if (!Character.isLetter(string.charAt(0))) {
                return false;
            }
            for (int i = 1; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '_' || c == '-' || Character.isLetterOrDigit(c)) continue;
                return false;
            }
        }
        return false;
    }

    private boolean isFunctionCall(int n, int n2) {
        if (!this.isIdentifier(this.tokenArray[n]) && !this.isToken("(", n + 1)) {
            return false;
        }
        return this.findClosingIndex(n + 1, n2) > n + 1;
    }

    private Collection evaluateFunction(Collection collection, int n, int n2, int n3, int n4, boolean bl) throws XPatherException {
        String string = this.tokenArray[n].trim();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n5 = collection.size();
        Iterator iterator = collection.iterator();
        int n6 = 0;
        while (iterator.hasNext()) {
            Collection collection2;
            Object e = iterator.next();
            ++n6;
            if ("last".equals(string)) {
                arrayList.add(new Integer(bl ? n4 : n5));
                continue;
            }
            if ("position".equals(string)) {
                arrayList.add(new Integer(bl ? n3 : n6));
                continue;
            }
            if ("text".equals(string)) {
                if (e instanceof TagNode) {
                    arrayList.add(((TagNode)e).getText());
                    continue;
                }
                if (!(e instanceof String)) continue;
                arrayList.add(e.toString());
                continue;
            }
            if ("count".equals(string)) {
                collection2 = this.evaluateAgainst(collection, n + 2, n2 - 1, false, n3, 0, bl, null);
                arrayList.add(new Integer(collection2.size()));
                continue;
            }
            if ("data".equals(string)) {
                collection2 = this.evaluateAgainst(collection, n + 2, n2 - 1, false, n3, 0, bl, null);
                Iterator iterator2 = collection2.iterator();
                while (iterator2.hasNext()) {
                    Object e2 = iterator2.next();
                    if (e2 instanceof TagNode) {
                        arrayList.add(((TagNode)e2).getText());
                        continue;
                    }
                    if (!(e2 instanceof String)) continue;
                    arrayList.add(e2.toString());
                }
                continue;
            }
            throw new XPatherException("Unknown function " + string + "!");
        }
        return arrayList;
    }

    private Collection filterByCondition(Collection collection, int n, int n2) throws XPatherException {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = collection.iterator();
        int n3 = 0;
        int n4 = collection.size();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            ArrayList arrayList2 = new ArrayList(this.evaluateAgainst(this.singleton(e), n, n2, false, ++n3, n4, true, this.singleton(e)));
            if (arrayList2.size() < 1) continue;
            Object e2 = arrayList2.get(0);
            if (e2 instanceof Boolean) {
                if (!((Boolean)e2).booleanValue()) continue;
                arrayList.add(e);
                continue;
            }
            if (e2 instanceof Integer) {
                if ((Integer)e2 != n3) continue;
                arrayList.add(e);
                continue;
            }
            arrayList.add(e);
        }
        return arrayList;
    }

    private boolean isToken(String string, int n) {
        int n2 = this.tokenArray.length;
        return n >= 0 && n < n2 && this.tokenArray[n].trim().equals(string.trim());
    }

    private int findClosingIndex(int n, int n2) {
        block16: {
            String string;
            block18: {
                block17: {
                    if (n >= n2) break block16;
                    string = this.tokenArray[n];
                    if (!"\"".equals(string)) break block17;
                    for (int i = n + 1; i <= n2; ++i) {
                        if (!"\"".equals(this.tokenArray[i])) continue;
                        return i;
                    }
                    break block16;
                }
                if (!"'".equals(string)) break block18;
                for (int i = n + 1; i <= n2; ++i) {
                    if (!"'".equals(this.tokenArray[i])) continue;
                    return i;
                }
                break block16;
            }
            if (!"(".equals(string) && !"[".equals(string) && !"/".equals(string)) break block16;
            boolean bl = true;
            boolean bl2 = true;
            int n3 = "(".equals(string) ? 1 : 0;
            int n4 = "[".equals(string) ? 1 : 0;
            int n5 = "/".equals(string) ? 1 : 0;
            for (int i = n + 1; i <= n2; ++i) {
                if ("\"".equals(this.tokenArray[i])) {
                    bl = !bl;
                } else if ("'".equals(this.tokenArray[i])) {
                    bl2 = !bl2;
                } else if ("(".equals(this.tokenArray[i]) && bl && bl2) {
                    ++n3;
                } else if (")".equals(this.tokenArray[i]) && bl && bl2) {
                    --n3;
                } else if ("[".equals(this.tokenArray[i]) && bl && bl2) {
                    ++n4;
                } else if ("]".equals(this.tokenArray[i]) && bl && bl2) {
                    --n4;
                } else if ("/".equals(this.tokenArray[i]) && bl && bl2 && n3 == 0 && n4 == 0) {
                    --n5;
                }
                if (!bl || !bl2 || n3 != 0 || n4 != 0 || n5 != 0) continue;
                return i;
            }
        }
        return -1;
    }

    private boolean isAtt(String string) {
        return string != null && string.length() > 1 && string.startsWith("@");
    }

    private Collection singleton(Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        return arrayList;
    }

    private Collection getElementsByName(Collection linkedHashSet, int n, int n2, boolean bl, boolean bl2) throws XPatherException {
        String string = this.tokenArray[n].trim();
        if (this.isAtt(string)) {
            TagNode tagNode;
            Object e;
            Iterator iterator;
            LinkedHashSet linkedHashSet2;
            string = string.substring(1);
            ArrayList arrayList = new ArrayList();
            if (bl) {
                linkedHashSet2 = new LinkedHashSet();
                iterator = linkedHashSet.iterator();
                while (iterator.hasNext()) {
                    e = iterator.next();
                    if (!(e instanceof TagNode)) continue;
                    tagNode = (TagNode)e;
                    linkedHashSet2.addAll(tagNode.getAllElementsList(true));
                }
            } else {
                linkedHashSet2 = linkedHashSet;
            }
            iterator = linkedHashSet2.iterator();
            while (iterator.hasNext()) {
                e = iterator.next();
                if (e instanceof TagNode) {
                    tagNode = (TagNode)e;
                    if ("*".equals(string)) {
                        arrayList.addAll(this.evaluateAgainst(tagNode.getAttributes().values(), n + 1, n2, false, 1, 1, bl2, null));
                        continue;
                    }
                    String string2 = tagNode.getAttributeByName(string);
                    if (string2 == null) continue;
                    arrayList.addAll(this.evaluateAgainst(this.singleton(string2), n + 1, n2, false, 1, 1, bl2, null));
                    continue;
                }
                this.throwStandardException();
            }
            return arrayList;
        }
        LinkedHashSet<TagNode> linkedHashSet3 = new LinkedHashSet<TagNode>();
        Iterator iterator = linkedHashSet.iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof TagNode) {
                Object object;
                TagNode tagNode = (TagNode)e;
                ++n3;
                boolean bl3 = ".".equals(string);
                boolean bl4 = "..".equals(string);
                boolean bl5 = "*".equals(string);
                Collection collection = bl3 ? this.singleton(tagNode) : (bl4 ? ((object = tagNode.getParent()) != null ? this.singleton(object) : new ArrayList()) : (bl5 ? tagNode.getChildTagList() : tagNode.getElementListByName(string, false)));
                object = new LinkedHashSet(collection);
                Collection collection2 = this.evaluateAgainst((Collection)object, n + 1, n2, false, n3, ((HashSet)object).size(), bl2, null);
                if (bl) {
                    List list = tagNode.getChildTagList();
                    if (bl3 || bl4 || bl5) {
                        linkedHashSet3.addAll(collection2);
                    }
                    Iterator iterator2 = list.iterator();
                    while (iterator2.hasNext()) {
                        TagNode tagNode2 = (TagNode)iterator2.next();
                        Collection collection3 = this.getElementsByName(this.singleton(tagNode2), n, n2, bl, bl2);
                        if (!bl3 && !bl4 && !bl5 && collection2.contains(tagNode2)) {
                            linkedHashSet3.add(tagNode2);
                        }
                        linkedHashSet3.addAll(collection3);
                    }
                    continue;
                }
                linkedHashSet3.addAll(collection2);
                continue;
            }
            this.throwStandardException();
        }
        return linkedHashSet3;
    }

    private boolean evaluateLogic(Collection collection, Collection collection2, String string) {
        if (collection == null || collection.size() == 0 || collection2 == null || collection2.size() == 0) {
            return false;
        }
        Object e = collection.iterator().next();
        Object e2 = collection2.iterator().next();
        if (e instanceof Number && e2 instanceof Number) {
            double d = ((Number)e).doubleValue();
            double d2 = ((Number)e2).doubleValue();
            if ("=".equals(string)) {
                return d == d2;
            }
            if ("<".equals(string)) {
                return d < d2;
            }
            if (">".equals(string)) {
                return d > d2;
            }
            if ("<=".equals(string)) {
                return d <= d2;
            }
            if (">=".equals(string)) {
                return d >= d2;
            }
        } else {
            String string2 = this.toText(e);
            String string3 = this.toText(e2);
            int n = string2.compareTo(string3);
            if ("=".equals(string)) {
                return n == 0;
            }
            if ("<".equals(string)) {
                return n < 0;
            }
            if (">".equals(string)) {
                return n > 0;
            }
            if ("<=".equals(string)) {
                return n <= 0;
            }
            if (">=".equals(string)) {
                return n >= 0;
            }
        }
        return false;
    }

    private String toText(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof TagNode) {
            return ((TagNode)object).getText().toString();
        }
        return object.toString();
    }
}

