/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.internal.scripting;

import org.apache.commons.lang.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.script.service.ScriptService;

@Component(value="model")
public class ModelScriptService
implements ScriptService {
    @Requirement
    private ComponentManager componentManager;

    public DocumentReference createDocumentReference(String wiki, String space, String page) {
        return this.createDocumentReference(wiki, space, page, "currentmixed/reference");
    }

    public DocumentReference createDocumentReference(String wiki, String space, String page, String hint) {
        DocumentReference documentReference;
        EntityReference reference = null;
        if (!StringUtils.isEmpty((String)wiki)) {
            reference = new EntityReference(wiki, EntityType.WIKI);
        }
        if (!StringUtils.isEmpty((String)space)) {
            reference = new EntityReference(space, EntityType.SPACE, reference);
        }
        if (!StringUtils.isEmpty((String)page)) {
            reference = new EntityReference(page, EntityType.DOCUMENT, reference);
        }
        try {
            documentReference = ((DocumentReferenceResolver)this.componentManager.lookup(DocumentReferenceResolver.class, hint)).resolve(reference, new Object[0]);
        }
        catch (ComponentLookupException e) {
            documentReference = null;
        }
        return documentReference;
    }

    public DocumentReference resolveDocument(String stringRepresentation) {
        return this.resolveDocument(stringRepresentation, "currentmixed");
    }

    public DocumentReference resolveDocument(String stringRepresentation, String hint) {
        DocumentReference result;
        try {
            result = ((DocumentReferenceResolver)this.componentManager.lookup(DocumentReferenceResolver.class, hint)).resolve(stringRepresentation, new Object[0]);
        }
        catch (ComponentLookupException e) {
            result = null;
        }
        return result;
    }

    public String serialize(EntityReference reference) {
        return this.serialize(reference, "compact");
    }

    public String serialize(EntityReference reference, String hint) {
        String result;
        try {
            result = (String)((EntityReferenceSerializer)this.componentManager.lookup(EntityReferenceSerializer.class, hint)).serialize(reference, new Object[0]);
        }
        catch (ComponentLookupException e) {
            result = null;
        }
        return result;
    }
}

